
/**
 * Client
**/

import * as runtime from './runtime/library.js';
import $Types = runtime.Types // general types
import $Public = runtime.Types.Public
import $Utils = runtime.Types.Utils
import $Extensions = runtime.Types.Extensions
import $Result = runtime.Types.Result

export type PrismaPromise<T> = $Public.PrismaPromise<T>


/**
 * Model User
 * 
 */
export type User = $Result.DefaultSelection<Prisma.$UserPayload>
/**
 * Model Category
 * 
 */
export type Category = $Result.DefaultSelection<Prisma.$CategoryPayload>
/**
 * Model Course
 * 
 */
export type Course = $Result.DefaultSelection<Prisma.$CoursePayload>
/**
 * Model qnModelSet
 * 
 */
export type qnModelSet = $Result.DefaultSelection<Prisma.$qnModelSetPayload>
/**
 * Model userGivenExamSet
 * 
 */
export type userGivenExamSet = $Result.DefaultSelection<Prisma.$userGivenExamSetPayload>
/**
 * Model userSelectedCourse
 * 
 */
export type userSelectedCourse = $Result.DefaultSelection<Prisma.$userSelectedCoursePayload>

/**
 * Enums
 */
export namespace $Enums {
  export const Status: {
  SHOW: 'SHOW',
  HIDE: 'HIDE'
};

export type Status = (typeof Status)[keyof typeof Status]


export const Role: {
  USER: 'USER',
  ADMIN: 'ADMIN'
};

export type Role = (typeof Role)[keyof typeof Role]

}

export type Status = $Enums.Status

export const Status: typeof $Enums.Status

export type Role = $Enums.Role

export const Role: typeof $Enums.Role

/**
 * ##  Prisma Client ʲˢ
 *
 * Type-safe database client for TypeScript & Node.js
 * @example
 * ```
 * const prisma = new PrismaClient()
 * // Fetch zero or more Users
 * const users = await prisma.user.findMany()
 * ```
 *
 *
 * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
 */
export class PrismaClient<
  ClientOptions extends Prisma.PrismaClientOptions = Prisma.PrismaClientOptions,
  U = 'log' extends keyof ClientOptions ? ClientOptions['log'] extends Array<Prisma.LogLevel | Prisma.LogDefinition> ? Prisma.GetEvents<ClientOptions['log']> : never : never,
  ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs
> {
  [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['other'] }

    /**
   * ##  Prisma Client ʲˢ
   *
   * Type-safe database client for TypeScript & Node.js
   * @example
   * ```
   * const prisma = new PrismaClient()
   * // Fetch zero or more Users
   * const users = await prisma.user.findMany()
   * ```
   *
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
   */

  constructor(optionsArg ?: Prisma.Subset<ClientOptions, Prisma.PrismaClientOptions>);
  $on<V extends U>(eventType: V, callback: (event: V extends 'query' ? Prisma.QueryEvent : Prisma.LogEvent) => void): PrismaClient;

  /**
   * Connect with the database
   */
  $connect(): $Utils.JsPromise<void>;

  /**
   * Disconnect from the database
   */
  $disconnect(): $Utils.JsPromise<void>;

  /**
   * Add a middleware
   * @deprecated since 4.16.0. For new code, prefer client extensions instead.
   * @see https://pris.ly/d/extensions
   */
  $use(cb: Prisma.Middleware): void

/**
   * Executes a prepared raw query and returns the number of affected rows.
   * @example
   * ```
   * const result = await prisma.$executeRaw`UPDATE User SET cool = ${true} WHERE email = ${'user@email.com'};`
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Executes a raw query and returns the number of affected rows.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$executeRawUnsafe('UPDATE User SET cool = $1 WHERE email = $2 ;', true, 'user@email.com')
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Performs a prepared raw query and returns the `SELECT` data.
   * @example
   * ```
   * const result = await prisma.$queryRaw`SELECT * FROM User WHERE id = ${1} OR email = ${'user@email.com'};`
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<T>;

  /**
   * Performs a raw query and returns the `SELECT` data.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$queryRawUnsafe('SELECT * FROM User WHERE id = $1 OR email = $2;', 1, 'user@email.com')
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<T>;


  /**
   * Allows the running of a sequence of read/write operations that are guaranteed to either succeed or fail as a whole.
   * @example
   * ```
   * const [george, bob, alice] = await prisma.$transaction([
   *   prisma.user.create({ data: { name: 'George' } }),
   *   prisma.user.create({ data: { name: 'Bob' } }),
   *   prisma.user.create({ data: { name: 'Alice' } }),
   * ])
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/concepts/components/prisma-client/transactions).
   */
  $transaction<P extends Prisma.PrismaPromise<any>[]>(arg: [...P], options?: { isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<runtime.Types.Utils.UnwrapTuple<P>>

  $transaction<R>(fn: (prisma: Omit<PrismaClient, runtime.ITXClientDenyList>) => $Utils.JsPromise<R>, options?: { maxWait?: number, timeout?: number, isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<R>


  $extends: $Extensions.ExtendsHook<"extends", Prisma.TypeMapCb<ClientOptions>, ExtArgs, $Utils.Call<Prisma.TypeMapCb<ClientOptions>, {
    extArgs: ExtArgs
  }>>

      /**
   * `prisma.user`: Exposes CRUD operations for the **User** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Users
    * const users = await prisma.user.findMany()
    * ```
    */
  get user(): Prisma.UserDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.category`: Exposes CRUD operations for the **Category** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Categories
    * const categories = await prisma.category.findMany()
    * ```
    */
  get category(): Prisma.CategoryDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.course`: Exposes CRUD operations for the **Course** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Courses
    * const courses = await prisma.course.findMany()
    * ```
    */
  get course(): Prisma.CourseDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.qnModelSet`: Exposes CRUD operations for the **qnModelSet** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more QnModelSets
    * const qnModelSets = await prisma.qnModelSet.findMany()
    * ```
    */
  get qnModelSet(): Prisma.qnModelSetDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.userGivenExamSet`: Exposes CRUD operations for the **userGivenExamSet** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more UserGivenExamSets
    * const userGivenExamSets = await prisma.userGivenExamSet.findMany()
    * ```
    */
  get userGivenExamSet(): Prisma.userGivenExamSetDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.userSelectedCourse`: Exposes CRUD operations for the **userSelectedCourse** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more UserSelectedCourses
    * const userSelectedCourses = await prisma.userSelectedCourse.findMany()
    * ```
    */
  get userSelectedCourse(): Prisma.userSelectedCourseDelegate<ExtArgs, ClientOptions>;
}

export namespace Prisma {
  export import DMMF = runtime.DMMF

  export type PrismaPromise<T> = $Public.PrismaPromise<T>

  /**
   * Validator
   */
  export import validator = runtime.Public.validator

  /**
   * Prisma Errors
   */
  export import PrismaClientKnownRequestError = runtime.PrismaClientKnownRequestError
  export import PrismaClientUnknownRequestError = runtime.PrismaClientUnknownRequestError
  export import PrismaClientRustPanicError = runtime.PrismaClientRustPanicError
  export import PrismaClientInitializationError = runtime.PrismaClientInitializationError
  export import PrismaClientValidationError = runtime.PrismaClientValidationError

  /**
   * Re-export of sql-template-tag
   */
  export import sql = runtime.sqltag
  export import empty = runtime.empty
  export import join = runtime.join
  export import raw = runtime.raw
  export import Sql = runtime.Sql



  /**
   * Decimal.js
   */
  export import Decimal = runtime.Decimal

  export type DecimalJsLike = runtime.DecimalJsLike

  /**
   * Metrics
   */
  export type Metrics = runtime.Metrics
  export type Metric<T> = runtime.Metric<T>
  export type MetricHistogram = runtime.MetricHistogram
  export type MetricHistogramBucket = runtime.MetricHistogramBucket

  /**
  * Extensions
  */
  export import Extension = $Extensions.UserArgs
  export import getExtensionContext = runtime.Extensions.getExtensionContext
  export import Args = $Public.Args
  export import Payload = $Public.Payload
  export import Result = $Public.Result
  export import Exact = $Public.Exact

  /**
   * Prisma Client JS version: 6.7.0
   * Query Engine version: 3cff47a7f5d65c3ea74883f1d736e41d68ce91ed
   */
  export type PrismaVersion = {
    client: string
  }

  export const prismaVersion: PrismaVersion

  /**
   * Utility Types
   */


  export import JsonObject = runtime.JsonObject
  export import JsonArray = runtime.JsonArray
  export import JsonValue = runtime.JsonValue
  export import InputJsonObject = runtime.InputJsonObject
  export import InputJsonArray = runtime.InputJsonArray
  export import InputJsonValue = runtime.InputJsonValue

  /**
   * Types of the values used to represent different kinds of `null` values when working with JSON fields.
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  namespace NullTypes {
    /**
    * Type of `Prisma.DbNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.DbNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class DbNull {
      private DbNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.JsonNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.JsonNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class JsonNull {
      private JsonNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.AnyNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.AnyNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class AnyNull {
      private AnyNull: never
      private constructor()
    }
  }

  /**
   * Helper for filtering JSON entries that have `null` on the database (empty on the db)
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const DbNull: NullTypes.DbNull

  /**
   * Helper for filtering JSON entries that have JSON `null` values (not empty on the db)
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const JsonNull: NullTypes.JsonNull

  /**
   * Helper for filtering JSON entries that are `Prisma.DbNull` or `Prisma.JsonNull`
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const AnyNull: NullTypes.AnyNull

  type SelectAndInclude = {
    select: any
    include: any
  }

  type SelectAndOmit = {
    select: any
    omit: any
  }

  /**
   * Get the type of the value, that the Promise holds.
   */
  export type PromiseType<T extends PromiseLike<any>> = T extends PromiseLike<infer U> ? U : T;

  /**
   * Get the return type of a function which returns a Promise.
   */
  export type PromiseReturnType<T extends (...args: any) => $Utils.JsPromise<any>> = PromiseType<ReturnType<T>>

  /**
   * From T, pick a set of properties whose keys are in the union K
   */
  type Prisma__Pick<T, K extends keyof T> = {
      [P in K]: T[P];
  };


  export type Enumerable<T> = T | Array<T>;

  export type RequiredKeys<T> = {
    [K in keyof T]-?: {} extends Prisma__Pick<T, K> ? never : K
  }[keyof T]

  export type TruthyKeys<T> = keyof {
    [K in keyof T as T[K] extends false | undefined | null ? never : K]: K
  }

  export type TrueKeys<T> = TruthyKeys<Prisma__Pick<T, RequiredKeys<T>>>

  /**
   * Subset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection
   */
  export type Subset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never;
  };

  /**
   * SelectSubset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection.
   * Additionally, it validates, if both select and include are present. If the case, it errors.
   */
  export type SelectSubset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    (T extends SelectAndInclude
      ? 'Please either choose `select` or `include`.'
      : T extends SelectAndOmit
        ? 'Please either choose `select` or `omit`.'
        : {})

  /**
   * Subset + Intersection
   * @desc From `T` pick properties that exist in `U` and intersect `K`
   */
  export type SubsetIntersection<T, U, K> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    K

  type Without<T, U> = { [P in Exclude<keyof T, keyof U>]?: never };

  /**
   * XOR is needed to have a real mutually exclusive union type
   * https://stackoverflow.com/questions/42123407/does-typescript-support-mutually-exclusive-types
   */
  type XOR<T, U> =
    T extends object ?
    U extends object ?
      (Without<T, U> & U) | (Without<U, T> & T)
    : U : T


  /**
   * Is T a Record?
   */
  type IsObject<T extends any> = T extends Array<any>
  ? False
  : T extends Date
  ? False
  : T extends Uint8Array
  ? False
  : T extends BigInt
  ? False
  : T extends object
  ? True
  : False


  /**
   * If it's T[], return T
   */
  export type UnEnumerate<T extends unknown> = T extends Array<infer U> ? U : T

  /**
   * From ts-toolbelt
   */

  type __Either<O extends object, K extends Key> = Omit<O, K> &
    {
      // Merge all but K
      [P in K]: Prisma__Pick<O, P & keyof O> // With K possibilities
    }[K]

  type EitherStrict<O extends object, K extends Key> = Strict<__Either<O, K>>

  type EitherLoose<O extends object, K extends Key> = ComputeRaw<__Either<O, K>>

  type _Either<
    O extends object,
    K extends Key,
    strict extends Boolean
  > = {
    1: EitherStrict<O, K>
    0: EitherLoose<O, K>
  }[strict]

  type Either<
    O extends object,
    K extends Key,
    strict extends Boolean = 1
  > = O extends unknown ? _Either<O, K, strict> : never

  export type Union = any

  type PatchUndefined<O extends object, O1 extends object> = {
    [K in keyof O]: O[K] extends undefined ? At<O1, K> : O[K]
  } & {}

  /** Helper Types for "Merge" **/
  export type IntersectOf<U extends Union> = (
    U extends unknown ? (k: U) => void : never
  ) extends (k: infer I) => void
    ? I
    : never

  export type Overwrite<O extends object, O1 extends object> = {
      [K in keyof O]: K extends keyof O1 ? O1[K] : O[K];
  } & {};

  type _Merge<U extends object> = IntersectOf<Overwrite<U, {
      [K in keyof U]-?: At<U, K>;
  }>>;

  type Key = string | number | symbol;
  type AtBasic<O extends object, K extends Key> = K extends keyof O ? O[K] : never;
  type AtStrict<O extends object, K extends Key> = O[K & keyof O];
  type AtLoose<O extends object, K extends Key> = O extends unknown ? AtStrict<O, K> : never;
  export type At<O extends object, K extends Key, strict extends Boolean = 1> = {
      1: AtStrict<O, K>;
      0: AtLoose<O, K>;
  }[strict];

  export type ComputeRaw<A extends any> = A extends Function ? A : {
    [K in keyof A]: A[K];
  } & {};

  export type OptionalFlat<O> = {
    [K in keyof O]?: O[K];
  } & {};

  type _Record<K extends keyof any, T> = {
    [P in K]: T;
  };

  // cause typescript not to expand types and preserve names
  type NoExpand<T> = T extends unknown ? T : never;

  // this type assumes the passed object is entirely optional
  type AtLeast<O extends object, K extends string> = NoExpand<
    O extends unknown
    ? | (K extends keyof O ? { [P in K]: O[P] } & O : O)
      | {[P in keyof O as P extends K ? P : never]-?: O[P]} & O
    : never>;

  type _Strict<U, _U = U> = U extends unknown ? U & OptionalFlat<_Record<Exclude<Keys<_U>, keyof U>, never>> : never;

  export type Strict<U extends object> = ComputeRaw<_Strict<U>>;
  /** End Helper Types for "Merge" **/

  export type Merge<U extends object> = ComputeRaw<_Merge<Strict<U>>>;

  /**
  A [[Boolean]]
  */
  export type Boolean = True | False

  // /**
  // 1
  // */
  export type True = 1

  /**
  0
  */
  export type False = 0

  export type Not<B extends Boolean> = {
    0: 1
    1: 0
  }[B]

  export type Extends<A1 extends any, A2 extends any> = [A1] extends [never]
    ? 0 // anything `never` is false
    : A1 extends A2
    ? 1
    : 0

  export type Has<U extends Union, U1 extends Union> = Not<
    Extends<Exclude<U1, U>, U1>
  >

  export type Or<B1 extends Boolean, B2 extends Boolean> = {
    0: {
      0: 0
      1: 1
    }
    1: {
      0: 1
      1: 1
    }
  }[B1][B2]

  export type Keys<U extends Union> = U extends unknown ? keyof U : never

  type Cast<A, B> = A extends B ? A : B;

  export const type: unique symbol;



  /**
   * Used by group by
   */

  export type GetScalarType<T, O> = O extends object ? {
    [P in keyof T]: P extends keyof O
      ? O[P]
      : never
  } : never

  type FieldPaths<
    T,
    U = Omit<T, '_avg' | '_sum' | '_count' | '_min' | '_max'>
  > = IsObject<T> extends True ? U : T

  type GetHavingFields<T> = {
    [K in keyof T]: Or<
      Or<Extends<'OR', K>, Extends<'AND', K>>,
      Extends<'NOT', K>
    > extends True
      ? // infer is only needed to not hit TS limit
        // based on the brilliant idea of Pierre-Antoine Mills
        // https://github.com/microsoft/TypeScript/issues/30188#issuecomment-478938437
        T[K] extends infer TK
        ? GetHavingFields<UnEnumerate<TK> extends object ? Merge<UnEnumerate<TK>> : never>
        : never
      : {} extends FieldPaths<T[K]>
      ? never
      : K
  }[keyof T]

  /**
   * Convert tuple to union
   */
  type _TupleToUnion<T> = T extends (infer E)[] ? E : never
  type TupleToUnion<K extends readonly any[]> = _TupleToUnion<K>
  type MaybeTupleToUnion<T> = T extends any[] ? TupleToUnion<T> : T

  /**
   * Like `Pick`, but additionally can also accept an array of keys
   */
  type PickEnumerable<T, K extends Enumerable<keyof T> | keyof T> = Prisma__Pick<T, MaybeTupleToUnion<K>>

  /**
   * Exclude all keys with underscores
   */
  type ExcludeUnderscoreKeys<T extends string> = T extends `_${string}` ? never : T


  export type FieldRef<Model, FieldType> = runtime.FieldRef<Model, FieldType>

  type FieldRefInputType<Model, FieldType> = Model extends never ? never : FieldRef<Model, FieldType>


  export const ModelName: {
    User: 'User',
    Category: 'Category',
    Course: 'Course',
    qnModelSet: 'qnModelSet',
    userGivenExamSet: 'userGivenExamSet',
    userSelectedCourse: 'userSelectedCourse'
  };

  export type ModelName = (typeof ModelName)[keyof typeof ModelName]


  export type Datasources = {
    db?: Datasource
  }

  interface TypeMapCb<ClientOptions = {}> extends $Utils.Fn<{extArgs: $Extensions.InternalArgs }, $Utils.Record<string, any>> {
    returns: Prisma.TypeMap<this['params']['extArgs'], ClientOptions extends { omit: infer OmitOptions } ? OmitOptions : {}>
  }

  export type TypeMap<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> = {
    globalOmitOptions: {
      omit: GlobalOmitOptions
    }
    meta: {
      modelProps: "user" | "category" | "course" | "qnModelSet" | "userGivenExamSet" | "userSelectedCourse"
      txIsolationLevel: Prisma.TransactionIsolationLevel
    }
    model: {
      User: {
        payload: Prisma.$UserPayload<ExtArgs>
        fields: Prisma.UserFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          findFirst: {
            args: Prisma.UserFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          findMany: {
            args: Prisma.UserFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>[]
          }
          create: {
            args: Prisma.UserCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          createMany: {
            args: Prisma.UserCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.UserCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>[]
          }
          delete: {
            args: Prisma.UserDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          update: {
            args: Prisma.UserUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          deleteMany: {
            args: Prisma.UserDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.UserUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.UserUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>[]
          }
          upsert: {
            args: Prisma.UserUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          aggregate: {
            args: Prisma.UserAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateUser>
          }
          groupBy: {
            args: Prisma.UserGroupByArgs<ExtArgs>
            result: $Utils.Optional<UserGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserCountArgs<ExtArgs>
            result: $Utils.Optional<UserCountAggregateOutputType> | number
          }
        }
      }
      Category: {
        payload: Prisma.$CategoryPayload<ExtArgs>
        fields: Prisma.CategoryFieldRefs
        operations: {
          findUnique: {
            args: Prisma.CategoryFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoryPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.CategoryFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoryPayload>
          }
          findFirst: {
            args: Prisma.CategoryFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoryPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.CategoryFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoryPayload>
          }
          findMany: {
            args: Prisma.CategoryFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoryPayload>[]
          }
          create: {
            args: Prisma.CategoryCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoryPayload>
          }
          createMany: {
            args: Prisma.CategoryCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.CategoryCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoryPayload>[]
          }
          delete: {
            args: Prisma.CategoryDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoryPayload>
          }
          update: {
            args: Prisma.CategoryUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoryPayload>
          }
          deleteMany: {
            args: Prisma.CategoryDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.CategoryUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.CategoryUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoryPayload>[]
          }
          upsert: {
            args: Prisma.CategoryUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CategoryPayload>
          }
          aggregate: {
            args: Prisma.CategoryAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateCategory>
          }
          groupBy: {
            args: Prisma.CategoryGroupByArgs<ExtArgs>
            result: $Utils.Optional<CategoryGroupByOutputType>[]
          }
          count: {
            args: Prisma.CategoryCountArgs<ExtArgs>
            result: $Utils.Optional<CategoryCountAggregateOutputType> | number
          }
        }
      }
      Course: {
        payload: Prisma.$CoursePayload<ExtArgs>
        fields: Prisma.CourseFieldRefs
        operations: {
          findUnique: {
            args: Prisma.CourseFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CoursePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.CourseFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CoursePayload>
          }
          findFirst: {
            args: Prisma.CourseFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CoursePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.CourseFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CoursePayload>
          }
          findMany: {
            args: Prisma.CourseFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CoursePayload>[]
          }
          create: {
            args: Prisma.CourseCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CoursePayload>
          }
          createMany: {
            args: Prisma.CourseCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.CourseCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CoursePayload>[]
          }
          delete: {
            args: Prisma.CourseDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CoursePayload>
          }
          update: {
            args: Prisma.CourseUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CoursePayload>
          }
          deleteMany: {
            args: Prisma.CourseDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.CourseUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.CourseUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CoursePayload>[]
          }
          upsert: {
            args: Prisma.CourseUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$CoursePayload>
          }
          aggregate: {
            args: Prisma.CourseAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateCourse>
          }
          groupBy: {
            args: Prisma.CourseGroupByArgs<ExtArgs>
            result: $Utils.Optional<CourseGroupByOutputType>[]
          }
          count: {
            args: Prisma.CourseCountArgs<ExtArgs>
            result: $Utils.Optional<CourseCountAggregateOutputType> | number
          }
        }
      }
      qnModelSet: {
        payload: Prisma.$qnModelSetPayload<ExtArgs>
        fields: Prisma.qnModelSetFieldRefs
        operations: {
          findUnique: {
            args: Prisma.qnModelSetFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$qnModelSetPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.qnModelSetFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$qnModelSetPayload>
          }
          findFirst: {
            args: Prisma.qnModelSetFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$qnModelSetPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.qnModelSetFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$qnModelSetPayload>
          }
          findMany: {
            args: Prisma.qnModelSetFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$qnModelSetPayload>[]
          }
          create: {
            args: Prisma.qnModelSetCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$qnModelSetPayload>
          }
          createMany: {
            args: Prisma.qnModelSetCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.qnModelSetCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$qnModelSetPayload>[]
          }
          delete: {
            args: Prisma.qnModelSetDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$qnModelSetPayload>
          }
          update: {
            args: Prisma.qnModelSetUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$qnModelSetPayload>
          }
          deleteMany: {
            args: Prisma.qnModelSetDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.qnModelSetUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.qnModelSetUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$qnModelSetPayload>[]
          }
          upsert: {
            args: Prisma.qnModelSetUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$qnModelSetPayload>
          }
          aggregate: {
            args: Prisma.QnModelSetAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateQnModelSet>
          }
          groupBy: {
            args: Prisma.qnModelSetGroupByArgs<ExtArgs>
            result: $Utils.Optional<QnModelSetGroupByOutputType>[]
          }
          count: {
            args: Prisma.qnModelSetCountArgs<ExtArgs>
            result: $Utils.Optional<QnModelSetCountAggregateOutputType> | number
          }
        }
      }
      userGivenExamSet: {
        payload: Prisma.$userGivenExamSetPayload<ExtArgs>
        fields: Prisma.userGivenExamSetFieldRefs
        operations: {
          findUnique: {
            args: Prisma.userGivenExamSetFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userGivenExamSetPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.userGivenExamSetFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userGivenExamSetPayload>
          }
          findFirst: {
            args: Prisma.userGivenExamSetFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userGivenExamSetPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.userGivenExamSetFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userGivenExamSetPayload>
          }
          findMany: {
            args: Prisma.userGivenExamSetFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userGivenExamSetPayload>[]
          }
          create: {
            args: Prisma.userGivenExamSetCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userGivenExamSetPayload>
          }
          createMany: {
            args: Prisma.userGivenExamSetCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.userGivenExamSetCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userGivenExamSetPayload>[]
          }
          delete: {
            args: Prisma.userGivenExamSetDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userGivenExamSetPayload>
          }
          update: {
            args: Prisma.userGivenExamSetUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userGivenExamSetPayload>
          }
          deleteMany: {
            args: Prisma.userGivenExamSetDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.userGivenExamSetUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.userGivenExamSetUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userGivenExamSetPayload>[]
          }
          upsert: {
            args: Prisma.userGivenExamSetUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userGivenExamSetPayload>
          }
          aggregate: {
            args: Prisma.UserGivenExamSetAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateUserGivenExamSet>
          }
          groupBy: {
            args: Prisma.userGivenExamSetGroupByArgs<ExtArgs>
            result: $Utils.Optional<UserGivenExamSetGroupByOutputType>[]
          }
          count: {
            args: Prisma.userGivenExamSetCountArgs<ExtArgs>
            result: $Utils.Optional<UserGivenExamSetCountAggregateOutputType> | number
          }
        }
      }
      userSelectedCourse: {
        payload: Prisma.$userSelectedCoursePayload<ExtArgs>
        fields: Prisma.userSelectedCourseFieldRefs
        operations: {
          findUnique: {
            args: Prisma.userSelectedCourseFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userSelectedCoursePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.userSelectedCourseFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userSelectedCoursePayload>
          }
          findFirst: {
            args: Prisma.userSelectedCourseFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userSelectedCoursePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.userSelectedCourseFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userSelectedCoursePayload>
          }
          findMany: {
            args: Prisma.userSelectedCourseFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userSelectedCoursePayload>[]
          }
          create: {
            args: Prisma.userSelectedCourseCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userSelectedCoursePayload>
          }
          createMany: {
            args: Prisma.userSelectedCourseCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.userSelectedCourseCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userSelectedCoursePayload>[]
          }
          delete: {
            args: Prisma.userSelectedCourseDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userSelectedCoursePayload>
          }
          update: {
            args: Prisma.userSelectedCourseUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userSelectedCoursePayload>
          }
          deleteMany: {
            args: Prisma.userSelectedCourseDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.userSelectedCourseUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.userSelectedCourseUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userSelectedCoursePayload>[]
          }
          upsert: {
            args: Prisma.userSelectedCourseUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$userSelectedCoursePayload>
          }
          aggregate: {
            args: Prisma.UserSelectedCourseAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateUserSelectedCourse>
          }
          groupBy: {
            args: Prisma.userSelectedCourseGroupByArgs<ExtArgs>
            result: $Utils.Optional<UserSelectedCourseGroupByOutputType>[]
          }
          count: {
            args: Prisma.userSelectedCourseCountArgs<ExtArgs>
            result: $Utils.Optional<UserSelectedCourseCountAggregateOutputType> | number
          }
        }
      }
    }
  } & {
    other: {
      payload: any
      operations: {
        $executeRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $executeRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
        $queryRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $queryRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
      }
    }
  }
  export const defineExtension: $Extensions.ExtendsHook<"define", Prisma.TypeMapCb, $Extensions.DefaultArgs>
  export type DefaultPrismaClient = PrismaClient
  export type ErrorFormat = 'pretty' | 'colorless' | 'minimal'
  export interface PrismaClientOptions {
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasources?: Datasources
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasourceUrl?: string
    /**
     * @default "colorless"
     */
    errorFormat?: ErrorFormat
    /**
     * @example
     * ```
     * // Defaults to stdout
     * log: ['query', 'info', 'warn', 'error']
     * 
     * // Emit as events
     * log: [
     *   { emit: 'stdout', level: 'query' },
     *   { emit: 'stdout', level: 'info' },
     *   { emit: 'stdout', level: 'warn' }
     *   { emit: 'stdout', level: 'error' }
     * ]
     * ```
     * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/logging#the-log-option).
     */
    log?: (LogLevel | LogDefinition)[]
    /**
     * The default values for transactionOptions
     * maxWait ?= 2000
     * timeout ?= 5000
     */
    transactionOptions?: {
      maxWait?: number
      timeout?: number
      isolationLevel?: Prisma.TransactionIsolationLevel
    }
    /**
     * Global configuration for omitting model fields by default.
     * 
     * @example
     * ```
     * const prisma = new PrismaClient({
     *   omit: {
     *     user: {
     *       password: true
     *     }
     *   }
     * })
     * ```
     */
    omit?: Prisma.GlobalOmitConfig
  }
  export type GlobalOmitConfig = {
    user?: UserOmit
    category?: CategoryOmit
    course?: CourseOmit
    qnModelSet?: qnModelSetOmit
    userGivenExamSet?: userGivenExamSetOmit
    userSelectedCourse?: userSelectedCourseOmit
  }

  /* Types for Logging */
  export type LogLevel = 'info' | 'query' | 'warn' | 'error'
  export type LogDefinition = {
    level: LogLevel
    emit: 'stdout' | 'event'
  }

  export type GetLogType<T extends LogLevel | LogDefinition> = T extends LogDefinition ? T['emit'] extends 'event' ? T['level'] : never : never
  export type GetEvents<T extends any> = T extends Array<LogLevel | LogDefinition> ?
    GetLogType<T[0]> | GetLogType<T[1]> | GetLogType<T[2]> | GetLogType<T[3]>
    : never

  export type QueryEvent = {
    timestamp: Date
    query: string
    params: string
    duration: number
    target: string
  }

  export type LogEvent = {
    timestamp: Date
    message: string
    target: string
  }
  /* End Types for Logging */


  export type PrismaAction =
    | 'findUnique'
    | 'findUniqueOrThrow'
    | 'findMany'
    | 'findFirst'
    | 'findFirstOrThrow'
    | 'create'
    | 'createMany'
    | 'createManyAndReturn'
    | 'update'
    | 'updateMany'
    | 'updateManyAndReturn'
    | 'upsert'
    | 'delete'
    | 'deleteMany'
    | 'executeRaw'
    | 'queryRaw'
    | 'aggregate'
    | 'count'
    | 'runCommandRaw'
    | 'findRaw'
    | 'groupBy'

  /**
   * These options are being passed into the middleware as "params"
   */
  export type MiddlewareParams = {
    model?: ModelName
    action: PrismaAction
    args: any
    dataPath: string[]
    runInTransaction: boolean
  }

  /**
   * The `T` type makes sure, that the `return proceed` is not forgotten in the middleware implementation
   */
  export type Middleware<T = any> = (
    params: MiddlewareParams,
    next: (params: MiddlewareParams) => $Utils.JsPromise<T>,
  ) => $Utils.JsPromise<T>

  // tested in getLogLevel.test.ts
  export function getLogLevel(log: Array<LogLevel | LogDefinition>): LogLevel | undefined;

  /**
   * `PrismaClient` proxy available in interactive transactions.
   */
  export type TransactionClient = Omit<Prisma.DefaultPrismaClient, runtime.ITXClientDenyList>

  export type Datasource = {
    url?: string
  }

  /**
   * Count Types
   */


  /**
   * Count Type UserCountOutputType
   */

  export type UserCountOutputType = {
    examSets: number
    selectedCourses: number
  }

  export type UserCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    examSets?: boolean | UserCountOutputTypeCountExamSetsArgs
    selectedCourses?: boolean | UserCountOutputTypeCountSelectedCoursesArgs
  }

  // Custom InputTypes
  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserCountOutputType
     */
    select?: UserCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountExamSetsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: userGivenExamSetWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountSelectedCoursesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: userSelectedCourseWhereInput
  }


  /**
   * Count Type CategoryCountOutputType
   */

  export type CategoryCountOutputType = {
    courses: number
  }

  export type CategoryCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    courses?: boolean | CategoryCountOutputTypeCountCoursesArgs
  }

  // Custom InputTypes
  /**
   * CategoryCountOutputType without action
   */
  export type CategoryCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CategoryCountOutputType
     */
    select?: CategoryCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * CategoryCountOutputType without action
   */
  export type CategoryCountOutputTypeCountCoursesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CourseWhereInput
  }


  /**
   * Count Type CourseCountOutputType
   */

  export type CourseCountOutputType = {
    qnModels: number
    selectedBy: number
  }

  export type CourseCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    qnModels?: boolean | CourseCountOutputTypeCountQnModelsArgs
    selectedBy?: boolean | CourseCountOutputTypeCountSelectedByArgs
  }

  // Custom InputTypes
  /**
   * CourseCountOutputType without action
   */
  export type CourseCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CourseCountOutputType
     */
    select?: CourseCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * CourseCountOutputType without action
   */
  export type CourseCountOutputTypeCountQnModelsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: qnModelSetWhereInput
  }

  /**
   * CourseCountOutputType without action
   */
  export type CourseCountOutputTypeCountSelectedByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: userSelectedCourseWhereInput
  }


  /**
   * Count Type QnModelSetCountOutputType
   */

  export type QnModelSetCountOutputType = {
    givenExams: number
  }

  export type QnModelSetCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    givenExams?: boolean | QnModelSetCountOutputTypeCountGivenExamsArgs
  }

  // Custom InputTypes
  /**
   * QnModelSetCountOutputType without action
   */
  export type QnModelSetCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the QnModelSetCountOutputType
     */
    select?: QnModelSetCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * QnModelSetCountOutputType without action
   */
  export type QnModelSetCountOutputTypeCountGivenExamsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: userGivenExamSetWhereInput
  }


  /**
   * Models
   */

  /**
   * Model User
   */

  export type AggregateUser = {
    _count: UserCountAggregateOutputType | null
    _avg: UserAvgAggregateOutputType | null
    _sum: UserSumAggregateOutputType | null
    _min: UserMinAggregateOutputType | null
    _max: UserMaxAggregateOutputType | null
  }

  export type UserAvgAggregateOutputType = {
    id: number | null
  }

  export type UserSumAggregateOutputType = {
    id: number | null
  }

  export type UserMinAggregateOutputType = {
    id: number | null
    name: string | null
    email: string | null
    status: $Enums.Role | null
    password: string | null
    createdAt: Date | null
    modifiedAt: Date | null
  }

  export type UserMaxAggregateOutputType = {
    id: number | null
    name: string | null
    email: string | null
    status: $Enums.Role | null
    password: string | null
    createdAt: Date | null
    modifiedAt: Date | null
  }

  export type UserCountAggregateOutputType = {
    id: number
    name: number
    email: number
    status: number
    password: number
    createdAt: number
    modifiedAt: number
    _all: number
  }


  export type UserAvgAggregateInputType = {
    id?: true
  }

  export type UserSumAggregateInputType = {
    id?: true
  }

  export type UserMinAggregateInputType = {
    id?: true
    name?: true
    email?: true
    status?: true
    password?: true
    createdAt?: true
    modifiedAt?: true
  }

  export type UserMaxAggregateInputType = {
    id?: true
    name?: true
    email?: true
    status?: true
    password?: true
    createdAt?: true
    modifiedAt?: true
  }

  export type UserCountAggregateInputType = {
    id?: true
    name?: true
    email?: true
    status?: true
    password?: true
    createdAt?: true
    modifiedAt?: true
    _all?: true
  }

  export type UserAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which User to aggregate.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Users
    **/
    _count?: true | UserCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: UserAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: UserSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserMaxAggregateInputType
  }

  export type GetUserAggregateType<T extends UserAggregateArgs> = {
        [P in keyof T & keyof AggregateUser]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUser[P]>
      : GetScalarType<T[P], AggregateUser[P]>
  }




  export type UserGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserWhereInput
    orderBy?: UserOrderByWithAggregationInput | UserOrderByWithAggregationInput[]
    by: UserScalarFieldEnum[] | UserScalarFieldEnum
    having?: UserScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserCountAggregateInputType | true
    _avg?: UserAvgAggregateInputType
    _sum?: UserSumAggregateInputType
    _min?: UserMinAggregateInputType
    _max?: UserMaxAggregateInputType
  }

  export type UserGroupByOutputType = {
    id: number
    name: string
    email: string
    status: $Enums.Role
    password: string
    createdAt: Date
    modifiedAt: Date | null
    _count: UserCountAggregateOutputType | null
    _avg: UserAvgAggregateOutputType | null
    _sum: UserSumAggregateOutputType | null
    _min: UserMinAggregateOutputType | null
    _max: UserMaxAggregateOutputType | null
  }

  type GetUserGroupByPayload<T extends UserGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserGroupByOutputType[P]>
            : GetScalarType<T[P], UserGroupByOutputType[P]>
        }
      >
    >


  export type UserSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    email?: boolean
    status?: boolean
    password?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
    examSets?: boolean | User$examSetsArgs<ExtArgs>
    selectedCourses?: boolean | User$selectedCoursesArgs<ExtArgs>
    _count?: boolean | UserCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["user"]>

  export type UserSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    email?: boolean
    status?: boolean
    password?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
  }, ExtArgs["result"]["user"]>

  export type UserSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    email?: boolean
    status?: boolean
    password?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
  }, ExtArgs["result"]["user"]>

  export type UserSelectScalar = {
    id?: boolean
    name?: boolean
    email?: boolean
    status?: boolean
    password?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
  }

  export type UserOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "name" | "email" | "status" | "password" | "createdAt" | "modifiedAt", ExtArgs["result"]["user"]>
  export type UserInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    examSets?: boolean | User$examSetsArgs<ExtArgs>
    selectedCourses?: boolean | User$selectedCoursesArgs<ExtArgs>
    _count?: boolean | UserCountOutputTypeDefaultArgs<ExtArgs>
  }
  export type UserIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {}
  export type UserIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {}

  export type $UserPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "User"
    objects: {
      examSets: Prisma.$userGivenExamSetPayload<ExtArgs>[]
      selectedCourses: Prisma.$userSelectedCoursePayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      name: string
      email: string
      status: $Enums.Role
      password: string
      createdAt: Date
      modifiedAt: Date | null
    }, ExtArgs["result"]["user"]>
    composites: {}
  }

  type UserGetPayload<S extends boolean | null | undefined | UserDefaultArgs> = $Result.GetResult<Prisma.$UserPayload, S>

  type UserCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<UserFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: UserCountAggregateInputType | true
    }

  export interface UserDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['User'], meta: { name: 'User' } }
    /**
     * Find zero or one User that matches the filter.
     * @param {UserFindUniqueArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends UserFindUniqueArgs>(args: SelectSubset<T, UserFindUniqueArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one User that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {UserFindUniqueOrThrowArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends UserFindUniqueOrThrowArgs>(args: SelectSubset<T, UserFindUniqueOrThrowArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first User that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindFirstArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends UserFindFirstArgs>(args?: SelectSubset<T, UserFindFirstArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first User that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindFirstOrThrowArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends UserFindFirstOrThrowArgs>(args?: SelectSubset<T, UserFindFirstOrThrowArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Users that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Users
     * const users = await prisma.user.findMany()
     * 
     * // Get first 10 Users
     * const users = await prisma.user.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const userWithIdOnly = await prisma.user.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends UserFindManyArgs>(args?: SelectSubset<T, UserFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a User.
     * @param {UserCreateArgs} args - Arguments to create a User.
     * @example
     * // Create one User
     * const User = await prisma.user.create({
     *   data: {
     *     // ... data to create a User
     *   }
     * })
     * 
     */
    create<T extends UserCreateArgs>(args: SelectSubset<T, UserCreateArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Users.
     * @param {UserCreateManyArgs} args - Arguments to create many Users.
     * @example
     * // Create many Users
     * const user = await prisma.user.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends UserCreateManyArgs>(args?: SelectSubset<T, UserCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Users and returns the data saved in the database.
     * @param {UserCreateManyAndReturnArgs} args - Arguments to create many Users.
     * @example
     * // Create many Users
     * const user = await prisma.user.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Users and only return the `id`
     * const userWithIdOnly = await prisma.user.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends UserCreateManyAndReturnArgs>(args?: SelectSubset<T, UserCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "createManyAndReturn", GlobalOmitOptions>>

    /**
     * Delete a User.
     * @param {UserDeleteArgs} args - Arguments to delete one User.
     * @example
     * // Delete one User
     * const User = await prisma.user.delete({
     *   where: {
     *     // ... filter to delete one User
     *   }
     * })
     * 
     */
    delete<T extends UserDeleteArgs>(args: SelectSubset<T, UserDeleteArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one User.
     * @param {UserUpdateArgs} args - Arguments to update one User.
     * @example
     * // Update one User
     * const user = await prisma.user.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends UserUpdateArgs>(args: SelectSubset<T, UserUpdateArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Users.
     * @param {UserDeleteManyArgs} args - Arguments to filter Users to delete.
     * @example
     * // Delete a few Users
     * const { count } = await prisma.user.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends UserDeleteManyArgs>(args?: SelectSubset<T, UserDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Users.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Users
     * const user = await prisma.user.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends UserUpdateManyArgs>(args: SelectSubset<T, UserUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Users and returns the data updated in the database.
     * @param {UserUpdateManyAndReturnArgs} args - Arguments to update many Users.
     * @example
     * // Update many Users
     * const user = await prisma.user.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Users and only return the `id`
     * const userWithIdOnly = await prisma.user.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends UserUpdateManyAndReturnArgs>(args: SelectSubset<T, UserUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "updateManyAndReturn", GlobalOmitOptions>>

    /**
     * Create or update one User.
     * @param {UserUpsertArgs} args - Arguments to update or create a User.
     * @example
     * // Update or create a User
     * const user = await prisma.user.upsert({
     *   create: {
     *     // ... data to create a User
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the User we want to update
     *   }
     * })
     */
    upsert<T extends UserUpsertArgs>(args: SelectSubset<T, UserUpsertArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Users.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserCountArgs} args - Arguments to filter Users to count.
     * @example
     * // Count the number of Users
     * const count = await prisma.user.count({
     *   where: {
     *     // ... the filter for the Users we want to count
     *   }
     * })
    **/
    count<T extends UserCountArgs>(
      args?: Subset<T, UserCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a User.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserAggregateArgs>(args: Subset<T, UserAggregateArgs>): Prisma.PrismaPromise<GetUserAggregateType<T>>

    /**
     * Group by User.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserGroupByArgs['orderBy'] }
        : { orderBy?: UserGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the User model
   */
  readonly fields: UserFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for User.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__UserClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    examSets<T extends User$examSetsArgs<ExtArgs> = {}>(args?: Subset<T, User$examSetsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$userGivenExamSetPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    selectedCourses<T extends User$selectedCoursesArgs<ExtArgs> = {}>(args?: Subset<T, User$selectedCoursesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$userSelectedCoursePayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the User model
   */
  interface UserFieldRefs {
    readonly id: FieldRef<"User", 'Int'>
    readonly name: FieldRef<"User", 'String'>
    readonly email: FieldRef<"User", 'String'>
    readonly status: FieldRef<"User", 'Role'>
    readonly password: FieldRef<"User", 'String'>
    readonly createdAt: FieldRef<"User", 'DateTime'>
    readonly modifiedAt: FieldRef<"User", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * User findUnique
   */
  export type UserFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User findUniqueOrThrow
   */
  export type UserFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User findFirst
   */
  export type UserFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Users.
     */
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User findFirstOrThrow
   */
  export type UserFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Users.
     */
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User findMany
   */
  export type UserFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which Users to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User create
   */
  export type UserCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The data needed to create a User.
     */
    data: XOR<UserCreateInput, UserUncheckedCreateInput>
  }

  /**
   * User createMany
   */
  export type UserCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Users.
     */
    data: UserCreateManyInput | UserCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * User createManyAndReturn
   */
  export type UserCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * The data used to create many Users.
     */
    data: UserCreateManyInput | UserCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * User update
   */
  export type UserUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The data needed to update a User.
     */
    data: XOR<UserUpdateInput, UserUncheckedUpdateInput>
    /**
     * Choose, which User to update.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User updateMany
   */
  export type UserUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Users.
     */
    data: XOR<UserUpdateManyMutationInput, UserUncheckedUpdateManyInput>
    /**
     * Filter which Users to update
     */
    where?: UserWhereInput
    /**
     * Limit how many Users to update.
     */
    limit?: number
  }

  /**
   * User updateManyAndReturn
   */
  export type UserUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * The data used to update Users.
     */
    data: XOR<UserUpdateManyMutationInput, UserUncheckedUpdateManyInput>
    /**
     * Filter which Users to update
     */
    where?: UserWhereInput
    /**
     * Limit how many Users to update.
     */
    limit?: number
  }

  /**
   * User upsert
   */
  export type UserUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The filter to search for the User to update in case it exists.
     */
    where: UserWhereUniqueInput
    /**
     * In case the User found by the `where` argument doesn't exist, create a new User with this data.
     */
    create: XOR<UserCreateInput, UserUncheckedCreateInput>
    /**
     * In case the User was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UserUpdateInput, UserUncheckedUpdateInput>
  }

  /**
   * User delete
   */
  export type UserDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter which User to delete.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User deleteMany
   */
  export type UserDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Users to delete
     */
    where?: UserWhereInput
    /**
     * Limit how many Users to delete.
     */
    limit?: number
  }

  /**
   * User.examSets
   */
  export type User$examSetsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userGivenExamSet
     */
    select?: userGivenExamSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userGivenExamSet
     */
    omit?: userGivenExamSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userGivenExamSetInclude<ExtArgs> | null
    where?: userGivenExamSetWhereInput
    orderBy?: userGivenExamSetOrderByWithRelationInput | userGivenExamSetOrderByWithRelationInput[]
    cursor?: userGivenExamSetWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserGivenExamSetScalarFieldEnum | UserGivenExamSetScalarFieldEnum[]
  }

  /**
   * User.selectedCourses
   */
  export type User$selectedCoursesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userSelectedCourse
     */
    select?: userSelectedCourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userSelectedCourse
     */
    omit?: userSelectedCourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userSelectedCourseInclude<ExtArgs> | null
    where?: userSelectedCourseWhereInput
    orderBy?: userSelectedCourseOrderByWithRelationInput | userSelectedCourseOrderByWithRelationInput[]
    cursor?: userSelectedCourseWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserSelectedCourseScalarFieldEnum | UserSelectedCourseScalarFieldEnum[]
  }

  /**
   * User without action
   */
  export type UserDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
  }


  /**
   * Model Category
   */

  export type AggregateCategory = {
    _count: CategoryCountAggregateOutputType | null
    _avg: CategoryAvgAggregateOutputType | null
    _sum: CategorySumAggregateOutputType | null
    _min: CategoryMinAggregateOutputType | null
    _max: CategoryMaxAggregateOutputType | null
  }

  export type CategoryAvgAggregateOutputType = {
    id: number | null
  }

  export type CategorySumAggregateOutputType = {
    id: number | null
  }

  export type CategoryMinAggregateOutputType = {
    id: number | null
    category_name: string | null
    status: $Enums.Status | null
    createdAt: Date | null
    modifiedAt: Date | null
  }

  export type CategoryMaxAggregateOutputType = {
    id: number | null
    category_name: string | null
    status: $Enums.Status | null
    createdAt: Date | null
    modifiedAt: Date | null
  }

  export type CategoryCountAggregateOutputType = {
    id: number
    category_name: number
    status: number
    tag: number
    createdAt: number
    modifiedAt: number
    _all: number
  }


  export type CategoryAvgAggregateInputType = {
    id?: true
  }

  export type CategorySumAggregateInputType = {
    id?: true
  }

  export type CategoryMinAggregateInputType = {
    id?: true
    category_name?: true
    status?: true
    createdAt?: true
    modifiedAt?: true
  }

  export type CategoryMaxAggregateInputType = {
    id?: true
    category_name?: true
    status?: true
    createdAt?: true
    modifiedAt?: true
  }

  export type CategoryCountAggregateInputType = {
    id?: true
    category_name?: true
    status?: true
    tag?: true
    createdAt?: true
    modifiedAt?: true
    _all?: true
  }

  export type CategoryAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Category to aggregate.
     */
    where?: CategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Categories to fetch.
     */
    orderBy?: CategoryOrderByWithRelationInput | CategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: CategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Categories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Categories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Categories
    **/
    _count?: true | CategoryCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: CategoryAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: CategorySumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: CategoryMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: CategoryMaxAggregateInputType
  }

  export type GetCategoryAggregateType<T extends CategoryAggregateArgs> = {
        [P in keyof T & keyof AggregateCategory]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateCategory[P]>
      : GetScalarType<T[P], AggregateCategory[P]>
  }




  export type CategoryGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CategoryWhereInput
    orderBy?: CategoryOrderByWithAggregationInput | CategoryOrderByWithAggregationInput[]
    by: CategoryScalarFieldEnum[] | CategoryScalarFieldEnum
    having?: CategoryScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: CategoryCountAggregateInputType | true
    _avg?: CategoryAvgAggregateInputType
    _sum?: CategorySumAggregateInputType
    _min?: CategoryMinAggregateInputType
    _max?: CategoryMaxAggregateInputType
  }

  export type CategoryGroupByOutputType = {
    id: number
    category_name: string
    status: $Enums.Status
    tag: string[]
    createdAt: Date
    modifiedAt: Date | null
    _count: CategoryCountAggregateOutputType | null
    _avg: CategoryAvgAggregateOutputType | null
    _sum: CategorySumAggregateOutputType | null
    _min: CategoryMinAggregateOutputType | null
    _max: CategoryMaxAggregateOutputType | null
  }

  type GetCategoryGroupByPayload<T extends CategoryGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<CategoryGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof CategoryGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], CategoryGroupByOutputType[P]>
            : GetScalarType<T[P], CategoryGroupByOutputType[P]>
        }
      >
    >


  export type CategorySelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    category_name?: boolean
    status?: boolean
    tag?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
    courses?: boolean | Category$coursesArgs<ExtArgs>
    _count?: boolean | CategoryCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["category"]>

  export type CategorySelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    category_name?: boolean
    status?: boolean
    tag?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
  }, ExtArgs["result"]["category"]>

  export type CategorySelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    category_name?: boolean
    status?: boolean
    tag?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
  }, ExtArgs["result"]["category"]>

  export type CategorySelectScalar = {
    id?: boolean
    category_name?: boolean
    status?: boolean
    tag?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
  }

  export type CategoryOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "category_name" | "status" | "tag" | "createdAt" | "modifiedAt", ExtArgs["result"]["category"]>
  export type CategoryInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    courses?: boolean | Category$coursesArgs<ExtArgs>
    _count?: boolean | CategoryCountOutputTypeDefaultArgs<ExtArgs>
  }
  export type CategoryIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {}
  export type CategoryIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {}

  export type $CategoryPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Category"
    objects: {
      courses: Prisma.$CoursePayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      category_name: string
      status: $Enums.Status
      tag: string[]
      createdAt: Date
      modifiedAt: Date | null
    }, ExtArgs["result"]["category"]>
    composites: {}
  }

  type CategoryGetPayload<S extends boolean | null | undefined | CategoryDefaultArgs> = $Result.GetResult<Prisma.$CategoryPayload, S>

  type CategoryCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<CategoryFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: CategoryCountAggregateInputType | true
    }

  export interface CategoryDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Category'], meta: { name: 'Category' } }
    /**
     * Find zero or one Category that matches the filter.
     * @param {CategoryFindUniqueArgs} args - Arguments to find a Category
     * @example
     * // Get one Category
     * const category = await prisma.category.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends CategoryFindUniqueArgs>(args: SelectSubset<T, CategoryFindUniqueArgs<ExtArgs>>): Prisma__CategoryClient<$Result.GetResult<Prisma.$CategoryPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Category that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {CategoryFindUniqueOrThrowArgs} args - Arguments to find a Category
     * @example
     * // Get one Category
     * const category = await prisma.category.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends CategoryFindUniqueOrThrowArgs>(args: SelectSubset<T, CategoryFindUniqueOrThrowArgs<ExtArgs>>): Prisma__CategoryClient<$Result.GetResult<Prisma.$CategoryPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Category that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoryFindFirstArgs} args - Arguments to find a Category
     * @example
     * // Get one Category
     * const category = await prisma.category.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends CategoryFindFirstArgs>(args?: SelectSubset<T, CategoryFindFirstArgs<ExtArgs>>): Prisma__CategoryClient<$Result.GetResult<Prisma.$CategoryPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Category that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoryFindFirstOrThrowArgs} args - Arguments to find a Category
     * @example
     * // Get one Category
     * const category = await prisma.category.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends CategoryFindFirstOrThrowArgs>(args?: SelectSubset<T, CategoryFindFirstOrThrowArgs<ExtArgs>>): Prisma__CategoryClient<$Result.GetResult<Prisma.$CategoryPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Categories that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoryFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Categories
     * const categories = await prisma.category.findMany()
     * 
     * // Get first 10 Categories
     * const categories = await prisma.category.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const categoryWithIdOnly = await prisma.category.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends CategoryFindManyArgs>(args?: SelectSubset<T, CategoryFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CategoryPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Category.
     * @param {CategoryCreateArgs} args - Arguments to create a Category.
     * @example
     * // Create one Category
     * const Category = await prisma.category.create({
     *   data: {
     *     // ... data to create a Category
     *   }
     * })
     * 
     */
    create<T extends CategoryCreateArgs>(args: SelectSubset<T, CategoryCreateArgs<ExtArgs>>): Prisma__CategoryClient<$Result.GetResult<Prisma.$CategoryPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Categories.
     * @param {CategoryCreateManyArgs} args - Arguments to create many Categories.
     * @example
     * // Create many Categories
     * const category = await prisma.category.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends CategoryCreateManyArgs>(args?: SelectSubset<T, CategoryCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Categories and returns the data saved in the database.
     * @param {CategoryCreateManyAndReturnArgs} args - Arguments to create many Categories.
     * @example
     * // Create many Categories
     * const category = await prisma.category.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Categories and only return the `id`
     * const categoryWithIdOnly = await prisma.category.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends CategoryCreateManyAndReturnArgs>(args?: SelectSubset<T, CategoryCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CategoryPayload<ExtArgs>, T, "createManyAndReturn", GlobalOmitOptions>>

    /**
     * Delete a Category.
     * @param {CategoryDeleteArgs} args - Arguments to delete one Category.
     * @example
     * // Delete one Category
     * const Category = await prisma.category.delete({
     *   where: {
     *     // ... filter to delete one Category
     *   }
     * })
     * 
     */
    delete<T extends CategoryDeleteArgs>(args: SelectSubset<T, CategoryDeleteArgs<ExtArgs>>): Prisma__CategoryClient<$Result.GetResult<Prisma.$CategoryPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Category.
     * @param {CategoryUpdateArgs} args - Arguments to update one Category.
     * @example
     * // Update one Category
     * const category = await prisma.category.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends CategoryUpdateArgs>(args: SelectSubset<T, CategoryUpdateArgs<ExtArgs>>): Prisma__CategoryClient<$Result.GetResult<Prisma.$CategoryPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Categories.
     * @param {CategoryDeleteManyArgs} args - Arguments to filter Categories to delete.
     * @example
     * // Delete a few Categories
     * const { count } = await prisma.category.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends CategoryDeleteManyArgs>(args?: SelectSubset<T, CategoryDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Categories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoryUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Categories
     * const category = await prisma.category.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends CategoryUpdateManyArgs>(args: SelectSubset<T, CategoryUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Categories and returns the data updated in the database.
     * @param {CategoryUpdateManyAndReturnArgs} args - Arguments to update many Categories.
     * @example
     * // Update many Categories
     * const category = await prisma.category.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Categories and only return the `id`
     * const categoryWithIdOnly = await prisma.category.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends CategoryUpdateManyAndReturnArgs>(args: SelectSubset<T, CategoryUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CategoryPayload<ExtArgs>, T, "updateManyAndReturn", GlobalOmitOptions>>

    /**
     * Create or update one Category.
     * @param {CategoryUpsertArgs} args - Arguments to update or create a Category.
     * @example
     * // Update or create a Category
     * const category = await prisma.category.upsert({
     *   create: {
     *     // ... data to create a Category
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Category we want to update
     *   }
     * })
     */
    upsert<T extends CategoryUpsertArgs>(args: SelectSubset<T, CategoryUpsertArgs<ExtArgs>>): Prisma__CategoryClient<$Result.GetResult<Prisma.$CategoryPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Categories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoryCountArgs} args - Arguments to filter Categories to count.
     * @example
     * // Count the number of Categories
     * const count = await prisma.category.count({
     *   where: {
     *     // ... the filter for the Categories we want to count
     *   }
     * })
    **/
    count<T extends CategoryCountArgs>(
      args?: Subset<T, CategoryCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], CategoryCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Category.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoryAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends CategoryAggregateArgs>(args: Subset<T, CategoryAggregateArgs>): Prisma.PrismaPromise<GetCategoryAggregateType<T>>

    /**
     * Group by Category.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoryGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends CategoryGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: CategoryGroupByArgs['orderBy'] }
        : { orderBy?: CategoryGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, CategoryGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetCategoryGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Category model
   */
  readonly fields: CategoryFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Category.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__CategoryClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    courses<T extends Category$coursesArgs<ExtArgs> = {}>(args?: Subset<T, Category$coursesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CoursePayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Category model
   */
  interface CategoryFieldRefs {
    readonly id: FieldRef<"Category", 'Int'>
    readonly category_name: FieldRef<"Category", 'String'>
    readonly status: FieldRef<"Category", 'Status'>
    readonly tag: FieldRef<"Category", 'String[]'>
    readonly createdAt: FieldRef<"Category", 'DateTime'>
    readonly modifiedAt: FieldRef<"Category", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Category findUnique
   */
  export type CategoryFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Category
     */
    select?: CategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the Category
     */
    omit?: CategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryInclude<ExtArgs> | null
    /**
     * Filter, which Category to fetch.
     */
    where: CategoryWhereUniqueInput
  }

  /**
   * Category findUniqueOrThrow
   */
  export type CategoryFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Category
     */
    select?: CategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the Category
     */
    omit?: CategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryInclude<ExtArgs> | null
    /**
     * Filter, which Category to fetch.
     */
    where: CategoryWhereUniqueInput
  }

  /**
   * Category findFirst
   */
  export type CategoryFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Category
     */
    select?: CategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the Category
     */
    omit?: CategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryInclude<ExtArgs> | null
    /**
     * Filter, which Category to fetch.
     */
    where?: CategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Categories to fetch.
     */
    orderBy?: CategoryOrderByWithRelationInput | CategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Categories.
     */
    cursor?: CategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Categories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Categories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Categories.
     */
    distinct?: CategoryScalarFieldEnum | CategoryScalarFieldEnum[]
  }

  /**
   * Category findFirstOrThrow
   */
  export type CategoryFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Category
     */
    select?: CategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the Category
     */
    omit?: CategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryInclude<ExtArgs> | null
    /**
     * Filter, which Category to fetch.
     */
    where?: CategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Categories to fetch.
     */
    orderBy?: CategoryOrderByWithRelationInput | CategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Categories.
     */
    cursor?: CategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Categories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Categories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Categories.
     */
    distinct?: CategoryScalarFieldEnum | CategoryScalarFieldEnum[]
  }

  /**
   * Category findMany
   */
  export type CategoryFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Category
     */
    select?: CategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the Category
     */
    omit?: CategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryInclude<ExtArgs> | null
    /**
     * Filter, which Categories to fetch.
     */
    where?: CategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Categories to fetch.
     */
    orderBy?: CategoryOrderByWithRelationInput | CategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Categories.
     */
    cursor?: CategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Categories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Categories.
     */
    skip?: number
    distinct?: CategoryScalarFieldEnum | CategoryScalarFieldEnum[]
  }

  /**
   * Category create
   */
  export type CategoryCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Category
     */
    select?: CategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the Category
     */
    omit?: CategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryInclude<ExtArgs> | null
    /**
     * The data needed to create a Category.
     */
    data: XOR<CategoryCreateInput, CategoryUncheckedCreateInput>
  }

  /**
   * Category createMany
   */
  export type CategoryCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Categories.
     */
    data: CategoryCreateManyInput | CategoryCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Category createManyAndReturn
   */
  export type CategoryCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Category
     */
    select?: CategorySelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Category
     */
    omit?: CategoryOmit<ExtArgs> | null
    /**
     * The data used to create many Categories.
     */
    data: CategoryCreateManyInput | CategoryCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Category update
   */
  export type CategoryUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Category
     */
    select?: CategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the Category
     */
    omit?: CategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryInclude<ExtArgs> | null
    /**
     * The data needed to update a Category.
     */
    data: XOR<CategoryUpdateInput, CategoryUncheckedUpdateInput>
    /**
     * Choose, which Category to update.
     */
    where: CategoryWhereUniqueInput
  }

  /**
   * Category updateMany
   */
  export type CategoryUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Categories.
     */
    data: XOR<CategoryUpdateManyMutationInput, CategoryUncheckedUpdateManyInput>
    /**
     * Filter which Categories to update
     */
    where?: CategoryWhereInput
    /**
     * Limit how many Categories to update.
     */
    limit?: number
  }

  /**
   * Category updateManyAndReturn
   */
  export type CategoryUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Category
     */
    select?: CategorySelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Category
     */
    omit?: CategoryOmit<ExtArgs> | null
    /**
     * The data used to update Categories.
     */
    data: XOR<CategoryUpdateManyMutationInput, CategoryUncheckedUpdateManyInput>
    /**
     * Filter which Categories to update
     */
    where?: CategoryWhereInput
    /**
     * Limit how many Categories to update.
     */
    limit?: number
  }

  /**
   * Category upsert
   */
  export type CategoryUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Category
     */
    select?: CategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the Category
     */
    omit?: CategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryInclude<ExtArgs> | null
    /**
     * The filter to search for the Category to update in case it exists.
     */
    where: CategoryWhereUniqueInput
    /**
     * In case the Category found by the `where` argument doesn't exist, create a new Category with this data.
     */
    create: XOR<CategoryCreateInput, CategoryUncheckedCreateInput>
    /**
     * In case the Category was found with the provided `where` argument, update it with this data.
     */
    update: XOR<CategoryUpdateInput, CategoryUncheckedUpdateInput>
  }

  /**
   * Category delete
   */
  export type CategoryDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Category
     */
    select?: CategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the Category
     */
    omit?: CategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryInclude<ExtArgs> | null
    /**
     * Filter which Category to delete.
     */
    where: CategoryWhereUniqueInput
  }

  /**
   * Category deleteMany
   */
  export type CategoryDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Categories to delete
     */
    where?: CategoryWhereInput
    /**
     * Limit how many Categories to delete.
     */
    limit?: number
  }

  /**
   * Category.courses
   */
  export type Category$coursesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Course
     */
    select?: CourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Course
     */
    omit?: CourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CourseInclude<ExtArgs> | null
    where?: CourseWhereInput
    orderBy?: CourseOrderByWithRelationInput | CourseOrderByWithRelationInput[]
    cursor?: CourseWhereUniqueInput
    take?: number
    skip?: number
    distinct?: CourseScalarFieldEnum | CourseScalarFieldEnum[]
  }

  /**
   * Category without action
   */
  export type CategoryDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Category
     */
    select?: CategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the Category
     */
    omit?: CategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryInclude<ExtArgs> | null
  }


  /**
   * Model Course
   */

  export type AggregateCourse = {
    _count: CourseCountAggregateOutputType | null
    _avg: CourseAvgAggregateOutputType | null
    _sum: CourseSumAggregateOutputType | null
    _min: CourseMinAggregateOutputType | null
    _max: CourseMaxAggregateOutputType | null
  }

  export type CourseAvgAggregateOutputType = {
    id: number | null
    category_id: number | null
  }

  export type CourseSumAggregateOutputType = {
    id: number | null
    category_id: number | null
  }

  export type CourseMinAggregateOutputType = {
    id: number | null
    course_name: string | null
    status: $Enums.Status | null
    category_id: number | null
    createdAt: Date | null
    modifiedAt: Date | null
  }

  export type CourseMaxAggregateOutputType = {
    id: number | null
    course_name: string | null
    status: $Enums.Status | null
    category_id: number | null
    createdAt: Date | null
    modifiedAt: Date | null
  }

  export type CourseCountAggregateOutputType = {
    id: number
    course_name: number
    status: number
    tag: number
    category_id: number
    createdAt: number
    modifiedAt: number
    _all: number
  }


  export type CourseAvgAggregateInputType = {
    id?: true
    category_id?: true
  }

  export type CourseSumAggregateInputType = {
    id?: true
    category_id?: true
  }

  export type CourseMinAggregateInputType = {
    id?: true
    course_name?: true
    status?: true
    category_id?: true
    createdAt?: true
    modifiedAt?: true
  }

  export type CourseMaxAggregateInputType = {
    id?: true
    course_name?: true
    status?: true
    category_id?: true
    createdAt?: true
    modifiedAt?: true
  }

  export type CourseCountAggregateInputType = {
    id?: true
    course_name?: true
    status?: true
    tag?: true
    category_id?: true
    createdAt?: true
    modifiedAt?: true
    _all?: true
  }

  export type CourseAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Course to aggregate.
     */
    where?: CourseWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Courses to fetch.
     */
    orderBy?: CourseOrderByWithRelationInput | CourseOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: CourseWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Courses from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Courses.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Courses
    **/
    _count?: true | CourseCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: CourseAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: CourseSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: CourseMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: CourseMaxAggregateInputType
  }

  export type GetCourseAggregateType<T extends CourseAggregateArgs> = {
        [P in keyof T & keyof AggregateCourse]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateCourse[P]>
      : GetScalarType<T[P], AggregateCourse[P]>
  }




  export type CourseGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CourseWhereInput
    orderBy?: CourseOrderByWithAggregationInput | CourseOrderByWithAggregationInput[]
    by: CourseScalarFieldEnum[] | CourseScalarFieldEnum
    having?: CourseScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: CourseCountAggregateInputType | true
    _avg?: CourseAvgAggregateInputType
    _sum?: CourseSumAggregateInputType
    _min?: CourseMinAggregateInputType
    _max?: CourseMaxAggregateInputType
  }

  export type CourseGroupByOutputType = {
    id: number
    course_name: string
    status: $Enums.Status
    tag: string[]
    category_id: number
    createdAt: Date
    modifiedAt: Date | null
    _count: CourseCountAggregateOutputType | null
    _avg: CourseAvgAggregateOutputType | null
    _sum: CourseSumAggregateOutputType | null
    _min: CourseMinAggregateOutputType | null
    _max: CourseMaxAggregateOutputType | null
  }

  type GetCourseGroupByPayload<T extends CourseGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<CourseGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof CourseGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], CourseGroupByOutputType[P]>
            : GetScalarType<T[P], CourseGroupByOutputType[P]>
        }
      >
    >


  export type CourseSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    course_name?: boolean
    status?: boolean
    tag?: boolean
    category_id?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
    category?: boolean | CategoryDefaultArgs<ExtArgs>
    qnModels?: boolean | Course$qnModelsArgs<ExtArgs>
    selectedBy?: boolean | Course$selectedByArgs<ExtArgs>
    _count?: boolean | CourseCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["course"]>

  export type CourseSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    course_name?: boolean
    status?: boolean
    tag?: boolean
    category_id?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
    category?: boolean | CategoryDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["course"]>

  export type CourseSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    course_name?: boolean
    status?: boolean
    tag?: boolean
    category_id?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
    category?: boolean | CategoryDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["course"]>

  export type CourseSelectScalar = {
    id?: boolean
    course_name?: boolean
    status?: boolean
    tag?: boolean
    category_id?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
  }

  export type CourseOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "course_name" | "status" | "tag" | "category_id" | "createdAt" | "modifiedAt", ExtArgs["result"]["course"]>
  export type CourseInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    category?: boolean | CategoryDefaultArgs<ExtArgs>
    qnModels?: boolean | Course$qnModelsArgs<ExtArgs>
    selectedBy?: boolean | Course$selectedByArgs<ExtArgs>
    _count?: boolean | CourseCountOutputTypeDefaultArgs<ExtArgs>
  }
  export type CourseIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    category?: boolean | CategoryDefaultArgs<ExtArgs>
  }
  export type CourseIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    category?: boolean | CategoryDefaultArgs<ExtArgs>
  }

  export type $CoursePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Course"
    objects: {
      category: Prisma.$CategoryPayload<ExtArgs>
      qnModels: Prisma.$qnModelSetPayload<ExtArgs>[]
      selectedBy: Prisma.$userSelectedCoursePayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      course_name: string
      status: $Enums.Status
      tag: string[]
      category_id: number
      createdAt: Date
      modifiedAt: Date | null
    }, ExtArgs["result"]["course"]>
    composites: {}
  }

  type CourseGetPayload<S extends boolean | null | undefined | CourseDefaultArgs> = $Result.GetResult<Prisma.$CoursePayload, S>

  type CourseCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<CourseFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: CourseCountAggregateInputType | true
    }

  export interface CourseDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Course'], meta: { name: 'Course' } }
    /**
     * Find zero or one Course that matches the filter.
     * @param {CourseFindUniqueArgs} args - Arguments to find a Course
     * @example
     * // Get one Course
     * const course = await prisma.course.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends CourseFindUniqueArgs>(args: SelectSubset<T, CourseFindUniqueArgs<ExtArgs>>): Prisma__CourseClient<$Result.GetResult<Prisma.$CoursePayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one Course that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {CourseFindUniqueOrThrowArgs} args - Arguments to find a Course
     * @example
     * // Get one Course
     * const course = await prisma.course.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends CourseFindUniqueOrThrowArgs>(args: SelectSubset<T, CourseFindUniqueOrThrowArgs<ExtArgs>>): Prisma__CourseClient<$Result.GetResult<Prisma.$CoursePayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Course that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CourseFindFirstArgs} args - Arguments to find a Course
     * @example
     * // Get one Course
     * const course = await prisma.course.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends CourseFindFirstArgs>(args?: SelectSubset<T, CourseFindFirstArgs<ExtArgs>>): Prisma__CourseClient<$Result.GetResult<Prisma.$CoursePayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first Course that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CourseFindFirstOrThrowArgs} args - Arguments to find a Course
     * @example
     * // Get one Course
     * const course = await prisma.course.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends CourseFindFirstOrThrowArgs>(args?: SelectSubset<T, CourseFindFirstOrThrowArgs<ExtArgs>>): Prisma__CourseClient<$Result.GetResult<Prisma.$CoursePayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more Courses that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CourseFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Courses
     * const courses = await prisma.course.findMany()
     * 
     * // Get first 10 Courses
     * const courses = await prisma.course.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const courseWithIdOnly = await prisma.course.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends CourseFindManyArgs>(args?: SelectSubset<T, CourseFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CoursePayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a Course.
     * @param {CourseCreateArgs} args - Arguments to create a Course.
     * @example
     * // Create one Course
     * const Course = await prisma.course.create({
     *   data: {
     *     // ... data to create a Course
     *   }
     * })
     * 
     */
    create<T extends CourseCreateArgs>(args: SelectSubset<T, CourseCreateArgs<ExtArgs>>): Prisma__CourseClient<$Result.GetResult<Prisma.$CoursePayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many Courses.
     * @param {CourseCreateManyArgs} args - Arguments to create many Courses.
     * @example
     * // Create many Courses
     * const course = await prisma.course.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends CourseCreateManyArgs>(args?: SelectSubset<T, CourseCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Courses and returns the data saved in the database.
     * @param {CourseCreateManyAndReturnArgs} args - Arguments to create many Courses.
     * @example
     * // Create many Courses
     * const course = await prisma.course.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Courses and only return the `id`
     * const courseWithIdOnly = await prisma.course.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends CourseCreateManyAndReturnArgs>(args?: SelectSubset<T, CourseCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CoursePayload<ExtArgs>, T, "createManyAndReturn", GlobalOmitOptions>>

    /**
     * Delete a Course.
     * @param {CourseDeleteArgs} args - Arguments to delete one Course.
     * @example
     * // Delete one Course
     * const Course = await prisma.course.delete({
     *   where: {
     *     // ... filter to delete one Course
     *   }
     * })
     * 
     */
    delete<T extends CourseDeleteArgs>(args: SelectSubset<T, CourseDeleteArgs<ExtArgs>>): Prisma__CourseClient<$Result.GetResult<Prisma.$CoursePayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one Course.
     * @param {CourseUpdateArgs} args - Arguments to update one Course.
     * @example
     * // Update one Course
     * const course = await prisma.course.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends CourseUpdateArgs>(args: SelectSubset<T, CourseUpdateArgs<ExtArgs>>): Prisma__CourseClient<$Result.GetResult<Prisma.$CoursePayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more Courses.
     * @param {CourseDeleteManyArgs} args - Arguments to filter Courses to delete.
     * @example
     * // Delete a few Courses
     * const { count } = await prisma.course.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends CourseDeleteManyArgs>(args?: SelectSubset<T, CourseDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Courses.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CourseUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Courses
     * const course = await prisma.course.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends CourseUpdateManyArgs>(args: SelectSubset<T, CourseUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Courses and returns the data updated in the database.
     * @param {CourseUpdateManyAndReturnArgs} args - Arguments to update many Courses.
     * @example
     * // Update many Courses
     * const course = await prisma.course.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Courses and only return the `id`
     * const courseWithIdOnly = await prisma.course.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends CourseUpdateManyAndReturnArgs>(args: SelectSubset<T, CourseUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CoursePayload<ExtArgs>, T, "updateManyAndReturn", GlobalOmitOptions>>

    /**
     * Create or update one Course.
     * @param {CourseUpsertArgs} args - Arguments to update or create a Course.
     * @example
     * // Update or create a Course
     * const course = await prisma.course.upsert({
     *   create: {
     *     // ... data to create a Course
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Course we want to update
     *   }
     * })
     */
    upsert<T extends CourseUpsertArgs>(args: SelectSubset<T, CourseUpsertArgs<ExtArgs>>): Prisma__CourseClient<$Result.GetResult<Prisma.$CoursePayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of Courses.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CourseCountArgs} args - Arguments to filter Courses to count.
     * @example
     * // Count the number of Courses
     * const count = await prisma.course.count({
     *   where: {
     *     // ... the filter for the Courses we want to count
     *   }
     * })
    **/
    count<T extends CourseCountArgs>(
      args?: Subset<T, CourseCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], CourseCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Course.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CourseAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends CourseAggregateArgs>(args: Subset<T, CourseAggregateArgs>): Prisma.PrismaPromise<GetCourseAggregateType<T>>

    /**
     * Group by Course.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CourseGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends CourseGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: CourseGroupByArgs['orderBy'] }
        : { orderBy?: CourseGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, CourseGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetCourseGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Course model
   */
  readonly fields: CourseFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Course.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__CourseClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    category<T extends CategoryDefaultArgs<ExtArgs> = {}>(args?: Subset<T, CategoryDefaultArgs<ExtArgs>>): Prisma__CategoryClient<$Result.GetResult<Prisma.$CategoryPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    qnModels<T extends Course$qnModelsArgs<ExtArgs> = {}>(args?: Subset<T, Course$qnModelsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$qnModelSetPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    selectedBy<T extends Course$selectedByArgs<ExtArgs> = {}>(args?: Subset<T, Course$selectedByArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$userSelectedCoursePayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Course model
   */
  interface CourseFieldRefs {
    readonly id: FieldRef<"Course", 'Int'>
    readonly course_name: FieldRef<"Course", 'String'>
    readonly status: FieldRef<"Course", 'Status'>
    readonly tag: FieldRef<"Course", 'String[]'>
    readonly category_id: FieldRef<"Course", 'Int'>
    readonly createdAt: FieldRef<"Course", 'DateTime'>
    readonly modifiedAt: FieldRef<"Course", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Course findUnique
   */
  export type CourseFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Course
     */
    select?: CourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Course
     */
    omit?: CourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CourseInclude<ExtArgs> | null
    /**
     * Filter, which Course to fetch.
     */
    where: CourseWhereUniqueInput
  }

  /**
   * Course findUniqueOrThrow
   */
  export type CourseFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Course
     */
    select?: CourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Course
     */
    omit?: CourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CourseInclude<ExtArgs> | null
    /**
     * Filter, which Course to fetch.
     */
    where: CourseWhereUniqueInput
  }

  /**
   * Course findFirst
   */
  export type CourseFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Course
     */
    select?: CourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Course
     */
    omit?: CourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CourseInclude<ExtArgs> | null
    /**
     * Filter, which Course to fetch.
     */
    where?: CourseWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Courses to fetch.
     */
    orderBy?: CourseOrderByWithRelationInput | CourseOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Courses.
     */
    cursor?: CourseWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Courses from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Courses.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Courses.
     */
    distinct?: CourseScalarFieldEnum | CourseScalarFieldEnum[]
  }

  /**
   * Course findFirstOrThrow
   */
  export type CourseFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Course
     */
    select?: CourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Course
     */
    omit?: CourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CourseInclude<ExtArgs> | null
    /**
     * Filter, which Course to fetch.
     */
    where?: CourseWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Courses to fetch.
     */
    orderBy?: CourseOrderByWithRelationInput | CourseOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Courses.
     */
    cursor?: CourseWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Courses from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Courses.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Courses.
     */
    distinct?: CourseScalarFieldEnum | CourseScalarFieldEnum[]
  }

  /**
   * Course findMany
   */
  export type CourseFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Course
     */
    select?: CourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Course
     */
    omit?: CourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CourseInclude<ExtArgs> | null
    /**
     * Filter, which Courses to fetch.
     */
    where?: CourseWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Courses to fetch.
     */
    orderBy?: CourseOrderByWithRelationInput | CourseOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Courses.
     */
    cursor?: CourseWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Courses from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Courses.
     */
    skip?: number
    distinct?: CourseScalarFieldEnum | CourseScalarFieldEnum[]
  }

  /**
   * Course create
   */
  export type CourseCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Course
     */
    select?: CourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Course
     */
    omit?: CourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CourseInclude<ExtArgs> | null
    /**
     * The data needed to create a Course.
     */
    data: XOR<CourseCreateInput, CourseUncheckedCreateInput>
  }

  /**
   * Course createMany
   */
  export type CourseCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Courses.
     */
    data: CourseCreateManyInput | CourseCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Course createManyAndReturn
   */
  export type CourseCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Course
     */
    select?: CourseSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Course
     */
    omit?: CourseOmit<ExtArgs> | null
    /**
     * The data used to create many Courses.
     */
    data: CourseCreateManyInput | CourseCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CourseIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * Course update
   */
  export type CourseUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Course
     */
    select?: CourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Course
     */
    omit?: CourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CourseInclude<ExtArgs> | null
    /**
     * The data needed to update a Course.
     */
    data: XOR<CourseUpdateInput, CourseUncheckedUpdateInput>
    /**
     * Choose, which Course to update.
     */
    where: CourseWhereUniqueInput
  }

  /**
   * Course updateMany
   */
  export type CourseUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Courses.
     */
    data: XOR<CourseUpdateManyMutationInput, CourseUncheckedUpdateManyInput>
    /**
     * Filter which Courses to update
     */
    where?: CourseWhereInput
    /**
     * Limit how many Courses to update.
     */
    limit?: number
  }

  /**
   * Course updateManyAndReturn
   */
  export type CourseUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Course
     */
    select?: CourseSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Course
     */
    omit?: CourseOmit<ExtArgs> | null
    /**
     * The data used to update Courses.
     */
    data: XOR<CourseUpdateManyMutationInput, CourseUncheckedUpdateManyInput>
    /**
     * Filter which Courses to update
     */
    where?: CourseWhereInput
    /**
     * Limit how many Courses to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CourseIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * Course upsert
   */
  export type CourseUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Course
     */
    select?: CourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Course
     */
    omit?: CourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CourseInclude<ExtArgs> | null
    /**
     * The filter to search for the Course to update in case it exists.
     */
    where: CourseWhereUniqueInput
    /**
     * In case the Course found by the `where` argument doesn't exist, create a new Course with this data.
     */
    create: XOR<CourseCreateInput, CourseUncheckedCreateInput>
    /**
     * In case the Course was found with the provided `where` argument, update it with this data.
     */
    update: XOR<CourseUpdateInput, CourseUncheckedUpdateInput>
  }

  /**
   * Course delete
   */
  export type CourseDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Course
     */
    select?: CourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Course
     */
    omit?: CourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CourseInclude<ExtArgs> | null
    /**
     * Filter which Course to delete.
     */
    where: CourseWhereUniqueInput
  }

  /**
   * Course deleteMany
   */
  export type CourseDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Courses to delete
     */
    where?: CourseWhereInput
    /**
     * Limit how many Courses to delete.
     */
    limit?: number
  }

  /**
   * Course.qnModels
   */
  export type Course$qnModelsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the qnModelSet
     */
    select?: qnModelSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the qnModelSet
     */
    omit?: qnModelSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: qnModelSetInclude<ExtArgs> | null
    where?: qnModelSetWhereInput
    orderBy?: qnModelSetOrderByWithRelationInput | qnModelSetOrderByWithRelationInput[]
    cursor?: qnModelSetWhereUniqueInput
    take?: number
    skip?: number
    distinct?: QnModelSetScalarFieldEnum | QnModelSetScalarFieldEnum[]
  }

  /**
   * Course.selectedBy
   */
  export type Course$selectedByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userSelectedCourse
     */
    select?: userSelectedCourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userSelectedCourse
     */
    omit?: userSelectedCourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userSelectedCourseInclude<ExtArgs> | null
    where?: userSelectedCourseWhereInput
    orderBy?: userSelectedCourseOrderByWithRelationInput | userSelectedCourseOrderByWithRelationInput[]
    cursor?: userSelectedCourseWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserSelectedCourseScalarFieldEnum | UserSelectedCourseScalarFieldEnum[]
  }

  /**
   * Course without action
   */
  export type CourseDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Course
     */
    select?: CourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Course
     */
    omit?: CourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CourseInclude<ExtArgs> | null
  }


  /**
   * Model qnModelSet
   */

  export type AggregateQnModelSet = {
    _count: QnModelSetCountAggregateOutputType | null
    _avg: QnModelSetAvgAggregateOutputType | null
    _sum: QnModelSetSumAggregateOutputType | null
    _min: QnModelSetMinAggregateOutputType | null
    _max: QnModelSetMaxAggregateOutputType | null
  }

  export type QnModelSetAvgAggregateOutputType = {
    id: number | null
    course_id: number | null
  }

  export type QnModelSetSumAggregateOutputType = {
    id: number | null
    course_id: number | null
  }

  export type QnModelSetMinAggregateOutputType = {
    id: number | null
    qn_title: string | null
    exam_time: string | null
    status: $Enums.Status | null
    createBy: string | null
    course_id: number | null
    createdAt: Date | null
    modifiedAt: Date | null
  }

  export type QnModelSetMaxAggregateOutputType = {
    id: number | null
    qn_title: string | null
    exam_time: string | null
    status: $Enums.Status | null
    createBy: string | null
    course_id: number | null
    createdAt: Date | null
    modifiedAt: Date | null
  }

  export type QnModelSetCountAggregateOutputType = {
    id: number
    qn_title: number
    modelset_info: number
    qn_set: number
    exam_time: number
    status: number
    tag: number
    createBy: number
    course_id: number
    createdAt: number
    modifiedAt: number
    _all: number
  }


  export type QnModelSetAvgAggregateInputType = {
    id?: true
    course_id?: true
  }

  export type QnModelSetSumAggregateInputType = {
    id?: true
    course_id?: true
  }

  export type QnModelSetMinAggregateInputType = {
    id?: true
    qn_title?: true
    exam_time?: true
    status?: true
    createBy?: true
    course_id?: true
    createdAt?: true
    modifiedAt?: true
  }

  export type QnModelSetMaxAggregateInputType = {
    id?: true
    qn_title?: true
    exam_time?: true
    status?: true
    createBy?: true
    course_id?: true
    createdAt?: true
    modifiedAt?: true
  }

  export type QnModelSetCountAggregateInputType = {
    id?: true
    qn_title?: true
    modelset_info?: true
    qn_set?: true
    exam_time?: true
    status?: true
    tag?: true
    createBy?: true
    course_id?: true
    createdAt?: true
    modifiedAt?: true
    _all?: true
  }

  export type QnModelSetAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which qnModelSet to aggregate.
     */
    where?: qnModelSetWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of qnModelSets to fetch.
     */
    orderBy?: qnModelSetOrderByWithRelationInput | qnModelSetOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: qnModelSetWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` qnModelSets from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` qnModelSets.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned qnModelSets
    **/
    _count?: true | QnModelSetCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: QnModelSetAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: QnModelSetSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: QnModelSetMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: QnModelSetMaxAggregateInputType
  }

  export type GetQnModelSetAggregateType<T extends QnModelSetAggregateArgs> = {
        [P in keyof T & keyof AggregateQnModelSet]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateQnModelSet[P]>
      : GetScalarType<T[P], AggregateQnModelSet[P]>
  }




  export type qnModelSetGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: qnModelSetWhereInput
    orderBy?: qnModelSetOrderByWithAggregationInput | qnModelSetOrderByWithAggregationInput[]
    by: QnModelSetScalarFieldEnum[] | QnModelSetScalarFieldEnum
    having?: qnModelSetScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: QnModelSetCountAggregateInputType | true
    _avg?: QnModelSetAvgAggregateInputType
    _sum?: QnModelSetSumAggregateInputType
    _min?: QnModelSetMinAggregateInputType
    _max?: QnModelSetMaxAggregateInputType
  }

  export type QnModelSetGroupByOutputType = {
    id: number
    qn_title: string
    modelset_info: JsonValue
    qn_set: JsonValue
    exam_time: string
    status: $Enums.Status
    tag: string[]
    createBy: string
    course_id: number
    createdAt: Date
    modifiedAt: Date | null
    _count: QnModelSetCountAggregateOutputType | null
    _avg: QnModelSetAvgAggregateOutputType | null
    _sum: QnModelSetSumAggregateOutputType | null
    _min: QnModelSetMinAggregateOutputType | null
    _max: QnModelSetMaxAggregateOutputType | null
  }

  type GetQnModelSetGroupByPayload<T extends qnModelSetGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<QnModelSetGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof QnModelSetGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], QnModelSetGroupByOutputType[P]>
            : GetScalarType<T[P], QnModelSetGroupByOutputType[P]>
        }
      >
    >


  export type qnModelSetSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    qn_title?: boolean
    modelset_info?: boolean
    qn_set?: boolean
    exam_time?: boolean
    status?: boolean
    tag?: boolean
    createBy?: boolean
    course_id?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
    course?: boolean | CourseDefaultArgs<ExtArgs>
    givenExams?: boolean | qnModelSet$givenExamsArgs<ExtArgs>
    _count?: boolean | QnModelSetCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["qnModelSet"]>

  export type qnModelSetSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    qn_title?: boolean
    modelset_info?: boolean
    qn_set?: boolean
    exam_time?: boolean
    status?: boolean
    tag?: boolean
    createBy?: boolean
    course_id?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
    course?: boolean | CourseDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["qnModelSet"]>

  export type qnModelSetSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    qn_title?: boolean
    modelset_info?: boolean
    qn_set?: boolean
    exam_time?: boolean
    status?: boolean
    tag?: boolean
    createBy?: boolean
    course_id?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
    course?: boolean | CourseDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["qnModelSet"]>

  export type qnModelSetSelectScalar = {
    id?: boolean
    qn_title?: boolean
    modelset_info?: boolean
    qn_set?: boolean
    exam_time?: boolean
    status?: boolean
    tag?: boolean
    createBy?: boolean
    course_id?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
  }

  export type qnModelSetOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "qn_title" | "modelset_info" | "qn_set" | "exam_time" | "status" | "tag" | "createBy" | "course_id" | "createdAt" | "modifiedAt", ExtArgs["result"]["qnModelSet"]>
  export type qnModelSetInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    course?: boolean | CourseDefaultArgs<ExtArgs>
    givenExams?: boolean | qnModelSet$givenExamsArgs<ExtArgs>
    _count?: boolean | QnModelSetCountOutputTypeDefaultArgs<ExtArgs>
  }
  export type qnModelSetIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    course?: boolean | CourseDefaultArgs<ExtArgs>
  }
  export type qnModelSetIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    course?: boolean | CourseDefaultArgs<ExtArgs>
  }

  export type $qnModelSetPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "qnModelSet"
    objects: {
      course: Prisma.$CoursePayload<ExtArgs>
      givenExams: Prisma.$userGivenExamSetPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      qn_title: string
      modelset_info: Prisma.JsonValue
      qn_set: Prisma.JsonValue
      exam_time: string
      status: $Enums.Status
      tag: string[]
      createBy: string
      course_id: number
      createdAt: Date
      modifiedAt: Date | null
    }, ExtArgs["result"]["qnModelSet"]>
    composites: {}
  }

  type qnModelSetGetPayload<S extends boolean | null | undefined | qnModelSetDefaultArgs> = $Result.GetResult<Prisma.$qnModelSetPayload, S>

  type qnModelSetCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<qnModelSetFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: QnModelSetCountAggregateInputType | true
    }

  export interface qnModelSetDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['qnModelSet'], meta: { name: 'qnModelSet' } }
    /**
     * Find zero or one QnModelSet that matches the filter.
     * @param {qnModelSetFindUniqueArgs} args - Arguments to find a QnModelSet
     * @example
     * // Get one QnModelSet
     * const qnModelSet = await prisma.qnModelSet.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends qnModelSetFindUniqueArgs>(args: SelectSubset<T, qnModelSetFindUniqueArgs<ExtArgs>>): Prisma__qnModelSetClient<$Result.GetResult<Prisma.$qnModelSetPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one QnModelSet that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {qnModelSetFindUniqueOrThrowArgs} args - Arguments to find a QnModelSet
     * @example
     * // Get one QnModelSet
     * const qnModelSet = await prisma.qnModelSet.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends qnModelSetFindUniqueOrThrowArgs>(args: SelectSubset<T, qnModelSetFindUniqueOrThrowArgs<ExtArgs>>): Prisma__qnModelSetClient<$Result.GetResult<Prisma.$qnModelSetPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first QnModelSet that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {qnModelSetFindFirstArgs} args - Arguments to find a QnModelSet
     * @example
     * // Get one QnModelSet
     * const qnModelSet = await prisma.qnModelSet.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends qnModelSetFindFirstArgs>(args?: SelectSubset<T, qnModelSetFindFirstArgs<ExtArgs>>): Prisma__qnModelSetClient<$Result.GetResult<Prisma.$qnModelSetPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first QnModelSet that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {qnModelSetFindFirstOrThrowArgs} args - Arguments to find a QnModelSet
     * @example
     * // Get one QnModelSet
     * const qnModelSet = await prisma.qnModelSet.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends qnModelSetFindFirstOrThrowArgs>(args?: SelectSubset<T, qnModelSetFindFirstOrThrowArgs<ExtArgs>>): Prisma__qnModelSetClient<$Result.GetResult<Prisma.$qnModelSetPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more QnModelSets that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {qnModelSetFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all QnModelSets
     * const qnModelSets = await prisma.qnModelSet.findMany()
     * 
     * // Get first 10 QnModelSets
     * const qnModelSets = await prisma.qnModelSet.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const qnModelSetWithIdOnly = await prisma.qnModelSet.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends qnModelSetFindManyArgs>(args?: SelectSubset<T, qnModelSetFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$qnModelSetPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a QnModelSet.
     * @param {qnModelSetCreateArgs} args - Arguments to create a QnModelSet.
     * @example
     * // Create one QnModelSet
     * const QnModelSet = await prisma.qnModelSet.create({
     *   data: {
     *     // ... data to create a QnModelSet
     *   }
     * })
     * 
     */
    create<T extends qnModelSetCreateArgs>(args: SelectSubset<T, qnModelSetCreateArgs<ExtArgs>>): Prisma__qnModelSetClient<$Result.GetResult<Prisma.$qnModelSetPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many QnModelSets.
     * @param {qnModelSetCreateManyArgs} args - Arguments to create many QnModelSets.
     * @example
     * // Create many QnModelSets
     * const qnModelSet = await prisma.qnModelSet.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends qnModelSetCreateManyArgs>(args?: SelectSubset<T, qnModelSetCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many QnModelSets and returns the data saved in the database.
     * @param {qnModelSetCreateManyAndReturnArgs} args - Arguments to create many QnModelSets.
     * @example
     * // Create many QnModelSets
     * const qnModelSet = await prisma.qnModelSet.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many QnModelSets and only return the `id`
     * const qnModelSetWithIdOnly = await prisma.qnModelSet.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends qnModelSetCreateManyAndReturnArgs>(args?: SelectSubset<T, qnModelSetCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$qnModelSetPayload<ExtArgs>, T, "createManyAndReturn", GlobalOmitOptions>>

    /**
     * Delete a QnModelSet.
     * @param {qnModelSetDeleteArgs} args - Arguments to delete one QnModelSet.
     * @example
     * // Delete one QnModelSet
     * const QnModelSet = await prisma.qnModelSet.delete({
     *   where: {
     *     // ... filter to delete one QnModelSet
     *   }
     * })
     * 
     */
    delete<T extends qnModelSetDeleteArgs>(args: SelectSubset<T, qnModelSetDeleteArgs<ExtArgs>>): Prisma__qnModelSetClient<$Result.GetResult<Prisma.$qnModelSetPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one QnModelSet.
     * @param {qnModelSetUpdateArgs} args - Arguments to update one QnModelSet.
     * @example
     * // Update one QnModelSet
     * const qnModelSet = await prisma.qnModelSet.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends qnModelSetUpdateArgs>(args: SelectSubset<T, qnModelSetUpdateArgs<ExtArgs>>): Prisma__qnModelSetClient<$Result.GetResult<Prisma.$qnModelSetPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more QnModelSets.
     * @param {qnModelSetDeleteManyArgs} args - Arguments to filter QnModelSets to delete.
     * @example
     * // Delete a few QnModelSets
     * const { count } = await prisma.qnModelSet.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends qnModelSetDeleteManyArgs>(args?: SelectSubset<T, qnModelSetDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more QnModelSets.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {qnModelSetUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many QnModelSets
     * const qnModelSet = await prisma.qnModelSet.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends qnModelSetUpdateManyArgs>(args: SelectSubset<T, qnModelSetUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more QnModelSets and returns the data updated in the database.
     * @param {qnModelSetUpdateManyAndReturnArgs} args - Arguments to update many QnModelSets.
     * @example
     * // Update many QnModelSets
     * const qnModelSet = await prisma.qnModelSet.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more QnModelSets and only return the `id`
     * const qnModelSetWithIdOnly = await prisma.qnModelSet.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends qnModelSetUpdateManyAndReturnArgs>(args: SelectSubset<T, qnModelSetUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$qnModelSetPayload<ExtArgs>, T, "updateManyAndReturn", GlobalOmitOptions>>

    /**
     * Create or update one QnModelSet.
     * @param {qnModelSetUpsertArgs} args - Arguments to update or create a QnModelSet.
     * @example
     * // Update or create a QnModelSet
     * const qnModelSet = await prisma.qnModelSet.upsert({
     *   create: {
     *     // ... data to create a QnModelSet
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the QnModelSet we want to update
     *   }
     * })
     */
    upsert<T extends qnModelSetUpsertArgs>(args: SelectSubset<T, qnModelSetUpsertArgs<ExtArgs>>): Prisma__qnModelSetClient<$Result.GetResult<Prisma.$qnModelSetPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of QnModelSets.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {qnModelSetCountArgs} args - Arguments to filter QnModelSets to count.
     * @example
     * // Count the number of QnModelSets
     * const count = await prisma.qnModelSet.count({
     *   where: {
     *     // ... the filter for the QnModelSets we want to count
     *   }
     * })
    **/
    count<T extends qnModelSetCountArgs>(
      args?: Subset<T, qnModelSetCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], QnModelSetCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a QnModelSet.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {QnModelSetAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends QnModelSetAggregateArgs>(args: Subset<T, QnModelSetAggregateArgs>): Prisma.PrismaPromise<GetQnModelSetAggregateType<T>>

    /**
     * Group by QnModelSet.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {qnModelSetGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends qnModelSetGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: qnModelSetGroupByArgs['orderBy'] }
        : { orderBy?: qnModelSetGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, qnModelSetGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetQnModelSetGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the qnModelSet model
   */
  readonly fields: qnModelSetFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for qnModelSet.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__qnModelSetClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    course<T extends CourseDefaultArgs<ExtArgs> = {}>(args?: Subset<T, CourseDefaultArgs<ExtArgs>>): Prisma__CourseClient<$Result.GetResult<Prisma.$CoursePayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    givenExams<T extends qnModelSet$givenExamsArgs<ExtArgs> = {}>(args?: Subset<T, qnModelSet$givenExamsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$userGivenExamSetPayload<ExtArgs>, T, "findMany", GlobalOmitOptions> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the qnModelSet model
   */
  interface qnModelSetFieldRefs {
    readonly id: FieldRef<"qnModelSet", 'Int'>
    readonly qn_title: FieldRef<"qnModelSet", 'String'>
    readonly modelset_info: FieldRef<"qnModelSet", 'Json'>
    readonly qn_set: FieldRef<"qnModelSet", 'Json'>
    readonly exam_time: FieldRef<"qnModelSet", 'String'>
    readonly status: FieldRef<"qnModelSet", 'Status'>
    readonly tag: FieldRef<"qnModelSet", 'String[]'>
    readonly createBy: FieldRef<"qnModelSet", 'String'>
    readonly course_id: FieldRef<"qnModelSet", 'Int'>
    readonly createdAt: FieldRef<"qnModelSet", 'DateTime'>
    readonly modifiedAt: FieldRef<"qnModelSet", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * qnModelSet findUnique
   */
  export type qnModelSetFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the qnModelSet
     */
    select?: qnModelSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the qnModelSet
     */
    omit?: qnModelSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: qnModelSetInclude<ExtArgs> | null
    /**
     * Filter, which qnModelSet to fetch.
     */
    where: qnModelSetWhereUniqueInput
  }

  /**
   * qnModelSet findUniqueOrThrow
   */
  export type qnModelSetFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the qnModelSet
     */
    select?: qnModelSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the qnModelSet
     */
    omit?: qnModelSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: qnModelSetInclude<ExtArgs> | null
    /**
     * Filter, which qnModelSet to fetch.
     */
    where: qnModelSetWhereUniqueInput
  }

  /**
   * qnModelSet findFirst
   */
  export type qnModelSetFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the qnModelSet
     */
    select?: qnModelSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the qnModelSet
     */
    omit?: qnModelSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: qnModelSetInclude<ExtArgs> | null
    /**
     * Filter, which qnModelSet to fetch.
     */
    where?: qnModelSetWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of qnModelSets to fetch.
     */
    orderBy?: qnModelSetOrderByWithRelationInput | qnModelSetOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for qnModelSets.
     */
    cursor?: qnModelSetWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` qnModelSets from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` qnModelSets.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of qnModelSets.
     */
    distinct?: QnModelSetScalarFieldEnum | QnModelSetScalarFieldEnum[]
  }

  /**
   * qnModelSet findFirstOrThrow
   */
  export type qnModelSetFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the qnModelSet
     */
    select?: qnModelSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the qnModelSet
     */
    omit?: qnModelSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: qnModelSetInclude<ExtArgs> | null
    /**
     * Filter, which qnModelSet to fetch.
     */
    where?: qnModelSetWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of qnModelSets to fetch.
     */
    orderBy?: qnModelSetOrderByWithRelationInput | qnModelSetOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for qnModelSets.
     */
    cursor?: qnModelSetWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` qnModelSets from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` qnModelSets.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of qnModelSets.
     */
    distinct?: QnModelSetScalarFieldEnum | QnModelSetScalarFieldEnum[]
  }

  /**
   * qnModelSet findMany
   */
  export type qnModelSetFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the qnModelSet
     */
    select?: qnModelSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the qnModelSet
     */
    omit?: qnModelSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: qnModelSetInclude<ExtArgs> | null
    /**
     * Filter, which qnModelSets to fetch.
     */
    where?: qnModelSetWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of qnModelSets to fetch.
     */
    orderBy?: qnModelSetOrderByWithRelationInput | qnModelSetOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing qnModelSets.
     */
    cursor?: qnModelSetWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` qnModelSets from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` qnModelSets.
     */
    skip?: number
    distinct?: QnModelSetScalarFieldEnum | QnModelSetScalarFieldEnum[]
  }

  /**
   * qnModelSet create
   */
  export type qnModelSetCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the qnModelSet
     */
    select?: qnModelSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the qnModelSet
     */
    omit?: qnModelSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: qnModelSetInclude<ExtArgs> | null
    /**
     * The data needed to create a qnModelSet.
     */
    data: XOR<qnModelSetCreateInput, qnModelSetUncheckedCreateInput>
  }

  /**
   * qnModelSet createMany
   */
  export type qnModelSetCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many qnModelSets.
     */
    data: qnModelSetCreateManyInput | qnModelSetCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * qnModelSet createManyAndReturn
   */
  export type qnModelSetCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the qnModelSet
     */
    select?: qnModelSetSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the qnModelSet
     */
    omit?: qnModelSetOmit<ExtArgs> | null
    /**
     * The data used to create many qnModelSets.
     */
    data: qnModelSetCreateManyInput | qnModelSetCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: qnModelSetIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * qnModelSet update
   */
  export type qnModelSetUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the qnModelSet
     */
    select?: qnModelSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the qnModelSet
     */
    omit?: qnModelSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: qnModelSetInclude<ExtArgs> | null
    /**
     * The data needed to update a qnModelSet.
     */
    data: XOR<qnModelSetUpdateInput, qnModelSetUncheckedUpdateInput>
    /**
     * Choose, which qnModelSet to update.
     */
    where: qnModelSetWhereUniqueInput
  }

  /**
   * qnModelSet updateMany
   */
  export type qnModelSetUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update qnModelSets.
     */
    data: XOR<qnModelSetUpdateManyMutationInput, qnModelSetUncheckedUpdateManyInput>
    /**
     * Filter which qnModelSets to update
     */
    where?: qnModelSetWhereInput
    /**
     * Limit how many qnModelSets to update.
     */
    limit?: number
  }

  /**
   * qnModelSet updateManyAndReturn
   */
  export type qnModelSetUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the qnModelSet
     */
    select?: qnModelSetSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the qnModelSet
     */
    omit?: qnModelSetOmit<ExtArgs> | null
    /**
     * The data used to update qnModelSets.
     */
    data: XOR<qnModelSetUpdateManyMutationInput, qnModelSetUncheckedUpdateManyInput>
    /**
     * Filter which qnModelSets to update
     */
    where?: qnModelSetWhereInput
    /**
     * Limit how many qnModelSets to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: qnModelSetIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * qnModelSet upsert
   */
  export type qnModelSetUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the qnModelSet
     */
    select?: qnModelSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the qnModelSet
     */
    omit?: qnModelSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: qnModelSetInclude<ExtArgs> | null
    /**
     * The filter to search for the qnModelSet to update in case it exists.
     */
    where: qnModelSetWhereUniqueInput
    /**
     * In case the qnModelSet found by the `where` argument doesn't exist, create a new qnModelSet with this data.
     */
    create: XOR<qnModelSetCreateInput, qnModelSetUncheckedCreateInput>
    /**
     * In case the qnModelSet was found with the provided `where` argument, update it with this data.
     */
    update: XOR<qnModelSetUpdateInput, qnModelSetUncheckedUpdateInput>
  }

  /**
   * qnModelSet delete
   */
  export type qnModelSetDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the qnModelSet
     */
    select?: qnModelSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the qnModelSet
     */
    omit?: qnModelSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: qnModelSetInclude<ExtArgs> | null
    /**
     * Filter which qnModelSet to delete.
     */
    where: qnModelSetWhereUniqueInput
  }

  /**
   * qnModelSet deleteMany
   */
  export type qnModelSetDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which qnModelSets to delete
     */
    where?: qnModelSetWhereInput
    /**
     * Limit how many qnModelSets to delete.
     */
    limit?: number
  }

  /**
   * qnModelSet.givenExams
   */
  export type qnModelSet$givenExamsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userGivenExamSet
     */
    select?: userGivenExamSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userGivenExamSet
     */
    omit?: userGivenExamSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userGivenExamSetInclude<ExtArgs> | null
    where?: userGivenExamSetWhereInput
    orderBy?: userGivenExamSetOrderByWithRelationInput | userGivenExamSetOrderByWithRelationInput[]
    cursor?: userGivenExamSetWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserGivenExamSetScalarFieldEnum | UserGivenExamSetScalarFieldEnum[]
  }

  /**
   * qnModelSet without action
   */
  export type qnModelSetDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the qnModelSet
     */
    select?: qnModelSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the qnModelSet
     */
    omit?: qnModelSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: qnModelSetInclude<ExtArgs> | null
  }


  /**
   * Model userGivenExamSet
   */

  export type AggregateUserGivenExamSet = {
    _count: UserGivenExamSetCountAggregateOutputType | null
    _avg: UserGivenExamSetAvgAggregateOutputType | null
    _sum: UserGivenExamSetSumAggregateOutputType | null
    _min: UserGivenExamSetMinAggregateOutputType | null
    _max: UserGivenExamSetMaxAggregateOutputType | null
  }

  export type UserGivenExamSetAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
    qn_set_id: number | null
  }

  export type UserGivenExamSetSumAggregateOutputType = {
    id: number | null
    user_id: number | null
    qn_set_id: number | null
  }

  export type UserGivenExamSetMinAggregateOutputType = {
    id: number | null
    user_id: number | null
    qn_set_id: number | null
    qn_title: string | null
    obtainedMarks: string | null
    examtimeTaken: string | null
    status: $Enums.Status | null
    createdAt: Date | null
    modifiedAt: Date | null
  }

  export type UserGivenExamSetMaxAggregateOutputType = {
    id: number | null
    user_id: number | null
    qn_set_id: number | null
    qn_title: string | null
    obtainedMarks: string | null
    examtimeTaken: string | null
    status: $Enums.Status | null
    createdAt: Date | null
    modifiedAt: Date | null
  }

  export type UserGivenExamSetCountAggregateOutputType = {
    id: number
    user_id: number
    qn_set_id: number
    qn_ans: number
    qn_title: number
    obtainedMarks: number
    examtimeTaken: number
    status: number
    createdAt: number
    modifiedAt: number
    _all: number
  }


  export type UserGivenExamSetAvgAggregateInputType = {
    id?: true
    user_id?: true
    qn_set_id?: true
  }

  export type UserGivenExamSetSumAggregateInputType = {
    id?: true
    user_id?: true
    qn_set_id?: true
  }

  export type UserGivenExamSetMinAggregateInputType = {
    id?: true
    user_id?: true
    qn_set_id?: true
    qn_title?: true
    obtainedMarks?: true
    examtimeTaken?: true
    status?: true
    createdAt?: true
    modifiedAt?: true
  }

  export type UserGivenExamSetMaxAggregateInputType = {
    id?: true
    user_id?: true
    qn_set_id?: true
    qn_title?: true
    obtainedMarks?: true
    examtimeTaken?: true
    status?: true
    createdAt?: true
    modifiedAt?: true
  }

  export type UserGivenExamSetCountAggregateInputType = {
    id?: true
    user_id?: true
    qn_set_id?: true
    qn_ans?: true
    qn_title?: true
    obtainedMarks?: true
    examtimeTaken?: true
    status?: true
    createdAt?: true
    modifiedAt?: true
    _all?: true
  }

  export type UserGivenExamSetAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which userGivenExamSet to aggregate.
     */
    where?: userGivenExamSetWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of userGivenExamSets to fetch.
     */
    orderBy?: userGivenExamSetOrderByWithRelationInput | userGivenExamSetOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: userGivenExamSetWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` userGivenExamSets from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` userGivenExamSets.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned userGivenExamSets
    **/
    _count?: true | UserGivenExamSetCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: UserGivenExamSetAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: UserGivenExamSetSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserGivenExamSetMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserGivenExamSetMaxAggregateInputType
  }

  export type GetUserGivenExamSetAggregateType<T extends UserGivenExamSetAggregateArgs> = {
        [P in keyof T & keyof AggregateUserGivenExamSet]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUserGivenExamSet[P]>
      : GetScalarType<T[P], AggregateUserGivenExamSet[P]>
  }




  export type userGivenExamSetGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: userGivenExamSetWhereInput
    orderBy?: userGivenExamSetOrderByWithAggregationInput | userGivenExamSetOrderByWithAggregationInput[]
    by: UserGivenExamSetScalarFieldEnum[] | UserGivenExamSetScalarFieldEnum
    having?: userGivenExamSetScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserGivenExamSetCountAggregateInputType | true
    _avg?: UserGivenExamSetAvgAggregateInputType
    _sum?: UserGivenExamSetSumAggregateInputType
    _min?: UserGivenExamSetMinAggregateInputType
    _max?: UserGivenExamSetMaxAggregateInputType
  }

  export type UserGivenExamSetGroupByOutputType = {
    id: number
    user_id: number
    qn_set_id: number
    qn_ans: JsonValue
    qn_title: string
    obtainedMarks: string
    examtimeTaken: string
    status: $Enums.Status
    createdAt: Date
    modifiedAt: Date | null
    _count: UserGivenExamSetCountAggregateOutputType | null
    _avg: UserGivenExamSetAvgAggregateOutputType | null
    _sum: UserGivenExamSetSumAggregateOutputType | null
    _min: UserGivenExamSetMinAggregateOutputType | null
    _max: UserGivenExamSetMaxAggregateOutputType | null
  }

  type GetUserGivenExamSetGroupByPayload<T extends userGivenExamSetGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserGivenExamSetGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserGivenExamSetGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserGivenExamSetGroupByOutputType[P]>
            : GetScalarType<T[P], UserGivenExamSetGroupByOutputType[P]>
        }
      >
    >


  export type userGivenExamSetSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    qn_set_id?: boolean
    qn_ans?: boolean
    qn_title?: boolean
    obtainedMarks?: boolean
    examtimeTaken?: boolean
    status?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
    qnModelSet?: boolean | qnModelSetDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userGivenExamSet"]>

  export type userGivenExamSetSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    qn_set_id?: boolean
    qn_ans?: boolean
    qn_title?: boolean
    obtainedMarks?: boolean
    examtimeTaken?: boolean
    status?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
    qnModelSet?: boolean | qnModelSetDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userGivenExamSet"]>

  export type userGivenExamSetSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    qn_set_id?: boolean
    qn_ans?: boolean
    qn_title?: boolean
    obtainedMarks?: boolean
    examtimeTaken?: boolean
    status?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
    qnModelSet?: boolean | qnModelSetDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userGivenExamSet"]>

  export type userGivenExamSetSelectScalar = {
    id?: boolean
    user_id?: boolean
    qn_set_id?: boolean
    qn_ans?: boolean
    qn_title?: boolean
    obtainedMarks?: boolean
    examtimeTaken?: boolean
    status?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
  }

  export type userGivenExamSetOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "user_id" | "qn_set_id" | "qn_ans" | "qn_title" | "obtainedMarks" | "examtimeTaken" | "status" | "createdAt" | "modifiedAt", ExtArgs["result"]["userGivenExamSet"]>
  export type userGivenExamSetInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
    qnModelSet?: boolean | qnModelSetDefaultArgs<ExtArgs>
  }
  export type userGivenExamSetIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
    qnModelSet?: boolean | qnModelSetDefaultArgs<ExtArgs>
  }
  export type userGivenExamSetIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
    qnModelSet?: boolean | qnModelSetDefaultArgs<ExtArgs>
  }

  export type $userGivenExamSetPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "userGivenExamSet"
    objects: {
      user: Prisma.$UserPayload<ExtArgs>
      qnModelSet: Prisma.$qnModelSetPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      user_id: number
      qn_set_id: number
      qn_ans: Prisma.JsonValue
      qn_title: string
      obtainedMarks: string
      examtimeTaken: string
      status: $Enums.Status
      createdAt: Date
      modifiedAt: Date | null
    }, ExtArgs["result"]["userGivenExamSet"]>
    composites: {}
  }

  type userGivenExamSetGetPayload<S extends boolean | null | undefined | userGivenExamSetDefaultArgs> = $Result.GetResult<Prisma.$userGivenExamSetPayload, S>

  type userGivenExamSetCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<userGivenExamSetFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: UserGivenExamSetCountAggregateInputType | true
    }

  export interface userGivenExamSetDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['userGivenExamSet'], meta: { name: 'userGivenExamSet' } }
    /**
     * Find zero or one UserGivenExamSet that matches the filter.
     * @param {userGivenExamSetFindUniqueArgs} args - Arguments to find a UserGivenExamSet
     * @example
     * // Get one UserGivenExamSet
     * const userGivenExamSet = await prisma.userGivenExamSet.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends userGivenExamSetFindUniqueArgs>(args: SelectSubset<T, userGivenExamSetFindUniqueArgs<ExtArgs>>): Prisma__userGivenExamSetClient<$Result.GetResult<Prisma.$userGivenExamSetPayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one UserGivenExamSet that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {userGivenExamSetFindUniqueOrThrowArgs} args - Arguments to find a UserGivenExamSet
     * @example
     * // Get one UserGivenExamSet
     * const userGivenExamSet = await prisma.userGivenExamSet.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends userGivenExamSetFindUniqueOrThrowArgs>(args: SelectSubset<T, userGivenExamSetFindUniqueOrThrowArgs<ExtArgs>>): Prisma__userGivenExamSetClient<$Result.GetResult<Prisma.$userGivenExamSetPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first UserGivenExamSet that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {userGivenExamSetFindFirstArgs} args - Arguments to find a UserGivenExamSet
     * @example
     * // Get one UserGivenExamSet
     * const userGivenExamSet = await prisma.userGivenExamSet.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends userGivenExamSetFindFirstArgs>(args?: SelectSubset<T, userGivenExamSetFindFirstArgs<ExtArgs>>): Prisma__userGivenExamSetClient<$Result.GetResult<Prisma.$userGivenExamSetPayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first UserGivenExamSet that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {userGivenExamSetFindFirstOrThrowArgs} args - Arguments to find a UserGivenExamSet
     * @example
     * // Get one UserGivenExamSet
     * const userGivenExamSet = await prisma.userGivenExamSet.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends userGivenExamSetFindFirstOrThrowArgs>(args?: SelectSubset<T, userGivenExamSetFindFirstOrThrowArgs<ExtArgs>>): Prisma__userGivenExamSetClient<$Result.GetResult<Prisma.$userGivenExamSetPayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more UserGivenExamSets that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {userGivenExamSetFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all UserGivenExamSets
     * const userGivenExamSets = await prisma.userGivenExamSet.findMany()
     * 
     * // Get first 10 UserGivenExamSets
     * const userGivenExamSets = await prisma.userGivenExamSet.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const userGivenExamSetWithIdOnly = await prisma.userGivenExamSet.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends userGivenExamSetFindManyArgs>(args?: SelectSubset<T, userGivenExamSetFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$userGivenExamSetPayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a UserGivenExamSet.
     * @param {userGivenExamSetCreateArgs} args - Arguments to create a UserGivenExamSet.
     * @example
     * // Create one UserGivenExamSet
     * const UserGivenExamSet = await prisma.userGivenExamSet.create({
     *   data: {
     *     // ... data to create a UserGivenExamSet
     *   }
     * })
     * 
     */
    create<T extends userGivenExamSetCreateArgs>(args: SelectSubset<T, userGivenExamSetCreateArgs<ExtArgs>>): Prisma__userGivenExamSetClient<$Result.GetResult<Prisma.$userGivenExamSetPayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many UserGivenExamSets.
     * @param {userGivenExamSetCreateManyArgs} args - Arguments to create many UserGivenExamSets.
     * @example
     * // Create many UserGivenExamSets
     * const userGivenExamSet = await prisma.userGivenExamSet.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends userGivenExamSetCreateManyArgs>(args?: SelectSubset<T, userGivenExamSetCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many UserGivenExamSets and returns the data saved in the database.
     * @param {userGivenExamSetCreateManyAndReturnArgs} args - Arguments to create many UserGivenExamSets.
     * @example
     * // Create many UserGivenExamSets
     * const userGivenExamSet = await prisma.userGivenExamSet.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many UserGivenExamSets and only return the `id`
     * const userGivenExamSetWithIdOnly = await prisma.userGivenExamSet.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends userGivenExamSetCreateManyAndReturnArgs>(args?: SelectSubset<T, userGivenExamSetCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$userGivenExamSetPayload<ExtArgs>, T, "createManyAndReturn", GlobalOmitOptions>>

    /**
     * Delete a UserGivenExamSet.
     * @param {userGivenExamSetDeleteArgs} args - Arguments to delete one UserGivenExamSet.
     * @example
     * // Delete one UserGivenExamSet
     * const UserGivenExamSet = await prisma.userGivenExamSet.delete({
     *   where: {
     *     // ... filter to delete one UserGivenExamSet
     *   }
     * })
     * 
     */
    delete<T extends userGivenExamSetDeleteArgs>(args: SelectSubset<T, userGivenExamSetDeleteArgs<ExtArgs>>): Prisma__userGivenExamSetClient<$Result.GetResult<Prisma.$userGivenExamSetPayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one UserGivenExamSet.
     * @param {userGivenExamSetUpdateArgs} args - Arguments to update one UserGivenExamSet.
     * @example
     * // Update one UserGivenExamSet
     * const userGivenExamSet = await prisma.userGivenExamSet.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends userGivenExamSetUpdateArgs>(args: SelectSubset<T, userGivenExamSetUpdateArgs<ExtArgs>>): Prisma__userGivenExamSetClient<$Result.GetResult<Prisma.$userGivenExamSetPayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more UserGivenExamSets.
     * @param {userGivenExamSetDeleteManyArgs} args - Arguments to filter UserGivenExamSets to delete.
     * @example
     * // Delete a few UserGivenExamSets
     * const { count } = await prisma.userGivenExamSet.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends userGivenExamSetDeleteManyArgs>(args?: SelectSubset<T, userGivenExamSetDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more UserGivenExamSets.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {userGivenExamSetUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many UserGivenExamSets
     * const userGivenExamSet = await prisma.userGivenExamSet.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends userGivenExamSetUpdateManyArgs>(args: SelectSubset<T, userGivenExamSetUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more UserGivenExamSets and returns the data updated in the database.
     * @param {userGivenExamSetUpdateManyAndReturnArgs} args - Arguments to update many UserGivenExamSets.
     * @example
     * // Update many UserGivenExamSets
     * const userGivenExamSet = await prisma.userGivenExamSet.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more UserGivenExamSets and only return the `id`
     * const userGivenExamSetWithIdOnly = await prisma.userGivenExamSet.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends userGivenExamSetUpdateManyAndReturnArgs>(args: SelectSubset<T, userGivenExamSetUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$userGivenExamSetPayload<ExtArgs>, T, "updateManyAndReturn", GlobalOmitOptions>>

    /**
     * Create or update one UserGivenExamSet.
     * @param {userGivenExamSetUpsertArgs} args - Arguments to update or create a UserGivenExamSet.
     * @example
     * // Update or create a UserGivenExamSet
     * const userGivenExamSet = await prisma.userGivenExamSet.upsert({
     *   create: {
     *     // ... data to create a UserGivenExamSet
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the UserGivenExamSet we want to update
     *   }
     * })
     */
    upsert<T extends userGivenExamSetUpsertArgs>(args: SelectSubset<T, userGivenExamSetUpsertArgs<ExtArgs>>): Prisma__userGivenExamSetClient<$Result.GetResult<Prisma.$userGivenExamSetPayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of UserGivenExamSets.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {userGivenExamSetCountArgs} args - Arguments to filter UserGivenExamSets to count.
     * @example
     * // Count the number of UserGivenExamSets
     * const count = await prisma.userGivenExamSet.count({
     *   where: {
     *     // ... the filter for the UserGivenExamSets we want to count
     *   }
     * })
    **/
    count<T extends userGivenExamSetCountArgs>(
      args?: Subset<T, userGivenExamSetCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserGivenExamSetCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a UserGivenExamSet.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserGivenExamSetAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserGivenExamSetAggregateArgs>(args: Subset<T, UserGivenExamSetAggregateArgs>): Prisma.PrismaPromise<GetUserGivenExamSetAggregateType<T>>

    /**
     * Group by UserGivenExamSet.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {userGivenExamSetGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends userGivenExamSetGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: userGivenExamSetGroupByArgs['orderBy'] }
        : { orderBy?: userGivenExamSetGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, userGivenExamSetGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserGivenExamSetGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the userGivenExamSet model
   */
  readonly fields: userGivenExamSetFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for userGivenExamSet.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__userGivenExamSetClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    user<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    qnModelSet<T extends qnModelSetDefaultArgs<ExtArgs> = {}>(args?: Subset<T, qnModelSetDefaultArgs<ExtArgs>>): Prisma__qnModelSetClient<$Result.GetResult<Prisma.$qnModelSetPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the userGivenExamSet model
   */
  interface userGivenExamSetFieldRefs {
    readonly id: FieldRef<"userGivenExamSet", 'Int'>
    readonly user_id: FieldRef<"userGivenExamSet", 'Int'>
    readonly qn_set_id: FieldRef<"userGivenExamSet", 'Int'>
    readonly qn_ans: FieldRef<"userGivenExamSet", 'Json'>
    readonly qn_title: FieldRef<"userGivenExamSet", 'String'>
    readonly obtainedMarks: FieldRef<"userGivenExamSet", 'String'>
    readonly examtimeTaken: FieldRef<"userGivenExamSet", 'String'>
    readonly status: FieldRef<"userGivenExamSet", 'Status'>
    readonly createdAt: FieldRef<"userGivenExamSet", 'DateTime'>
    readonly modifiedAt: FieldRef<"userGivenExamSet", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * userGivenExamSet findUnique
   */
  export type userGivenExamSetFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userGivenExamSet
     */
    select?: userGivenExamSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userGivenExamSet
     */
    omit?: userGivenExamSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userGivenExamSetInclude<ExtArgs> | null
    /**
     * Filter, which userGivenExamSet to fetch.
     */
    where: userGivenExamSetWhereUniqueInput
  }

  /**
   * userGivenExamSet findUniqueOrThrow
   */
  export type userGivenExamSetFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userGivenExamSet
     */
    select?: userGivenExamSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userGivenExamSet
     */
    omit?: userGivenExamSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userGivenExamSetInclude<ExtArgs> | null
    /**
     * Filter, which userGivenExamSet to fetch.
     */
    where: userGivenExamSetWhereUniqueInput
  }

  /**
   * userGivenExamSet findFirst
   */
  export type userGivenExamSetFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userGivenExamSet
     */
    select?: userGivenExamSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userGivenExamSet
     */
    omit?: userGivenExamSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userGivenExamSetInclude<ExtArgs> | null
    /**
     * Filter, which userGivenExamSet to fetch.
     */
    where?: userGivenExamSetWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of userGivenExamSets to fetch.
     */
    orderBy?: userGivenExamSetOrderByWithRelationInput | userGivenExamSetOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for userGivenExamSets.
     */
    cursor?: userGivenExamSetWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` userGivenExamSets from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` userGivenExamSets.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of userGivenExamSets.
     */
    distinct?: UserGivenExamSetScalarFieldEnum | UserGivenExamSetScalarFieldEnum[]
  }

  /**
   * userGivenExamSet findFirstOrThrow
   */
  export type userGivenExamSetFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userGivenExamSet
     */
    select?: userGivenExamSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userGivenExamSet
     */
    omit?: userGivenExamSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userGivenExamSetInclude<ExtArgs> | null
    /**
     * Filter, which userGivenExamSet to fetch.
     */
    where?: userGivenExamSetWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of userGivenExamSets to fetch.
     */
    orderBy?: userGivenExamSetOrderByWithRelationInput | userGivenExamSetOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for userGivenExamSets.
     */
    cursor?: userGivenExamSetWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` userGivenExamSets from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` userGivenExamSets.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of userGivenExamSets.
     */
    distinct?: UserGivenExamSetScalarFieldEnum | UserGivenExamSetScalarFieldEnum[]
  }

  /**
   * userGivenExamSet findMany
   */
  export type userGivenExamSetFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userGivenExamSet
     */
    select?: userGivenExamSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userGivenExamSet
     */
    omit?: userGivenExamSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userGivenExamSetInclude<ExtArgs> | null
    /**
     * Filter, which userGivenExamSets to fetch.
     */
    where?: userGivenExamSetWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of userGivenExamSets to fetch.
     */
    orderBy?: userGivenExamSetOrderByWithRelationInput | userGivenExamSetOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing userGivenExamSets.
     */
    cursor?: userGivenExamSetWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` userGivenExamSets from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` userGivenExamSets.
     */
    skip?: number
    distinct?: UserGivenExamSetScalarFieldEnum | UserGivenExamSetScalarFieldEnum[]
  }

  /**
   * userGivenExamSet create
   */
  export type userGivenExamSetCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userGivenExamSet
     */
    select?: userGivenExamSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userGivenExamSet
     */
    omit?: userGivenExamSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userGivenExamSetInclude<ExtArgs> | null
    /**
     * The data needed to create a userGivenExamSet.
     */
    data: XOR<userGivenExamSetCreateInput, userGivenExamSetUncheckedCreateInput>
  }

  /**
   * userGivenExamSet createMany
   */
  export type userGivenExamSetCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many userGivenExamSets.
     */
    data: userGivenExamSetCreateManyInput | userGivenExamSetCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * userGivenExamSet createManyAndReturn
   */
  export type userGivenExamSetCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userGivenExamSet
     */
    select?: userGivenExamSetSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the userGivenExamSet
     */
    omit?: userGivenExamSetOmit<ExtArgs> | null
    /**
     * The data used to create many userGivenExamSets.
     */
    data: userGivenExamSetCreateManyInput | userGivenExamSetCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userGivenExamSetIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * userGivenExamSet update
   */
  export type userGivenExamSetUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userGivenExamSet
     */
    select?: userGivenExamSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userGivenExamSet
     */
    omit?: userGivenExamSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userGivenExamSetInclude<ExtArgs> | null
    /**
     * The data needed to update a userGivenExamSet.
     */
    data: XOR<userGivenExamSetUpdateInput, userGivenExamSetUncheckedUpdateInput>
    /**
     * Choose, which userGivenExamSet to update.
     */
    where: userGivenExamSetWhereUniqueInput
  }

  /**
   * userGivenExamSet updateMany
   */
  export type userGivenExamSetUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update userGivenExamSets.
     */
    data: XOR<userGivenExamSetUpdateManyMutationInput, userGivenExamSetUncheckedUpdateManyInput>
    /**
     * Filter which userGivenExamSets to update
     */
    where?: userGivenExamSetWhereInput
    /**
     * Limit how many userGivenExamSets to update.
     */
    limit?: number
  }

  /**
   * userGivenExamSet updateManyAndReturn
   */
  export type userGivenExamSetUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userGivenExamSet
     */
    select?: userGivenExamSetSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the userGivenExamSet
     */
    omit?: userGivenExamSetOmit<ExtArgs> | null
    /**
     * The data used to update userGivenExamSets.
     */
    data: XOR<userGivenExamSetUpdateManyMutationInput, userGivenExamSetUncheckedUpdateManyInput>
    /**
     * Filter which userGivenExamSets to update
     */
    where?: userGivenExamSetWhereInput
    /**
     * Limit how many userGivenExamSets to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userGivenExamSetIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * userGivenExamSet upsert
   */
  export type userGivenExamSetUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userGivenExamSet
     */
    select?: userGivenExamSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userGivenExamSet
     */
    omit?: userGivenExamSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userGivenExamSetInclude<ExtArgs> | null
    /**
     * The filter to search for the userGivenExamSet to update in case it exists.
     */
    where: userGivenExamSetWhereUniqueInput
    /**
     * In case the userGivenExamSet found by the `where` argument doesn't exist, create a new userGivenExamSet with this data.
     */
    create: XOR<userGivenExamSetCreateInput, userGivenExamSetUncheckedCreateInput>
    /**
     * In case the userGivenExamSet was found with the provided `where` argument, update it with this data.
     */
    update: XOR<userGivenExamSetUpdateInput, userGivenExamSetUncheckedUpdateInput>
  }

  /**
   * userGivenExamSet delete
   */
  export type userGivenExamSetDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userGivenExamSet
     */
    select?: userGivenExamSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userGivenExamSet
     */
    omit?: userGivenExamSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userGivenExamSetInclude<ExtArgs> | null
    /**
     * Filter which userGivenExamSet to delete.
     */
    where: userGivenExamSetWhereUniqueInput
  }

  /**
   * userGivenExamSet deleteMany
   */
  export type userGivenExamSetDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which userGivenExamSets to delete
     */
    where?: userGivenExamSetWhereInput
    /**
     * Limit how many userGivenExamSets to delete.
     */
    limit?: number
  }

  /**
   * userGivenExamSet without action
   */
  export type userGivenExamSetDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userGivenExamSet
     */
    select?: userGivenExamSetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userGivenExamSet
     */
    omit?: userGivenExamSetOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userGivenExamSetInclude<ExtArgs> | null
  }


  /**
   * Model userSelectedCourse
   */

  export type AggregateUserSelectedCourse = {
    _count: UserSelectedCourseCountAggregateOutputType | null
    _avg: UserSelectedCourseAvgAggregateOutputType | null
    _sum: UserSelectedCourseSumAggregateOutputType | null
    _min: UserSelectedCourseMinAggregateOutputType | null
    _max: UserSelectedCourseMaxAggregateOutputType | null
  }

  export type UserSelectedCourseAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
    course_id: number | null
  }

  export type UserSelectedCourseSumAggregateOutputType = {
    id: number | null
    user_id: number | null
    course_id: number | null
  }

  export type UserSelectedCourseMinAggregateOutputType = {
    id: number | null
    user_id: number | null
    course_id: number | null
    createdAt: Date | null
    modifiedAt: Date | null
  }

  export type UserSelectedCourseMaxAggregateOutputType = {
    id: number | null
    user_id: number | null
    course_id: number | null
    createdAt: Date | null
    modifiedAt: Date | null
  }

  export type UserSelectedCourseCountAggregateOutputType = {
    id: number
    user_id: number
    course_id: number
    createdAt: number
    modifiedAt: number
    _all: number
  }


  export type UserSelectedCourseAvgAggregateInputType = {
    id?: true
    user_id?: true
    course_id?: true
  }

  export type UserSelectedCourseSumAggregateInputType = {
    id?: true
    user_id?: true
    course_id?: true
  }

  export type UserSelectedCourseMinAggregateInputType = {
    id?: true
    user_id?: true
    course_id?: true
    createdAt?: true
    modifiedAt?: true
  }

  export type UserSelectedCourseMaxAggregateInputType = {
    id?: true
    user_id?: true
    course_id?: true
    createdAt?: true
    modifiedAt?: true
  }

  export type UserSelectedCourseCountAggregateInputType = {
    id?: true
    user_id?: true
    course_id?: true
    createdAt?: true
    modifiedAt?: true
    _all?: true
  }

  export type UserSelectedCourseAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which userSelectedCourse to aggregate.
     */
    where?: userSelectedCourseWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of userSelectedCourses to fetch.
     */
    orderBy?: userSelectedCourseOrderByWithRelationInput | userSelectedCourseOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: userSelectedCourseWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` userSelectedCourses from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` userSelectedCourses.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned userSelectedCourses
    **/
    _count?: true | UserSelectedCourseCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: UserSelectedCourseAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: UserSelectedCourseSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserSelectedCourseMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserSelectedCourseMaxAggregateInputType
  }

  export type GetUserSelectedCourseAggregateType<T extends UserSelectedCourseAggregateArgs> = {
        [P in keyof T & keyof AggregateUserSelectedCourse]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUserSelectedCourse[P]>
      : GetScalarType<T[P], AggregateUserSelectedCourse[P]>
  }




  export type userSelectedCourseGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: userSelectedCourseWhereInput
    orderBy?: userSelectedCourseOrderByWithAggregationInput | userSelectedCourseOrderByWithAggregationInput[]
    by: UserSelectedCourseScalarFieldEnum[] | UserSelectedCourseScalarFieldEnum
    having?: userSelectedCourseScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserSelectedCourseCountAggregateInputType | true
    _avg?: UserSelectedCourseAvgAggregateInputType
    _sum?: UserSelectedCourseSumAggregateInputType
    _min?: UserSelectedCourseMinAggregateInputType
    _max?: UserSelectedCourseMaxAggregateInputType
  }

  export type UserSelectedCourseGroupByOutputType = {
    id: number
    user_id: number
    course_id: number
    createdAt: Date
    modifiedAt: Date | null
    _count: UserSelectedCourseCountAggregateOutputType | null
    _avg: UserSelectedCourseAvgAggregateOutputType | null
    _sum: UserSelectedCourseSumAggregateOutputType | null
    _min: UserSelectedCourseMinAggregateOutputType | null
    _max: UserSelectedCourseMaxAggregateOutputType | null
  }

  type GetUserSelectedCourseGroupByPayload<T extends userSelectedCourseGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserSelectedCourseGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserSelectedCourseGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserSelectedCourseGroupByOutputType[P]>
            : GetScalarType<T[P], UserSelectedCourseGroupByOutputType[P]>
        }
      >
    >


  export type userSelectedCourseSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    course_id?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
    course?: boolean | CourseDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userSelectedCourse"]>

  export type userSelectedCourseSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    course_id?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
    course?: boolean | CourseDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userSelectedCourse"]>

  export type userSelectedCourseSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    course_id?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
    course?: boolean | CourseDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userSelectedCourse"]>

  export type userSelectedCourseSelectScalar = {
    id?: boolean
    user_id?: boolean
    course_id?: boolean
    createdAt?: boolean
    modifiedAt?: boolean
  }

  export type userSelectedCourseOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "user_id" | "course_id" | "createdAt" | "modifiedAt", ExtArgs["result"]["userSelectedCourse"]>
  export type userSelectedCourseInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
    course?: boolean | CourseDefaultArgs<ExtArgs>
  }
  export type userSelectedCourseIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
    course?: boolean | CourseDefaultArgs<ExtArgs>
  }
  export type userSelectedCourseIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
    course?: boolean | CourseDefaultArgs<ExtArgs>
  }

  export type $userSelectedCoursePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "userSelectedCourse"
    objects: {
      user: Prisma.$UserPayload<ExtArgs>
      course: Prisma.$CoursePayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      user_id: number
      course_id: number
      createdAt: Date
      modifiedAt: Date | null
    }, ExtArgs["result"]["userSelectedCourse"]>
    composites: {}
  }

  type userSelectedCourseGetPayload<S extends boolean | null | undefined | userSelectedCourseDefaultArgs> = $Result.GetResult<Prisma.$userSelectedCoursePayload, S>

  type userSelectedCourseCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<userSelectedCourseFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: UserSelectedCourseCountAggregateInputType | true
    }

  export interface userSelectedCourseDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['userSelectedCourse'], meta: { name: 'userSelectedCourse' } }
    /**
     * Find zero or one UserSelectedCourse that matches the filter.
     * @param {userSelectedCourseFindUniqueArgs} args - Arguments to find a UserSelectedCourse
     * @example
     * // Get one UserSelectedCourse
     * const userSelectedCourse = await prisma.userSelectedCourse.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends userSelectedCourseFindUniqueArgs>(args: SelectSubset<T, userSelectedCourseFindUniqueArgs<ExtArgs>>): Prisma__userSelectedCourseClient<$Result.GetResult<Prisma.$userSelectedCoursePayload<ExtArgs>, T, "findUnique", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find one UserSelectedCourse that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {userSelectedCourseFindUniqueOrThrowArgs} args - Arguments to find a UserSelectedCourse
     * @example
     * // Get one UserSelectedCourse
     * const userSelectedCourse = await prisma.userSelectedCourse.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends userSelectedCourseFindUniqueOrThrowArgs>(args: SelectSubset<T, userSelectedCourseFindUniqueOrThrowArgs<ExtArgs>>): Prisma__userSelectedCourseClient<$Result.GetResult<Prisma.$userSelectedCoursePayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first UserSelectedCourse that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {userSelectedCourseFindFirstArgs} args - Arguments to find a UserSelectedCourse
     * @example
     * // Get one UserSelectedCourse
     * const userSelectedCourse = await prisma.userSelectedCourse.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends userSelectedCourseFindFirstArgs>(args?: SelectSubset<T, userSelectedCourseFindFirstArgs<ExtArgs>>): Prisma__userSelectedCourseClient<$Result.GetResult<Prisma.$userSelectedCoursePayload<ExtArgs>, T, "findFirst", GlobalOmitOptions> | null, null, ExtArgs, GlobalOmitOptions>

    /**
     * Find the first UserSelectedCourse that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {userSelectedCourseFindFirstOrThrowArgs} args - Arguments to find a UserSelectedCourse
     * @example
     * // Get one UserSelectedCourse
     * const userSelectedCourse = await prisma.userSelectedCourse.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends userSelectedCourseFindFirstOrThrowArgs>(args?: SelectSubset<T, userSelectedCourseFindFirstOrThrowArgs<ExtArgs>>): Prisma__userSelectedCourseClient<$Result.GetResult<Prisma.$userSelectedCoursePayload<ExtArgs>, T, "findFirstOrThrow", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Find zero or more UserSelectedCourses that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {userSelectedCourseFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all UserSelectedCourses
     * const userSelectedCourses = await prisma.userSelectedCourse.findMany()
     * 
     * // Get first 10 UserSelectedCourses
     * const userSelectedCourses = await prisma.userSelectedCourse.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const userSelectedCourseWithIdOnly = await prisma.userSelectedCourse.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends userSelectedCourseFindManyArgs>(args?: SelectSubset<T, userSelectedCourseFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$userSelectedCoursePayload<ExtArgs>, T, "findMany", GlobalOmitOptions>>

    /**
     * Create a UserSelectedCourse.
     * @param {userSelectedCourseCreateArgs} args - Arguments to create a UserSelectedCourse.
     * @example
     * // Create one UserSelectedCourse
     * const UserSelectedCourse = await prisma.userSelectedCourse.create({
     *   data: {
     *     // ... data to create a UserSelectedCourse
     *   }
     * })
     * 
     */
    create<T extends userSelectedCourseCreateArgs>(args: SelectSubset<T, userSelectedCourseCreateArgs<ExtArgs>>): Prisma__userSelectedCourseClient<$Result.GetResult<Prisma.$userSelectedCoursePayload<ExtArgs>, T, "create", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Create many UserSelectedCourses.
     * @param {userSelectedCourseCreateManyArgs} args - Arguments to create many UserSelectedCourses.
     * @example
     * // Create many UserSelectedCourses
     * const userSelectedCourse = await prisma.userSelectedCourse.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends userSelectedCourseCreateManyArgs>(args?: SelectSubset<T, userSelectedCourseCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many UserSelectedCourses and returns the data saved in the database.
     * @param {userSelectedCourseCreateManyAndReturnArgs} args - Arguments to create many UserSelectedCourses.
     * @example
     * // Create many UserSelectedCourses
     * const userSelectedCourse = await prisma.userSelectedCourse.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many UserSelectedCourses and only return the `id`
     * const userSelectedCourseWithIdOnly = await prisma.userSelectedCourse.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends userSelectedCourseCreateManyAndReturnArgs>(args?: SelectSubset<T, userSelectedCourseCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$userSelectedCoursePayload<ExtArgs>, T, "createManyAndReturn", GlobalOmitOptions>>

    /**
     * Delete a UserSelectedCourse.
     * @param {userSelectedCourseDeleteArgs} args - Arguments to delete one UserSelectedCourse.
     * @example
     * // Delete one UserSelectedCourse
     * const UserSelectedCourse = await prisma.userSelectedCourse.delete({
     *   where: {
     *     // ... filter to delete one UserSelectedCourse
     *   }
     * })
     * 
     */
    delete<T extends userSelectedCourseDeleteArgs>(args: SelectSubset<T, userSelectedCourseDeleteArgs<ExtArgs>>): Prisma__userSelectedCourseClient<$Result.GetResult<Prisma.$userSelectedCoursePayload<ExtArgs>, T, "delete", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Update one UserSelectedCourse.
     * @param {userSelectedCourseUpdateArgs} args - Arguments to update one UserSelectedCourse.
     * @example
     * // Update one UserSelectedCourse
     * const userSelectedCourse = await prisma.userSelectedCourse.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends userSelectedCourseUpdateArgs>(args: SelectSubset<T, userSelectedCourseUpdateArgs<ExtArgs>>): Prisma__userSelectedCourseClient<$Result.GetResult<Prisma.$userSelectedCoursePayload<ExtArgs>, T, "update", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>

    /**
     * Delete zero or more UserSelectedCourses.
     * @param {userSelectedCourseDeleteManyArgs} args - Arguments to filter UserSelectedCourses to delete.
     * @example
     * // Delete a few UserSelectedCourses
     * const { count } = await prisma.userSelectedCourse.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends userSelectedCourseDeleteManyArgs>(args?: SelectSubset<T, userSelectedCourseDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more UserSelectedCourses.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {userSelectedCourseUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many UserSelectedCourses
     * const userSelectedCourse = await prisma.userSelectedCourse.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends userSelectedCourseUpdateManyArgs>(args: SelectSubset<T, userSelectedCourseUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more UserSelectedCourses and returns the data updated in the database.
     * @param {userSelectedCourseUpdateManyAndReturnArgs} args - Arguments to update many UserSelectedCourses.
     * @example
     * // Update many UserSelectedCourses
     * const userSelectedCourse = await prisma.userSelectedCourse.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more UserSelectedCourses and only return the `id`
     * const userSelectedCourseWithIdOnly = await prisma.userSelectedCourse.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends userSelectedCourseUpdateManyAndReturnArgs>(args: SelectSubset<T, userSelectedCourseUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$userSelectedCoursePayload<ExtArgs>, T, "updateManyAndReturn", GlobalOmitOptions>>

    /**
     * Create or update one UserSelectedCourse.
     * @param {userSelectedCourseUpsertArgs} args - Arguments to update or create a UserSelectedCourse.
     * @example
     * // Update or create a UserSelectedCourse
     * const userSelectedCourse = await prisma.userSelectedCourse.upsert({
     *   create: {
     *     // ... data to create a UserSelectedCourse
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the UserSelectedCourse we want to update
     *   }
     * })
     */
    upsert<T extends userSelectedCourseUpsertArgs>(args: SelectSubset<T, userSelectedCourseUpsertArgs<ExtArgs>>): Prisma__userSelectedCourseClient<$Result.GetResult<Prisma.$userSelectedCoursePayload<ExtArgs>, T, "upsert", GlobalOmitOptions>, never, ExtArgs, GlobalOmitOptions>


    /**
     * Count the number of UserSelectedCourses.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {userSelectedCourseCountArgs} args - Arguments to filter UserSelectedCourses to count.
     * @example
     * // Count the number of UserSelectedCourses
     * const count = await prisma.userSelectedCourse.count({
     *   where: {
     *     // ... the filter for the UserSelectedCourses we want to count
     *   }
     * })
    **/
    count<T extends userSelectedCourseCountArgs>(
      args?: Subset<T, userSelectedCourseCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserSelectedCourseCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a UserSelectedCourse.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserSelectedCourseAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserSelectedCourseAggregateArgs>(args: Subset<T, UserSelectedCourseAggregateArgs>): Prisma.PrismaPromise<GetUserSelectedCourseAggregateType<T>>

    /**
     * Group by UserSelectedCourse.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {userSelectedCourseGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends userSelectedCourseGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: userSelectedCourseGroupByArgs['orderBy'] }
        : { orderBy?: userSelectedCourseGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, userSelectedCourseGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserSelectedCourseGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the userSelectedCourse model
   */
  readonly fields: userSelectedCourseFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for userSelectedCourse.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__userSelectedCourseClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, GlobalOmitOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    user<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    course<T extends CourseDefaultArgs<ExtArgs> = {}>(args?: Subset<T, CourseDefaultArgs<ExtArgs>>): Prisma__CourseClient<$Result.GetResult<Prisma.$CoursePayload<ExtArgs>, T, "findUniqueOrThrow", GlobalOmitOptions> | Null, Null, ExtArgs, GlobalOmitOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the userSelectedCourse model
   */
  interface userSelectedCourseFieldRefs {
    readonly id: FieldRef<"userSelectedCourse", 'Int'>
    readonly user_id: FieldRef<"userSelectedCourse", 'Int'>
    readonly course_id: FieldRef<"userSelectedCourse", 'Int'>
    readonly createdAt: FieldRef<"userSelectedCourse", 'DateTime'>
    readonly modifiedAt: FieldRef<"userSelectedCourse", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * userSelectedCourse findUnique
   */
  export type userSelectedCourseFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userSelectedCourse
     */
    select?: userSelectedCourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userSelectedCourse
     */
    omit?: userSelectedCourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userSelectedCourseInclude<ExtArgs> | null
    /**
     * Filter, which userSelectedCourse to fetch.
     */
    where: userSelectedCourseWhereUniqueInput
  }

  /**
   * userSelectedCourse findUniqueOrThrow
   */
  export type userSelectedCourseFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userSelectedCourse
     */
    select?: userSelectedCourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userSelectedCourse
     */
    omit?: userSelectedCourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userSelectedCourseInclude<ExtArgs> | null
    /**
     * Filter, which userSelectedCourse to fetch.
     */
    where: userSelectedCourseWhereUniqueInput
  }

  /**
   * userSelectedCourse findFirst
   */
  export type userSelectedCourseFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userSelectedCourse
     */
    select?: userSelectedCourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userSelectedCourse
     */
    omit?: userSelectedCourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userSelectedCourseInclude<ExtArgs> | null
    /**
     * Filter, which userSelectedCourse to fetch.
     */
    where?: userSelectedCourseWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of userSelectedCourses to fetch.
     */
    orderBy?: userSelectedCourseOrderByWithRelationInput | userSelectedCourseOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for userSelectedCourses.
     */
    cursor?: userSelectedCourseWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` userSelectedCourses from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` userSelectedCourses.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of userSelectedCourses.
     */
    distinct?: UserSelectedCourseScalarFieldEnum | UserSelectedCourseScalarFieldEnum[]
  }

  /**
   * userSelectedCourse findFirstOrThrow
   */
  export type userSelectedCourseFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userSelectedCourse
     */
    select?: userSelectedCourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userSelectedCourse
     */
    omit?: userSelectedCourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userSelectedCourseInclude<ExtArgs> | null
    /**
     * Filter, which userSelectedCourse to fetch.
     */
    where?: userSelectedCourseWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of userSelectedCourses to fetch.
     */
    orderBy?: userSelectedCourseOrderByWithRelationInput | userSelectedCourseOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for userSelectedCourses.
     */
    cursor?: userSelectedCourseWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` userSelectedCourses from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` userSelectedCourses.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of userSelectedCourses.
     */
    distinct?: UserSelectedCourseScalarFieldEnum | UserSelectedCourseScalarFieldEnum[]
  }

  /**
   * userSelectedCourse findMany
   */
  export type userSelectedCourseFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userSelectedCourse
     */
    select?: userSelectedCourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userSelectedCourse
     */
    omit?: userSelectedCourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userSelectedCourseInclude<ExtArgs> | null
    /**
     * Filter, which userSelectedCourses to fetch.
     */
    where?: userSelectedCourseWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of userSelectedCourses to fetch.
     */
    orderBy?: userSelectedCourseOrderByWithRelationInput | userSelectedCourseOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing userSelectedCourses.
     */
    cursor?: userSelectedCourseWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` userSelectedCourses from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` userSelectedCourses.
     */
    skip?: number
    distinct?: UserSelectedCourseScalarFieldEnum | UserSelectedCourseScalarFieldEnum[]
  }

  /**
   * userSelectedCourse create
   */
  export type userSelectedCourseCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userSelectedCourse
     */
    select?: userSelectedCourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userSelectedCourse
     */
    omit?: userSelectedCourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userSelectedCourseInclude<ExtArgs> | null
    /**
     * The data needed to create a userSelectedCourse.
     */
    data: XOR<userSelectedCourseCreateInput, userSelectedCourseUncheckedCreateInput>
  }

  /**
   * userSelectedCourse createMany
   */
  export type userSelectedCourseCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many userSelectedCourses.
     */
    data: userSelectedCourseCreateManyInput | userSelectedCourseCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * userSelectedCourse createManyAndReturn
   */
  export type userSelectedCourseCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userSelectedCourse
     */
    select?: userSelectedCourseSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the userSelectedCourse
     */
    omit?: userSelectedCourseOmit<ExtArgs> | null
    /**
     * The data used to create many userSelectedCourses.
     */
    data: userSelectedCourseCreateManyInput | userSelectedCourseCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userSelectedCourseIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * userSelectedCourse update
   */
  export type userSelectedCourseUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userSelectedCourse
     */
    select?: userSelectedCourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userSelectedCourse
     */
    omit?: userSelectedCourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userSelectedCourseInclude<ExtArgs> | null
    /**
     * The data needed to update a userSelectedCourse.
     */
    data: XOR<userSelectedCourseUpdateInput, userSelectedCourseUncheckedUpdateInput>
    /**
     * Choose, which userSelectedCourse to update.
     */
    where: userSelectedCourseWhereUniqueInput
  }

  /**
   * userSelectedCourse updateMany
   */
  export type userSelectedCourseUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update userSelectedCourses.
     */
    data: XOR<userSelectedCourseUpdateManyMutationInput, userSelectedCourseUncheckedUpdateManyInput>
    /**
     * Filter which userSelectedCourses to update
     */
    where?: userSelectedCourseWhereInput
    /**
     * Limit how many userSelectedCourses to update.
     */
    limit?: number
  }

  /**
   * userSelectedCourse updateManyAndReturn
   */
  export type userSelectedCourseUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userSelectedCourse
     */
    select?: userSelectedCourseSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the userSelectedCourse
     */
    omit?: userSelectedCourseOmit<ExtArgs> | null
    /**
     * The data used to update userSelectedCourses.
     */
    data: XOR<userSelectedCourseUpdateManyMutationInput, userSelectedCourseUncheckedUpdateManyInput>
    /**
     * Filter which userSelectedCourses to update
     */
    where?: userSelectedCourseWhereInput
    /**
     * Limit how many userSelectedCourses to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userSelectedCourseIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * userSelectedCourse upsert
   */
  export type userSelectedCourseUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userSelectedCourse
     */
    select?: userSelectedCourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userSelectedCourse
     */
    omit?: userSelectedCourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userSelectedCourseInclude<ExtArgs> | null
    /**
     * The filter to search for the userSelectedCourse to update in case it exists.
     */
    where: userSelectedCourseWhereUniqueInput
    /**
     * In case the userSelectedCourse found by the `where` argument doesn't exist, create a new userSelectedCourse with this data.
     */
    create: XOR<userSelectedCourseCreateInput, userSelectedCourseUncheckedCreateInput>
    /**
     * In case the userSelectedCourse was found with the provided `where` argument, update it with this data.
     */
    update: XOR<userSelectedCourseUpdateInput, userSelectedCourseUncheckedUpdateInput>
  }

  /**
   * userSelectedCourse delete
   */
  export type userSelectedCourseDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userSelectedCourse
     */
    select?: userSelectedCourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userSelectedCourse
     */
    omit?: userSelectedCourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userSelectedCourseInclude<ExtArgs> | null
    /**
     * Filter which userSelectedCourse to delete.
     */
    where: userSelectedCourseWhereUniqueInput
  }

  /**
   * userSelectedCourse deleteMany
   */
  export type userSelectedCourseDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which userSelectedCourses to delete
     */
    where?: userSelectedCourseWhereInput
    /**
     * Limit how many userSelectedCourses to delete.
     */
    limit?: number
  }

  /**
   * userSelectedCourse without action
   */
  export type userSelectedCourseDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the userSelectedCourse
     */
    select?: userSelectedCourseSelect<ExtArgs> | null
    /**
     * Omit specific fields from the userSelectedCourse
     */
    omit?: userSelectedCourseOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: userSelectedCourseInclude<ExtArgs> | null
  }


  /**
   * Enums
   */

  export const TransactionIsolationLevel: {
    ReadUncommitted: 'ReadUncommitted',
    ReadCommitted: 'ReadCommitted',
    RepeatableRead: 'RepeatableRead',
    Serializable: 'Serializable'
  };

  export type TransactionIsolationLevel = (typeof TransactionIsolationLevel)[keyof typeof TransactionIsolationLevel]


  export const UserScalarFieldEnum: {
    id: 'id',
    name: 'name',
    email: 'email',
    status: 'status',
    password: 'password',
    createdAt: 'createdAt',
    modifiedAt: 'modifiedAt'
  };

  export type UserScalarFieldEnum = (typeof UserScalarFieldEnum)[keyof typeof UserScalarFieldEnum]


  export const CategoryScalarFieldEnum: {
    id: 'id',
    category_name: 'category_name',
    status: 'status',
    tag: 'tag',
    createdAt: 'createdAt',
    modifiedAt: 'modifiedAt'
  };

  export type CategoryScalarFieldEnum = (typeof CategoryScalarFieldEnum)[keyof typeof CategoryScalarFieldEnum]


  export const CourseScalarFieldEnum: {
    id: 'id',
    course_name: 'course_name',
    status: 'status',
    tag: 'tag',
    category_id: 'category_id',
    createdAt: 'createdAt',
    modifiedAt: 'modifiedAt'
  };

  export type CourseScalarFieldEnum = (typeof CourseScalarFieldEnum)[keyof typeof CourseScalarFieldEnum]


  export const QnModelSetScalarFieldEnum: {
    id: 'id',
    qn_title: 'qn_title',
    modelset_info: 'modelset_info',
    qn_set: 'qn_set',
    exam_time: 'exam_time',
    status: 'status',
    tag: 'tag',
    createBy: 'createBy',
    course_id: 'course_id',
    createdAt: 'createdAt',
    modifiedAt: 'modifiedAt'
  };

  export type QnModelSetScalarFieldEnum = (typeof QnModelSetScalarFieldEnum)[keyof typeof QnModelSetScalarFieldEnum]


  export const UserGivenExamSetScalarFieldEnum: {
    id: 'id',
    user_id: 'user_id',
    qn_set_id: 'qn_set_id',
    qn_ans: 'qn_ans',
    qn_title: 'qn_title',
    obtainedMarks: 'obtainedMarks',
    examtimeTaken: 'examtimeTaken',
    status: 'status',
    createdAt: 'createdAt',
    modifiedAt: 'modifiedAt'
  };

  export type UserGivenExamSetScalarFieldEnum = (typeof UserGivenExamSetScalarFieldEnum)[keyof typeof UserGivenExamSetScalarFieldEnum]


  export const UserSelectedCourseScalarFieldEnum: {
    id: 'id',
    user_id: 'user_id',
    course_id: 'course_id',
    createdAt: 'createdAt',
    modifiedAt: 'modifiedAt'
  };

  export type UserSelectedCourseScalarFieldEnum = (typeof UserSelectedCourseScalarFieldEnum)[keyof typeof UserSelectedCourseScalarFieldEnum]


  export const SortOrder: {
    asc: 'asc',
    desc: 'desc'
  };

  export type SortOrder = (typeof SortOrder)[keyof typeof SortOrder]


  export const JsonNullValueInput: {
    JsonNull: typeof JsonNull
  };

  export type JsonNullValueInput = (typeof JsonNullValueInput)[keyof typeof JsonNullValueInput]


  export const QueryMode: {
    default: 'default',
    insensitive: 'insensitive'
  };

  export type QueryMode = (typeof QueryMode)[keyof typeof QueryMode]


  export const NullsOrder: {
    first: 'first',
    last: 'last'
  };

  export type NullsOrder = (typeof NullsOrder)[keyof typeof NullsOrder]


  export const JsonNullValueFilter: {
    DbNull: typeof DbNull,
    JsonNull: typeof JsonNull,
    AnyNull: typeof AnyNull
  };

  export type JsonNullValueFilter = (typeof JsonNullValueFilter)[keyof typeof JsonNullValueFilter]


  /**
   * Field references
   */


  /**
   * Reference to a field of type 'Int'
   */
  export type IntFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Int'>
    


  /**
   * Reference to a field of type 'Int[]'
   */
  export type ListIntFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Int[]'>
    


  /**
   * Reference to a field of type 'String'
   */
  export type StringFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'String'>
    


  /**
   * Reference to a field of type 'String[]'
   */
  export type ListStringFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'String[]'>
    


  /**
   * Reference to a field of type 'Role'
   */
  export type EnumRoleFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Role'>
    


  /**
   * Reference to a field of type 'Role[]'
   */
  export type ListEnumRoleFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Role[]'>
    


  /**
   * Reference to a field of type 'DateTime'
   */
  export type DateTimeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'DateTime'>
    


  /**
   * Reference to a field of type 'DateTime[]'
   */
  export type ListDateTimeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'DateTime[]'>
    


  /**
   * Reference to a field of type 'Status'
   */
  export type EnumStatusFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Status'>
    


  /**
   * Reference to a field of type 'Status[]'
   */
  export type ListEnumStatusFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Status[]'>
    


  /**
   * Reference to a field of type 'Json'
   */
  export type JsonFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Json'>
    


  /**
   * Reference to a field of type 'QueryMode'
   */
  export type EnumQueryModeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'QueryMode'>
    


  /**
   * Reference to a field of type 'Float'
   */
  export type FloatFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Float'>
    


  /**
   * Reference to a field of type 'Float[]'
   */
  export type ListFloatFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Float[]'>
    
  /**
   * Deep Input Types
   */


  export type UserWhereInput = {
    AND?: UserWhereInput | UserWhereInput[]
    OR?: UserWhereInput[]
    NOT?: UserWhereInput | UserWhereInput[]
    id?: IntFilter<"User"> | number
    name?: StringFilter<"User"> | string
    email?: StringFilter<"User"> | string
    status?: EnumRoleFilter<"User"> | $Enums.Role
    password?: StringFilter<"User"> | string
    createdAt?: DateTimeFilter<"User"> | Date | string
    modifiedAt?: DateTimeNullableFilter<"User"> | Date | string | null
    examSets?: UserGivenExamSetListRelationFilter
    selectedCourses?: UserSelectedCourseListRelationFilter
  }

  export type UserOrderByWithRelationInput = {
    id?: SortOrder
    name?: SortOrder
    email?: SortOrder
    status?: SortOrder
    password?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrderInput | SortOrder
    examSets?: userGivenExamSetOrderByRelationAggregateInput
    selectedCourses?: userSelectedCourseOrderByRelationAggregateInput
  }

  export type UserWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    email?: string
    AND?: UserWhereInput | UserWhereInput[]
    OR?: UserWhereInput[]
    NOT?: UserWhereInput | UserWhereInput[]
    name?: StringFilter<"User"> | string
    status?: EnumRoleFilter<"User"> | $Enums.Role
    password?: StringFilter<"User"> | string
    createdAt?: DateTimeFilter<"User"> | Date | string
    modifiedAt?: DateTimeNullableFilter<"User"> | Date | string | null
    examSets?: UserGivenExamSetListRelationFilter
    selectedCourses?: UserSelectedCourseListRelationFilter
  }, "id" | "email">

  export type UserOrderByWithAggregationInput = {
    id?: SortOrder
    name?: SortOrder
    email?: SortOrder
    status?: SortOrder
    password?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrderInput | SortOrder
    _count?: UserCountOrderByAggregateInput
    _avg?: UserAvgOrderByAggregateInput
    _max?: UserMaxOrderByAggregateInput
    _min?: UserMinOrderByAggregateInput
    _sum?: UserSumOrderByAggregateInput
  }

  export type UserScalarWhereWithAggregatesInput = {
    AND?: UserScalarWhereWithAggregatesInput | UserScalarWhereWithAggregatesInput[]
    OR?: UserScalarWhereWithAggregatesInput[]
    NOT?: UserScalarWhereWithAggregatesInput | UserScalarWhereWithAggregatesInput[]
    id?: IntWithAggregatesFilter<"User"> | number
    name?: StringWithAggregatesFilter<"User"> | string
    email?: StringWithAggregatesFilter<"User"> | string
    status?: EnumRoleWithAggregatesFilter<"User"> | $Enums.Role
    password?: StringWithAggregatesFilter<"User"> | string
    createdAt?: DateTimeWithAggregatesFilter<"User"> | Date | string
    modifiedAt?: DateTimeNullableWithAggregatesFilter<"User"> | Date | string | null
  }

  export type CategoryWhereInput = {
    AND?: CategoryWhereInput | CategoryWhereInput[]
    OR?: CategoryWhereInput[]
    NOT?: CategoryWhereInput | CategoryWhereInput[]
    id?: IntFilter<"Category"> | number
    category_name?: StringFilter<"Category"> | string
    status?: EnumStatusFilter<"Category"> | $Enums.Status
    tag?: StringNullableListFilter<"Category">
    createdAt?: DateTimeFilter<"Category"> | Date | string
    modifiedAt?: DateTimeNullableFilter<"Category"> | Date | string | null
    courses?: CourseListRelationFilter
  }

  export type CategoryOrderByWithRelationInput = {
    id?: SortOrder
    category_name?: SortOrder
    status?: SortOrder
    tag?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrderInput | SortOrder
    courses?: CourseOrderByRelationAggregateInput
  }

  export type CategoryWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    AND?: CategoryWhereInput | CategoryWhereInput[]
    OR?: CategoryWhereInput[]
    NOT?: CategoryWhereInput | CategoryWhereInput[]
    category_name?: StringFilter<"Category"> | string
    status?: EnumStatusFilter<"Category"> | $Enums.Status
    tag?: StringNullableListFilter<"Category">
    createdAt?: DateTimeFilter<"Category"> | Date | string
    modifiedAt?: DateTimeNullableFilter<"Category"> | Date | string | null
    courses?: CourseListRelationFilter
  }, "id">

  export type CategoryOrderByWithAggregationInput = {
    id?: SortOrder
    category_name?: SortOrder
    status?: SortOrder
    tag?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrderInput | SortOrder
    _count?: CategoryCountOrderByAggregateInput
    _avg?: CategoryAvgOrderByAggregateInput
    _max?: CategoryMaxOrderByAggregateInput
    _min?: CategoryMinOrderByAggregateInput
    _sum?: CategorySumOrderByAggregateInput
  }

  export type CategoryScalarWhereWithAggregatesInput = {
    AND?: CategoryScalarWhereWithAggregatesInput | CategoryScalarWhereWithAggregatesInput[]
    OR?: CategoryScalarWhereWithAggregatesInput[]
    NOT?: CategoryScalarWhereWithAggregatesInput | CategoryScalarWhereWithAggregatesInput[]
    id?: IntWithAggregatesFilter<"Category"> | number
    category_name?: StringWithAggregatesFilter<"Category"> | string
    status?: EnumStatusWithAggregatesFilter<"Category"> | $Enums.Status
    tag?: StringNullableListFilter<"Category">
    createdAt?: DateTimeWithAggregatesFilter<"Category"> | Date | string
    modifiedAt?: DateTimeNullableWithAggregatesFilter<"Category"> | Date | string | null
  }

  export type CourseWhereInput = {
    AND?: CourseWhereInput | CourseWhereInput[]
    OR?: CourseWhereInput[]
    NOT?: CourseWhereInput | CourseWhereInput[]
    id?: IntFilter<"Course"> | number
    course_name?: StringFilter<"Course"> | string
    status?: EnumStatusFilter<"Course"> | $Enums.Status
    tag?: StringNullableListFilter<"Course">
    category_id?: IntFilter<"Course"> | number
    createdAt?: DateTimeFilter<"Course"> | Date | string
    modifiedAt?: DateTimeNullableFilter<"Course"> | Date | string | null
    category?: XOR<CategoryScalarRelationFilter, CategoryWhereInput>
    qnModels?: QnModelSetListRelationFilter
    selectedBy?: UserSelectedCourseListRelationFilter
  }

  export type CourseOrderByWithRelationInput = {
    id?: SortOrder
    course_name?: SortOrder
    status?: SortOrder
    tag?: SortOrder
    category_id?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrderInput | SortOrder
    category?: CategoryOrderByWithRelationInput
    qnModels?: qnModelSetOrderByRelationAggregateInput
    selectedBy?: userSelectedCourseOrderByRelationAggregateInput
  }

  export type CourseWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    AND?: CourseWhereInput | CourseWhereInput[]
    OR?: CourseWhereInput[]
    NOT?: CourseWhereInput | CourseWhereInput[]
    course_name?: StringFilter<"Course"> | string
    status?: EnumStatusFilter<"Course"> | $Enums.Status
    tag?: StringNullableListFilter<"Course">
    category_id?: IntFilter<"Course"> | number
    createdAt?: DateTimeFilter<"Course"> | Date | string
    modifiedAt?: DateTimeNullableFilter<"Course"> | Date | string | null
    category?: XOR<CategoryScalarRelationFilter, CategoryWhereInput>
    qnModels?: QnModelSetListRelationFilter
    selectedBy?: UserSelectedCourseListRelationFilter
  }, "id">

  export type CourseOrderByWithAggregationInput = {
    id?: SortOrder
    course_name?: SortOrder
    status?: SortOrder
    tag?: SortOrder
    category_id?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrderInput | SortOrder
    _count?: CourseCountOrderByAggregateInput
    _avg?: CourseAvgOrderByAggregateInput
    _max?: CourseMaxOrderByAggregateInput
    _min?: CourseMinOrderByAggregateInput
    _sum?: CourseSumOrderByAggregateInput
  }

  export type CourseScalarWhereWithAggregatesInput = {
    AND?: CourseScalarWhereWithAggregatesInput | CourseScalarWhereWithAggregatesInput[]
    OR?: CourseScalarWhereWithAggregatesInput[]
    NOT?: CourseScalarWhereWithAggregatesInput | CourseScalarWhereWithAggregatesInput[]
    id?: IntWithAggregatesFilter<"Course"> | number
    course_name?: StringWithAggregatesFilter<"Course"> | string
    status?: EnumStatusWithAggregatesFilter<"Course"> | $Enums.Status
    tag?: StringNullableListFilter<"Course">
    category_id?: IntWithAggregatesFilter<"Course"> | number
    createdAt?: DateTimeWithAggregatesFilter<"Course"> | Date | string
    modifiedAt?: DateTimeNullableWithAggregatesFilter<"Course"> | Date | string | null
  }

  export type qnModelSetWhereInput = {
    AND?: qnModelSetWhereInput | qnModelSetWhereInput[]
    OR?: qnModelSetWhereInput[]
    NOT?: qnModelSetWhereInput | qnModelSetWhereInput[]
    id?: IntFilter<"qnModelSet"> | number
    qn_title?: StringFilter<"qnModelSet"> | string
    modelset_info?: JsonFilter<"qnModelSet">
    qn_set?: JsonFilter<"qnModelSet">
    exam_time?: StringFilter<"qnModelSet"> | string
    status?: EnumStatusFilter<"qnModelSet"> | $Enums.Status
    tag?: StringNullableListFilter<"qnModelSet">
    createBy?: StringFilter<"qnModelSet"> | string
    course_id?: IntFilter<"qnModelSet"> | number
    createdAt?: DateTimeFilter<"qnModelSet"> | Date | string
    modifiedAt?: DateTimeNullableFilter<"qnModelSet"> | Date | string | null
    course?: XOR<CourseScalarRelationFilter, CourseWhereInput>
    givenExams?: UserGivenExamSetListRelationFilter
  }

  export type qnModelSetOrderByWithRelationInput = {
    id?: SortOrder
    qn_title?: SortOrder
    modelset_info?: SortOrder
    qn_set?: SortOrder
    exam_time?: SortOrder
    status?: SortOrder
    tag?: SortOrder
    createBy?: SortOrder
    course_id?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrderInput | SortOrder
    course?: CourseOrderByWithRelationInput
    givenExams?: userGivenExamSetOrderByRelationAggregateInput
  }

  export type qnModelSetWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    AND?: qnModelSetWhereInput | qnModelSetWhereInput[]
    OR?: qnModelSetWhereInput[]
    NOT?: qnModelSetWhereInput | qnModelSetWhereInput[]
    qn_title?: StringFilter<"qnModelSet"> | string
    modelset_info?: JsonFilter<"qnModelSet">
    qn_set?: JsonFilter<"qnModelSet">
    exam_time?: StringFilter<"qnModelSet"> | string
    status?: EnumStatusFilter<"qnModelSet"> | $Enums.Status
    tag?: StringNullableListFilter<"qnModelSet">
    createBy?: StringFilter<"qnModelSet"> | string
    course_id?: IntFilter<"qnModelSet"> | number
    createdAt?: DateTimeFilter<"qnModelSet"> | Date | string
    modifiedAt?: DateTimeNullableFilter<"qnModelSet"> | Date | string | null
    course?: XOR<CourseScalarRelationFilter, CourseWhereInput>
    givenExams?: UserGivenExamSetListRelationFilter
  }, "id">

  export type qnModelSetOrderByWithAggregationInput = {
    id?: SortOrder
    qn_title?: SortOrder
    modelset_info?: SortOrder
    qn_set?: SortOrder
    exam_time?: SortOrder
    status?: SortOrder
    tag?: SortOrder
    createBy?: SortOrder
    course_id?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrderInput | SortOrder
    _count?: qnModelSetCountOrderByAggregateInput
    _avg?: qnModelSetAvgOrderByAggregateInput
    _max?: qnModelSetMaxOrderByAggregateInput
    _min?: qnModelSetMinOrderByAggregateInput
    _sum?: qnModelSetSumOrderByAggregateInput
  }

  export type qnModelSetScalarWhereWithAggregatesInput = {
    AND?: qnModelSetScalarWhereWithAggregatesInput | qnModelSetScalarWhereWithAggregatesInput[]
    OR?: qnModelSetScalarWhereWithAggregatesInput[]
    NOT?: qnModelSetScalarWhereWithAggregatesInput | qnModelSetScalarWhereWithAggregatesInput[]
    id?: IntWithAggregatesFilter<"qnModelSet"> | number
    qn_title?: StringWithAggregatesFilter<"qnModelSet"> | string
    modelset_info?: JsonWithAggregatesFilter<"qnModelSet">
    qn_set?: JsonWithAggregatesFilter<"qnModelSet">
    exam_time?: StringWithAggregatesFilter<"qnModelSet"> | string
    status?: EnumStatusWithAggregatesFilter<"qnModelSet"> | $Enums.Status
    tag?: StringNullableListFilter<"qnModelSet">
    createBy?: StringWithAggregatesFilter<"qnModelSet"> | string
    course_id?: IntWithAggregatesFilter<"qnModelSet"> | number
    createdAt?: DateTimeWithAggregatesFilter<"qnModelSet"> | Date | string
    modifiedAt?: DateTimeNullableWithAggregatesFilter<"qnModelSet"> | Date | string | null
  }

  export type userGivenExamSetWhereInput = {
    AND?: userGivenExamSetWhereInput | userGivenExamSetWhereInput[]
    OR?: userGivenExamSetWhereInput[]
    NOT?: userGivenExamSetWhereInput | userGivenExamSetWhereInput[]
    id?: IntFilter<"userGivenExamSet"> | number
    user_id?: IntFilter<"userGivenExamSet"> | number
    qn_set_id?: IntFilter<"userGivenExamSet"> | number
    qn_ans?: JsonFilter<"userGivenExamSet">
    qn_title?: StringFilter<"userGivenExamSet"> | string
    obtainedMarks?: StringFilter<"userGivenExamSet"> | string
    examtimeTaken?: StringFilter<"userGivenExamSet"> | string
    status?: EnumStatusFilter<"userGivenExamSet"> | $Enums.Status
    createdAt?: DateTimeFilter<"userGivenExamSet"> | Date | string
    modifiedAt?: DateTimeNullableFilter<"userGivenExamSet"> | Date | string | null
    user?: XOR<UserScalarRelationFilter, UserWhereInput>
    qnModelSet?: XOR<QnModelSetScalarRelationFilter, qnModelSetWhereInput>
  }

  export type userGivenExamSetOrderByWithRelationInput = {
    id?: SortOrder
    user_id?: SortOrder
    qn_set_id?: SortOrder
    qn_ans?: SortOrder
    qn_title?: SortOrder
    obtainedMarks?: SortOrder
    examtimeTaken?: SortOrder
    status?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrderInput | SortOrder
    user?: UserOrderByWithRelationInput
    qnModelSet?: qnModelSetOrderByWithRelationInput
  }

  export type userGivenExamSetWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    AND?: userGivenExamSetWhereInput | userGivenExamSetWhereInput[]
    OR?: userGivenExamSetWhereInput[]
    NOT?: userGivenExamSetWhereInput | userGivenExamSetWhereInput[]
    user_id?: IntFilter<"userGivenExamSet"> | number
    qn_set_id?: IntFilter<"userGivenExamSet"> | number
    qn_ans?: JsonFilter<"userGivenExamSet">
    qn_title?: StringFilter<"userGivenExamSet"> | string
    obtainedMarks?: StringFilter<"userGivenExamSet"> | string
    examtimeTaken?: StringFilter<"userGivenExamSet"> | string
    status?: EnumStatusFilter<"userGivenExamSet"> | $Enums.Status
    createdAt?: DateTimeFilter<"userGivenExamSet"> | Date | string
    modifiedAt?: DateTimeNullableFilter<"userGivenExamSet"> | Date | string | null
    user?: XOR<UserScalarRelationFilter, UserWhereInput>
    qnModelSet?: XOR<QnModelSetScalarRelationFilter, qnModelSetWhereInput>
  }, "id">

  export type userGivenExamSetOrderByWithAggregationInput = {
    id?: SortOrder
    user_id?: SortOrder
    qn_set_id?: SortOrder
    qn_ans?: SortOrder
    qn_title?: SortOrder
    obtainedMarks?: SortOrder
    examtimeTaken?: SortOrder
    status?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrderInput | SortOrder
    _count?: userGivenExamSetCountOrderByAggregateInput
    _avg?: userGivenExamSetAvgOrderByAggregateInput
    _max?: userGivenExamSetMaxOrderByAggregateInput
    _min?: userGivenExamSetMinOrderByAggregateInput
    _sum?: userGivenExamSetSumOrderByAggregateInput
  }

  export type userGivenExamSetScalarWhereWithAggregatesInput = {
    AND?: userGivenExamSetScalarWhereWithAggregatesInput | userGivenExamSetScalarWhereWithAggregatesInput[]
    OR?: userGivenExamSetScalarWhereWithAggregatesInput[]
    NOT?: userGivenExamSetScalarWhereWithAggregatesInput | userGivenExamSetScalarWhereWithAggregatesInput[]
    id?: IntWithAggregatesFilter<"userGivenExamSet"> | number
    user_id?: IntWithAggregatesFilter<"userGivenExamSet"> | number
    qn_set_id?: IntWithAggregatesFilter<"userGivenExamSet"> | number
    qn_ans?: JsonWithAggregatesFilter<"userGivenExamSet">
    qn_title?: StringWithAggregatesFilter<"userGivenExamSet"> | string
    obtainedMarks?: StringWithAggregatesFilter<"userGivenExamSet"> | string
    examtimeTaken?: StringWithAggregatesFilter<"userGivenExamSet"> | string
    status?: EnumStatusWithAggregatesFilter<"userGivenExamSet"> | $Enums.Status
    createdAt?: DateTimeWithAggregatesFilter<"userGivenExamSet"> | Date | string
    modifiedAt?: DateTimeNullableWithAggregatesFilter<"userGivenExamSet"> | Date | string | null
  }

  export type userSelectedCourseWhereInput = {
    AND?: userSelectedCourseWhereInput | userSelectedCourseWhereInput[]
    OR?: userSelectedCourseWhereInput[]
    NOT?: userSelectedCourseWhereInput | userSelectedCourseWhereInput[]
    id?: IntFilter<"userSelectedCourse"> | number
    user_id?: IntFilter<"userSelectedCourse"> | number
    course_id?: IntFilter<"userSelectedCourse"> | number
    createdAt?: DateTimeFilter<"userSelectedCourse"> | Date | string
    modifiedAt?: DateTimeNullableFilter<"userSelectedCourse"> | Date | string | null
    user?: XOR<UserScalarRelationFilter, UserWhereInput>
    course?: XOR<CourseScalarRelationFilter, CourseWhereInput>
  }

  export type userSelectedCourseOrderByWithRelationInput = {
    id?: SortOrder
    user_id?: SortOrder
    course_id?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrderInput | SortOrder
    user?: UserOrderByWithRelationInput
    course?: CourseOrderByWithRelationInput
  }

  export type userSelectedCourseWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    AND?: userSelectedCourseWhereInput | userSelectedCourseWhereInput[]
    OR?: userSelectedCourseWhereInput[]
    NOT?: userSelectedCourseWhereInput | userSelectedCourseWhereInput[]
    user_id?: IntFilter<"userSelectedCourse"> | number
    course_id?: IntFilter<"userSelectedCourse"> | number
    createdAt?: DateTimeFilter<"userSelectedCourse"> | Date | string
    modifiedAt?: DateTimeNullableFilter<"userSelectedCourse"> | Date | string | null
    user?: XOR<UserScalarRelationFilter, UserWhereInput>
    course?: XOR<CourseScalarRelationFilter, CourseWhereInput>
  }, "id">

  export type userSelectedCourseOrderByWithAggregationInput = {
    id?: SortOrder
    user_id?: SortOrder
    course_id?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrderInput | SortOrder
    _count?: userSelectedCourseCountOrderByAggregateInput
    _avg?: userSelectedCourseAvgOrderByAggregateInput
    _max?: userSelectedCourseMaxOrderByAggregateInput
    _min?: userSelectedCourseMinOrderByAggregateInput
    _sum?: userSelectedCourseSumOrderByAggregateInput
  }

  export type userSelectedCourseScalarWhereWithAggregatesInput = {
    AND?: userSelectedCourseScalarWhereWithAggregatesInput | userSelectedCourseScalarWhereWithAggregatesInput[]
    OR?: userSelectedCourseScalarWhereWithAggregatesInput[]
    NOT?: userSelectedCourseScalarWhereWithAggregatesInput | userSelectedCourseScalarWhereWithAggregatesInput[]
    id?: IntWithAggregatesFilter<"userSelectedCourse"> | number
    user_id?: IntWithAggregatesFilter<"userSelectedCourse"> | number
    course_id?: IntWithAggregatesFilter<"userSelectedCourse"> | number
    createdAt?: DateTimeWithAggregatesFilter<"userSelectedCourse"> | Date | string
    modifiedAt?: DateTimeNullableWithAggregatesFilter<"userSelectedCourse"> | Date | string | null
  }

  export type UserCreateInput = {
    name: string
    email: string
    status?: $Enums.Role
    password: string
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    examSets?: userGivenExamSetCreateNestedManyWithoutUserInput
    selectedCourses?: userSelectedCourseCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateInput = {
    id?: number
    name: string
    email: string
    status?: $Enums.Role
    password: string
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    examSets?: userGivenExamSetUncheckedCreateNestedManyWithoutUserInput
    selectedCourses?: userSelectedCourseUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserUpdateInput = {
    name?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    status?: EnumRoleFieldUpdateOperationsInput | $Enums.Role
    password?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    examSets?: userGivenExamSetUpdateManyWithoutUserNestedInput
    selectedCourses?: userSelectedCourseUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateInput = {
    id?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    status?: EnumRoleFieldUpdateOperationsInput | $Enums.Role
    password?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    examSets?: userGivenExamSetUncheckedUpdateManyWithoutUserNestedInput
    selectedCourses?: userSelectedCourseUncheckedUpdateManyWithoutUserNestedInput
  }

  export type UserCreateManyInput = {
    id?: number
    name: string
    email: string
    status?: $Enums.Role
    password: string
    createdAt?: Date | string
    modifiedAt?: Date | string | null
  }

  export type UserUpdateManyMutationInput = {
    name?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    status?: EnumRoleFieldUpdateOperationsInput | $Enums.Role
    password?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type UserUncheckedUpdateManyInput = {
    id?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    status?: EnumRoleFieldUpdateOperationsInput | $Enums.Role
    password?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type CategoryCreateInput = {
    category_name: string
    status?: $Enums.Status
    tag?: CategoryCreatetagInput | string[]
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    courses?: CourseCreateNestedManyWithoutCategoryInput
  }

  export type CategoryUncheckedCreateInput = {
    id?: number
    category_name: string
    status?: $Enums.Status
    tag?: CategoryCreatetagInput | string[]
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    courses?: CourseUncheckedCreateNestedManyWithoutCategoryInput
  }

  export type CategoryUpdateInput = {
    category_name?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: CategoryUpdatetagInput | string[]
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    courses?: CourseUpdateManyWithoutCategoryNestedInput
  }

  export type CategoryUncheckedUpdateInput = {
    id?: IntFieldUpdateOperationsInput | number
    category_name?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: CategoryUpdatetagInput | string[]
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    courses?: CourseUncheckedUpdateManyWithoutCategoryNestedInput
  }

  export type CategoryCreateManyInput = {
    id?: number
    category_name: string
    status?: $Enums.Status
    tag?: CategoryCreatetagInput | string[]
    createdAt?: Date | string
    modifiedAt?: Date | string | null
  }

  export type CategoryUpdateManyMutationInput = {
    category_name?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: CategoryUpdatetagInput | string[]
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type CategoryUncheckedUpdateManyInput = {
    id?: IntFieldUpdateOperationsInput | number
    category_name?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: CategoryUpdatetagInput | string[]
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type CourseCreateInput = {
    course_name: string
    status?: $Enums.Status
    tag?: CourseCreatetagInput | string[]
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    category: CategoryCreateNestedOneWithoutCoursesInput
    qnModels?: qnModelSetCreateNestedManyWithoutCourseInput
    selectedBy?: userSelectedCourseCreateNestedManyWithoutCourseInput
  }

  export type CourseUncheckedCreateInput = {
    id?: number
    course_name: string
    status?: $Enums.Status
    tag?: CourseCreatetagInput | string[]
    category_id: number
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    qnModels?: qnModelSetUncheckedCreateNestedManyWithoutCourseInput
    selectedBy?: userSelectedCourseUncheckedCreateNestedManyWithoutCourseInput
  }

  export type CourseUpdateInput = {
    course_name?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: CourseUpdatetagInput | string[]
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    category?: CategoryUpdateOneRequiredWithoutCoursesNestedInput
    qnModels?: qnModelSetUpdateManyWithoutCourseNestedInput
    selectedBy?: userSelectedCourseUpdateManyWithoutCourseNestedInput
  }

  export type CourseUncheckedUpdateInput = {
    id?: IntFieldUpdateOperationsInput | number
    course_name?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: CourseUpdatetagInput | string[]
    category_id?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    qnModels?: qnModelSetUncheckedUpdateManyWithoutCourseNestedInput
    selectedBy?: userSelectedCourseUncheckedUpdateManyWithoutCourseNestedInput
  }

  export type CourseCreateManyInput = {
    id?: number
    course_name: string
    status?: $Enums.Status
    tag?: CourseCreatetagInput | string[]
    category_id: number
    createdAt?: Date | string
    modifiedAt?: Date | string | null
  }

  export type CourseUpdateManyMutationInput = {
    course_name?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: CourseUpdatetagInput | string[]
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type CourseUncheckedUpdateManyInput = {
    id?: IntFieldUpdateOperationsInput | number
    course_name?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: CourseUpdatetagInput | string[]
    category_id?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type qnModelSetCreateInput = {
    qn_title: string
    modelset_info: JsonNullValueInput | InputJsonValue
    qn_set: JsonNullValueInput | InputJsonValue
    exam_time: string
    status?: $Enums.Status
    tag?: qnModelSetCreatetagInput | string[]
    createBy: string
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    course: CourseCreateNestedOneWithoutQnModelsInput
    givenExams?: userGivenExamSetCreateNestedManyWithoutQnModelSetInput
  }

  export type qnModelSetUncheckedCreateInput = {
    id?: number
    qn_title: string
    modelset_info: JsonNullValueInput | InputJsonValue
    qn_set: JsonNullValueInput | InputJsonValue
    exam_time: string
    status?: $Enums.Status
    tag?: qnModelSetCreatetagInput | string[]
    createBy: string
    course_id: number
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    givenExams?: userGivenExamSetUncheckedCreateNestedManyWithoutQnModelSetInput
  }

  export type qnModelSetUpdateInput = {
    qn_title?: StringFieldUpdateOperationsInput | string
    modelset_info?: JsonNullValueInput | InputJsonValue
    qn_set?: JsonNullValueInput | InputJsonValue
    exam_time?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: qnModelSetUpdatetagInput | string[]
    createBy?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    course?: CourseUpdateOneRequiredWithoutQnModelsNestedInput
    givenExams?: userGivenExamSetUpdateManyWithoutQnModelSetNestedInput
  }

  export type qnModelSetUncheckedUpdateInput = {
    id?: IntFieldUpdateOperationsInput | number
    qn_title?: StringFieldUpdateOperationsInput | string
    modelset_info?: JsonNullValueInput | InputJsonValue
    qn_set?: JsonNullValueInput | InputJsonValue
    exam_time?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: qnModelSetUpdatetagInput | string[]
    createBy?: StringFieldUpdateOperationsInput | string
    course_id?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    givenExams?: userGivenExamSetUncheckedUpdateManyWithoutQnModelSetNestedInput
  }

  export type qnModelSetCreateManyInput = {
    id?: number
    qn_title: string
    modelset_info: JsonNullValueInput | InputJsonValue
    qn_set: JsonNullValueInput | InputJsonValue
    exam_time: string
    status?: $Enums.Status
    tag?: qnModelSetCreatetagInput | string[]
    createBy: string
    course_id: number
    createdAt?: Date | string
    modifiedAt?: Date | string | null
  }

  export type qnModelSetUpdateManyMutationInput = {
    qn_title?: StringFieldUpdateOperationsInput | string
    modelset_info?: JsonNullValueInput | InputJsonValue
    qn_set?: JsonNullValueInput | InputJsonValue
    exam_time?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: qnModelSetUpdatetagInput | string[]
    createBy?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type qnModelSetUncheckedUpdateManyInput = {
    id?: IntFieldUpdateOperationsInput | number
    qn_title?: StringFieldUpdateOperationsInput | string
    modelset_info?: JsonNullValueInput | InputJsonValue
    qn_set?: JsonNullValueInput | InputJsonValue
    exam_time?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: qnModelSetUpdatetagInput | string[]
    createBy?: StringFieldUpdateOperationsInput | string
    course_id?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type userGivenExamSetCreateInput = {
    qn_ans: JsonNullValueInput | InputJsonValue
    qn_title: string
    obtainedMarks: string
    examtimeTaken: string
    status?: $Enums.Status
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    user: UserCreateNestedOneWithoutExamSetsInput
    qnModelSet: qnModelSetCreateNestedOneWithoutGivenExamsInput
  }

  export type userGivenExamSetUncheckedCreateInput = {
    id?: number
    user_id: number
    qn_set_id: number
    qn_ans: JsonNullValueInput | InputJsonValue
    qn_title: string
    obtainedMarks: string
    examtimeTaken: string
    status?: $Enums.Status
    createdAt?: Date | string
    modifiedAt?: Date | string | null
  }

  export type userGivenExamSetUpdateInput = {
    qn_ans?: JsonNullValueInput | InputJsonValue
    qn_title?: StringFieldUpdateOperationsInput | string
    obtainedMarks?: StringFieldUpdateOperationsInput | string
    examtimeTaken?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    user?: UserUpdateOneRequiredWithoutExamSetsNestedInput
    qnModelSet?: qnModelSetUpdateOneRequiredWithoutGivenExamsNestedInput
  }

  export type userGivenExamSetUncheckedUpdateInput = {
    id?: IntFieldUpdateOperationsInput | number
    user_id?: IntFieldUpdateOperationsInput | number
    qn_set_id?: IntFieldUpdateOperationsInput | number
    qn_ans?: JsonNullValueInput | InputJsonValue
    qn_title?: StringFieldUpdateOperationsInput | string
    obtainedMarks?: StringFieldUpdateOperationsInput | string
    examtimeTaken?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type userGivenExamSetCreateManyInput = {
    id?: number
    user_id: number
    qn_set_id: number
    qn_ans: JsonNullValueInput | InputJsonValue
    qn_title: string
    obtainedMarks: string
    examtimeTaken: string
    status?: $Enums.Status
    createdAt?: Date | string
    modifiedAt?: Date | string | null
  }

  export type userGivenExamSetUpdateManyMutationInput = {
    qn_ans?: JsonNullValueInput | InputJsonValue
    qn_title?: StringFieldUpdateOperationsInput | string
    obtainedMarks?: StringFieldUpdateOperationsInput | string
    examtimeTaken?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type userGivenExamSetUncheckedUpdateManyInput = {
    id?: IntFieldUpdateOperationsInput | number
    user_id?: IntFieldUpdateOperationsInput | number
    qn_set_id?: IntFieldUpdateOperationsInput | number
    qn_ans?: JsonNullValueInput | InputJsonValue
    qn_title?: StringFieldUpdateOperationsInput | string
    obtainedMarks?: StringFieldUpdateOperationsInput | string
    examtimeTaken?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type userSelectedCourseCreateInput = {
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    user: UserCreateNestedOneWithoutSelectedCoursesInput
    course: CourseCreateNestedOneWithoutSelectedByInput
  }

  export type userSelectedCourseUncheckedCreateInput = {
    id?: number
    user_id: number
    course_id: number
    createdAt?: Date | string
    modifiedAt?: Date | string | null
  }

  export type userSelectedCourseUpdateInput = {
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    user?: UserUpdateOneRequiredWithoutSelectedCoursesNestedInput
    course?: CourseUpdateOneRequiredWithoutSelectedByNestedInput
  }

  export type userSelectedCourseUncheckedUpdateInput = {
    id?: IntFieldUpdateOperationsInput | number
    user_id?: IntFieldUpdateOperationsInput | number
    course_id?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type userSelectedCourseCreateManyInput = {
    id?: number
    user_id: number
    course_id: number
    createdAt?: Date | string
    modifiedAt?: Date | string | null
  }

  export type userSelectedCourseUpdateManyMutationInput = {
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type userSelectedCourseUncheckedUpdateManyInput = {
    id?: IntFieldUpdateOperationsInput | number
    user_id?: IntFieldUpdateOperationsInput | number
    course_id?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type IntFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[] | ListIntFieldRefInput<$PrismaModel>
    notIn?: number[] | ListIntFieldRefInput<$PrismaModel>
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntFilter<$PrismaModel> | number
  }

  export type StringFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[] | ListStringFieldRefInput<$PrismaModel>
    notIn?: string[] | ListStringFieldRefInput<$PrismaModel>
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    mode?: QueryMode
    not?: NestedStringFilter<$PrismaModel> | string
  }

  export type EnumRoleFilter<$PrismaModel = never> = {
    equals?: $Enums.Role | EnumRoleFieldRefInput<$PrismaModel>
    in?: $Enums.Role[] | ListEnumRoleFieldRefInput<$PrismaModel>
    notIn?: $Enums.Role[] | ListEnumRoleFieldRefInput<$PrismaModel>
    not?: NestedEnumRoleFilter<$PrismaModel> | $Enums.Role
  }

  export type DateTimeFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeFilter<$PrismaModel> | Date | string
  }

  export type DateTimeNullableFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel> | null
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeNullableFilter<$PrismaModel> | Date | string | null
  }

  export type UserGivenExamSetListRelationFilter = {
    every?: userGivenExamSetWhereInput
    some?: userGivenExamSetWhereInput
    none?: userGivenExamSetWhereInput
  }

  export type UserSelectedCourseListRelationFilter = {
    every?: userSelectedCourseWhereInput
    some?: userSelectedCourseWhereInput
    none?: userSelectedCourseWhereInput
  }

  export type SortOrderInput = {
    sort: SortOrder
    nulls?: NullsOrder
  }

  export type userGivenExamSetOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type userSelectedCourseOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type UserCountOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    email?: SortOrder
    status?: SortOrder
    password?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrder
  }

  export type UserAvgOrderByAggregateInput = {
    id?: SortOrder
  }

  export type UserMaxOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    email?: SortOrder
    status?: SortOrder
    password?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrder
  }

  export type UserMinOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    email?: SortOrder
    status?: SortOrder
    password?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrder
  }

  export type UserSumOrderByAggregateInput = {
    id?: SortOrder
  }

  export type IntWithAggregatesFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[] | ListIntFieldRefInput<$PrismaModel>
    notIn?: number[] | ListIntFieldRefInput<$PrismaModel>
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntWithAggregatesFilter<$PrismaModel> | number
    _count?: NestedIntFilter<$PrismaModel>
    _avg?: NestedFloatFilter<$PrismaModel>
    _sum?: NestedIntFilter<$PrismaModel>
    _min?: NestedIntFilter<$PrismaModel>
    _max?: NestedIntFilter<$PrismaModel>
  }

  export type StringWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[] | ListStringFieldRefInput<$PrismaModel>
    notIn?: string[] | ListStringFieldRefInput<$PrismaModel>
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    mode?: QueryMode
    not?: NestedStringWithAggregatesFilter<$PrismaModel> | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedStringFilter<$PrismaModel>
    _max?: NestedStringFilter<$PrismaModel>
  }

  export type EnumRoleWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.Role | EnumRoleFieldRefInput<$PrismaModel>
    in?: $Enums.Role[] | ListEnumRoleFieldRefInput<$PrismaModel>
    notIn?: $Enums.Role[] | ListEnumRoleFieldRefInput<$PrismaModel>
    not?: NestedEnumRoleWithAggregatesFilter<$PrismaModel> | $Enums.Role
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedEnumRoleFilter<$PrismaModel>
    _max?: NestedEnumRoleFilter<$PrismaModel>
  }

  export type DateTimeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeWithAggregatesFilter<$PrismaModel> | Date | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedDateTimeFilter<$PrismaModel>
    _max?: NestedDateTimeFilter<$PrismaModel>
  }

  export type DateTimeNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel> | null
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeNullableWithAggregatesFilter<$PrismaModel> | Date | string | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedDateTimeNullableFilter<$PrismaModel>
    _max?: NestedDateTimeNullableFilter<$PrismaModel>
  }

  export type EnumStatusFilter<$PrismaModel = never> = {
    equals?: $Enums.Status | EnumStatusFieldRefInput<$PrismaModel>
    in?: $Enums.Status[] | ListEnumStatusFieldRefInput<$PrismaModel>
    notIn?: $Enums.Status[] | ListEnumStatusFieldRefInput<$PrismaModel>
    not?: NestedEnumStatusFilter<$PrismaModel> | $Enums.Status
  }

  export type StringNullableListFilter<$PrismaModel = never> = {
    equals?: string[] | ListStringFieldRefInput<$PrismaModel> | null
    has?: string | StringFieldRefInput<$PrismaModel> | null
    hasEvery?: string[] | ListStringFieldRefInput<$PrismaModel>
    hasSome?: string[] | ListStringFieldRefInput<$PrismaModel>
    isEmpty?: boolean
  }

  export type CourseListRelationFilter = {
    every?: CourseWhereInput
    some?: CourseWhereInput
    none?: CourseWhereInput
  }

  export type CourseOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type CategoryCountOrderByAggregateInput = {
    id?: SortOrder
    category_name?: SortOrder
    status?: SortOrder
    tag?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrder
  }

  export type CategoryAvgOrderByAggregateInput = {
    id?: SortOrder
  }

  export type CategoryMaxOrderByAggregateInput = {
    id?: SortOrder
    category_name?: SortOrder
    status?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrder
  }

  export type CategoryMinOrderByAggregateInput = {
    id?: SortOrder
    category_name?: SortOrder
    status?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrder
  }

  export type CategorySumOrderByAggregateInput = {
    id?: SortOrder
  }

  export type EnumStatusWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.Status | EnumStatusFieldRefInput<$PrismaModel>
    in?: $Enums.Status[] | ListEnumStatusFieldRefInput<$PrismaModel>
    notIn?: $Enums.Status[] | ListEnumStatusFieldRefInput<$PrismaModel>
    not?: NestedEnumStatusWithAggregatesFilter<$PrismaModel> | $Enums.Status
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedEnumStatusFilter<$PrismaModel>
    _max?: NestedEnumStatusFilter<$PrismaModel>
  }

  export type CategoryScalarRelationFilter = {
    is?: CategoryWhereInput
    isNot?: CategoryWhereInput
  }

  export type QnModelSetListRelationFilter = {
    every?: qnModelSetWhereInput
    some?: qnModelSetWhereInput
    none?: qnModelSetWhereInput
  }

  export type qnModelSetOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type CourseCountOrderByAggregateInput = {
    id?: SortOrder
    course_name?: SortOrder
    status?: SortOrder
    tag?: SortOrder
    category_id?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrder
  }

  export type CourseAvgOrderByAggregateInput = {
    id?: SortOrder
    category_id?: SortOrder
  }

  export type CourseMaxOrderByAggregateInput = {
    id?: SortOrder
    course_name?: SortOrder
    status?: SortOrder
    category_id?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrder
  }

  export type CourseMinOrderByAggregateInput = {
    id?: SortOrder
    course_name?: SortOrder
    status?: SortOrder
    category_id?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrder
  }

  export type CourseSumOrderByAggregateInput = {
    id?: SortOrder
    category_id?: SortOrder
  }
  export type JsonFilter<$PrismaModel = never> =
    | PatchUndefined<
        Either<Required<JsonFilterBase<$PrismaModel>>, Exclude<keyof Required<JsonFilterBase<$PrismaModel>>, 'path'>>,
        Required<JsonFilterBase<$PrismaModel>>
      >
    | OptionalFlat<Omit<Required<JsonFilterBase<$PrismaModel>>, 'path'>>

  export type JsonFilterBase<$PrismaModel = never> = {
    equals?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | JsonNullValueFilter
    path?: string[]
    mode?: QueryMode | EnumQueryModeFieldRefInput<$PrismaModel>
    string_contains?: string | StringFieldRefInput<$PrismaModel>
    string_starts_with?: string | StringFieldRefInput<$PrismaModel>
    string_ends_with?: string | StringFieldRefInput<$PrismaModel>
    array_starts_with?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    array_ends_with?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    array_contains?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    lt?: InputJsonValue | JsonFieldRefInput<$PrismaModel>
    lte?: InputJsonValue | JsonFieldRefInput<$PrismaModel>
    gt?: InputJsonValue | JsonFieldRefInput<$PrismaModel>
    gte?: InputJsonValue | JsonFieldRefInput<$PrismaModel>
    not?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | JsonNullValueFilter
  }

  export type CourseScalarRelationFilter = {
    is?: CourseWhereInput
    isNot?: CourseWhereInput
  }

  export type qnModelSetCountOrderByAggregateInput = {
    id?: SortOrder
    qn_title?: SortOrder
    modelset_info?: SortOrder
    qn_set?: SortOrder
    exam_time?: SortOrder
    status?: SortOrder
    tag?: SortOrder
    createBy?: SortOrder
    course_id?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrder
  }

  export type qnModelSetAvgOrderByAggregateInput = {
    id?: SortOrder
    course_id?: SortOrder
  }

  export type qnModelSetMaxOrderByAggregateInput = {
    id?: SortOrder
    qn_title?: SortOrder
    exam_time?: SortOrder
    status?: SortOrder
    createBy?: SortOrder
    course_id?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrder
  }

  export type qnModelSetMinOrderByAggregateInput = {
    id?: SortOrder
    qn_title?: SortOrder
    exam_time?: SortOrder
    status?: SortOrder
    createBy?: SortOrder
    course_id?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrder
  }

  export type qnModelSetSumOrderByAggregateInput = {
    id?: SortOrder
    course_id?: SortOrder
  }
  export type JsonWithAggregatesFilter<$PrismaModel = never> =
    | PatchUndefined<
        Either<Required<JsonWithAggregatesFilterBase<$PrismaModel>>, Exclude<keyof Required<JsonWithAggregatesFilterBase<$PrismaModel>>, 'path'>>,
        Required<JsonWithAggregatesFilterBase<$PrismaModel>>
      >
    | OptionalFlat<Omit<Required<JsonWithAggregatesFilterBase<$PrismaModel>>, 'path'>>

  export type JsonWithAggregatesFilterBase<$PrismaModel = never> = {
    equals?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | JsonNullValueFilter
    path?: string[]
    mode?: QueryMode | EnumQueryModeFieldRefInput<$PrismaModel>
    string_contains?: string | StringFieldRefInput<$PrismaModel>
    string_starts_with?: string | StringFieldRefInput<$PrismaModel>
    string_ends_with?: string | StringFieldRefInput<$PrismaModel>
    array_starts_with?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    array_ends_with?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    array_contains?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    lt?: InputJsonValue | JsonFieldRefInput<$PrismaModel>
    lte?: InputJsonValue | JsonFieldRefInput<$PrismaModel>
    gt?: InputJsonValue | JsonFieldRefInput<$PrismaModel>
    gte?: InputJsonValue | JsonFieldRefInput<$PrismaModel>
    not?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | JsonNullValueFilter
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedJsonFilter<$PrismaModel>
    _max?: NestedJsonFilter<$PrismaModel>
  }

  export type UserScalarRelationFilter = {
    is?: UserWhereInput
    isNot?: UserWhereInput
  }

  export type QnModelSetScalarRelationFilter = {
    is?: qnModelSetWhereInput
    isNot?: qnModelSetWhereInput
  }

  export type userGivenExamSetCountOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    qn_set_id?: SortOrder
    qn_ans?: SortOrder
    qn_title?: SortOrder
    obtainedMarks?: SortOrder
    examtimeTaken?: SortOrder
    status?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrder
  }

  export type userGivenExamSetAvgOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    qn_set_id?: SortOrder
  }

  export type userGivenExamSetMaxOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    qn_set_id?: SortOrder
    qn_title?: SortOrder
    obtainedMarks?: SortOrder
    examtimeTaken?: SortOrder
    status?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrder
  }

  export type userGivenExamSetMinOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    qn_set_id?: SortOrder
    qn_title?: SortOrder
    obtainedMarks?: SortOrder
    examtimeTaken?: SortOrder
    status?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrder
  }

  export type userGivenExamSetSumOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    qn_set_id?: SortOrder
  }

  export type userSelectedCourseCountOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    course_id?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrder
  }

  export type userSelectedCourseAvgOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    course_id?: SortOrder
  }

  export type userSelectedCourseMaxOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    course_id?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrder
  }

  export type userSelectedCourseMinOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    course_id?: SortOrder
    createdAt?: SortOrder
    modifiedAt?: SortOrder
  }

  export type userSelectedCourseSumOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    course_id?: SortOrder
  }

  export type userGivenExamSetCreateNestedManyWithoutUserInput = {
    create?: XOR<userGivenExamSetCreateWithoutUserInput, userGivenExamSetUncheckedCreateWithoutUserInput> | userGivenExamSetCreateWithoutUserInput[] | userGivenExamSetUncheckedCreateWithoutUserInput[]
    connectOrCreate?: userGivenExamSetCreateOrConnectWithoutUserInput | userGivenExamSetCreateOrConnectWithoutUserInput[]
    createMany?: userGivenExamSetCreateManyUserInputEnvelope
    connect?: userGivenExamSetWhereUniqueInput | userGivenExamSetWhereUniqueInput[]
  }

  export type userSelectedCourseCreateNestedManyWithoutUserInput = {
    create?: XOR<userSelectedCourseCreateWithoutUserInput, userSelectedCourseUncheckedCreateWithoutUserInput> | userSelectedCourseCreateWithoutUserInput[] | userSelectedCourseUncheckedCreateWithoutUserInput[]
    connectOrCreate?: userSelectedCourseCreateOrConnectWithoutUserInput | userSelectedCourseCreateOrConnectWithoutUserInput[]
    createMany?: userSelectedCourseCreateManyUserInputEnvelope
    connect?: userSelectedCourseWhereUniqueInput | userSelectedCourseWhereUniqueInput[]
  }

  export type userGivenExamSetUncheckedCreateNestedManyWithoutUserInput = {
    create?: XOR<userGivenExamSetCreateWithoutUserInput, userGivenExamSetUncheckedCreateWithoutUserInput> | userGivenExamSetCreateWithoutUserInput[] | userGivenExamSetUncheckedCreateWithoutUserInput[]
    connectOrCreate?: userGivenExamSetCreateOrConnectWithoutUserInput | userGivenExamSetCreateOrConnectWithoutUserInput[]
    createMany?: userGivenExamSetCreateManyUserInputEnvelope
    connect?: userGivenExamSetWhereUniqueInput | userGivenExamSetWhereUniqueInput[]
  }

  export type userSelectedCourseUncheckedCreateNestedManyWithoutUserInput = {
    create?: XOR<userSelectedCourseCreateWithoutUserInput, userSelectedCourseUncheckedCreateWithoutUserInput> | userSelectedCourseCreateWithoutUserInput[] | userSelectedCourseUncheckedCreateWithoutUserInput[]
    connectOrCreate?: userSelectedCourseCreateOrConnectWithoutUserInput | userSelectedCourseCreateOrConnectWithoutUserInput[]
    createMany?: userSelectedCourseCreateManyUserInputEnvelope
    connect?: userSelectedCourseWhereUniqueInput | userSelectedCourseWhereUniqueInput[]
  }

  export type StringFieldUpdateOperationsInput = {
    set?: string
  }

  export type EnumRoleFieldUpdateOperationsInput = {
    set?: $Enums.Role
  }

  export type DateTimeFieldUpdateOperationsInput = {
    set?: Date | string
  }

  export type NullableDateTimeFieldUpdateOperationsInput = {
    set?: Date | string | null
  }

  export type userGivenExamSetUpdateManyWithoutUserNestedInput = {
    create?: XOR<userGivenExamSetCreateWithoutUserInput, userGivenExamSetUncheckedCreateWithoutUserInput> | userGivenExamSetCreateWithoutUserInput[] | userGivenExamSetUncheckedCreateWithoutUserInput[]
    connectOrCreate?: userGivenExamSetCreateOrConnectWithoutUserInput | userGivenExamSetCreateOrConnectWithoutUserInput[]
    upsert?: userGivenExamSetUpsertWithWhereUniqueWithoutUserInput | userGivenExamSetUpsertWithWhereUniqueWithoutUserInput[]
    createMany?: userGivenExamSetCreateManyUserInputEnvelope
    set?: userGivenExamSetWhereUniqueInput | userGivenExamSetWhereUniqueInput[]
    disconnect?: userGivenExamSetWhereUniqueInput | userGivenExamSetWhereUniqueInput[]
    delete?: userGivenExamSetWhereUniqueInput | userGivenExamSetWhereUniqueInput[]
    connect?: userGivenExamSetWhereUniqueInput | userGivenExamSetWhereUniqueInput[]
    update?: userGivenExamSetUpdateWithWhereUniqueWithoutUserInput | userGivenExamSetUpdateWithWhereUniqueWithoutUserInput[]
    updateMany?: userGivenExamSetUpdateManyWithWhereWithoutUserInput | userGivenExamSetUpdateManyWithWhereWithoutUserInput[]
    deleteMany?: userGivenExamSetScalarWhereInput | userGivenExamSetScalarWhereInput[]
  }

  export type userSelectedCourseUpdateManyWithoutUserNestedInput = {
    create?: XOR<userSelectedCourseCreateWithoutUserInput, userSelectedCourseUncheckedCreateWithoutUserInput> | userSelectedCourseCreateWithoutUserInput[] | userSelectedCourseUncheckedCreateWithoutUserInput[]
    connectOrCreate?: userSelectedCourseCreateOrConnectWithoutUserInput | userSelectedCourseCreateOrConnectWithoutUserInput[]
    upsert?: userSelectedCourseUpsertWithWhereUniqueWithoutUserInput | userSelectedCourseUpsertWithWhereUniqueWithoutUserInput[]
    createMany?: userSelectedCourseCreateManyUserInputEnvelope
    set?: userSelectedCourseWhereUniqueInput | userSelectedCourseWhereUniqueInput[]
    disconnect?: userSelectedCourseWhereUniqueInput | userSelectedCourseWhereUniqueInput[]
    delete?: userSelectedCourseWhereUniqueInput | userSelectedCourseWhereUniqueInput[]
    connect?: userSelectedCourseWhereUniqueInput | userSelectedCourseWhereUniqueInput[]
    update?: userSelectedCourseUpdateWithWhereUniqueWithoutUserInput | userSelectedCourseUpdateWithWhereUniqueWithoutUserInput[]
    updateMany?: userSelectedCourseUpdateManyWithWhereWithoutUserInput | userSelectedCourseUpdateManyWithWhereWithoutUserInput[]
    deleteMany?: userSelectedCourseScalarWhereInput | userSelectedCourseScalarWhereInput[]
  }

  export type IntFieldUpdateOperationsInput = {
    set?: number
    increment?: number
    decrement?: number
    multiply?: number
    divide?: number
  }

  export type userGivenExamSetUncheckedUpdateManyWithoutUserNestedInput = {
    create?: XOR<userGivenExamSetCreateWithoutUserInput, userGivenExamSetUncheckedCreateWithoutUserInput> | userGivenExamSetCreateWithoutUserInput[] | userGivenExamSetUncheckedCreateWithoutUserInput[]
    connectOrCreate?: userGivenExamSetCreateOrConnectWithoutUserInput | userGivenExamSetCreateOrConnectWithoutUserInput[]
    upsert?: userGivenExamSetUpsertWithWhereUniqueWithoutUserInput | userGivenExamSetUpsertWithWhereUniqueWithoutUserInput[]
    createMany?: userGivenExamSetCreateManyUserInputEnvelope
    set?: userGivenExamSetWhereUniqueInput | userGivenExamSetWhereUniqueInput[]
    disconnect?: userGivenExamSetWhereUniqueInput | userGivenExamSetWhereUniqueInput[]
    delete?: userGivenExamSetWhereUniqueInput | userGivenExamSetWhereUniqueInput[]
    connect?: userGivenExamSetWhereUniqueInput | userGivenExamSetWhereUniqueInput[]
    update?: userGivenExamSetUpdateWithWhereUniqueWithoutUserInput | userGivenExamSetUpdateWithWhereUniqueWithoutUserInput[]
    updateMany?: userGivenExamSetUpdateManyWithWhereWithoutUserInput | userGivenExamSetUpdateManyWithWhereWithoutUserInput[]
    deleteMany?: userGivenExamSetScalarWhereInput | userGivenExamSetScalarWhereInput[]
  }

  export type userSelectedCourseUncheckedUpdateManyWithoutUserNestedInput = {
    create?: XOR<userSelectedCourseCreateWithoutUserInput, userSelectedCourseUncheckedCreateWithoutUserInput> | userSelectedCourseCreateWithoutUserInput[] | userSelectedCourseUncheckedCreateWithoutUserInput[]
    connectOrCreate?: userSelectedCourseCreateOrConnectWithoutUserInput | userSelectedCourseCreateOrConnectWithoutUserInput[]
    upsert?: userSelectedCourseUpsertWithWhereUniqueWithoutUserInput | userSelectedCourseUpsertWithWhereUniqueWithoutUserInput[]
    createMany?: userSelectedCourseCreateManyUserInputEnvelope
    set?: userSelectedCourseWhereUniqueInput | userSelectedCourseWhereUniqueInput[]
    disconnect?: userSelectedCourseWhereUniqueInput | userSelectedCourseWhereUniqueInput[]
    delete?: userSelectedCourseWhereUniqueInput | userSelectedCourseWhereUniqueInput[]
    connect?: userSelectedCourseWhereUniqueInput | userSelectedCourseWhereUniqueInput[]
    update?: userSelectedCourseUpdateWithWhereUniqueWithoutUserInput | userSelectedCourseUpdateWithWhereUniqueWithoutUserInput[]
    updateMany?: userSelectedCourseUpdateManyWithWhereWithoutUserInput | userSelectedCourseUpdateManyWithWhereWithoutUserInput[]
    deleteMany?: userSelectedCourseScalarWhereInput | userSelectedCourseScalarWhereInput[]
  }

  export type CategoryCreatetagInput = {
    set: string[]
  }

  export type CourseCreateNestedManyWithoutCategoryInput = {
    create?: XOR<CourseCreateWithoutCategoryInput, CourseUncheckedCreateWithoutCategoryInput> | CourseCreateWithoutCategoryInput[] | CourseUncheckedCreateWithoutCategoryInput[]
    connectOrCreate?: CourseCreateOrConnectWithoutCategoryInput | CourseCreateOrConnectWithoutCategoryInput[]
    createMany?: CourseCreateManyCategoryInputEnvelope
    connect?: CourseWhereUniqueInput | CourseWhereUniqueInput[]
  }

  export type CourseUncheckedCreateNestedManyWithoutCategoryInput = {
    create?: XOR<CourseCreateWithoutCategoryInput, CourseUncheckedCreateWithoutCategoryInput> | CourseCreateWithoutCategoryInput[] | CourseUncheckedCreateWithoutCategoryInput[]
    connectOrCreate?: CourseCreateOrConnectWithoutCategoryInput | CourseCreateOrConnectWithoutCategoryInput[]
    createMany?: CourseCreateManyCategoryInputEnvelope
    connect?: CourseWhereUniqueInput | CourseWhereUniqueInput[]
  }

  export type EnumStatusFieldUpdateOperationsInput = {
    set?: $Enums.Status
  }

  export type CategoryUpdatetagInput = {
    set?: string[]
    push?: string | string[]
  }

  export type CourseUpdateManyWithoutCategoryNestedInput = {
    create?: XOR<CourseCreateWithoutCategoryInput, CourseUncheckedCreateWithoutCategoryInput> | CourseCreateWithoutCategoryInput[] | CourseUncheckedCreateWithoutCategoryInput[]
    connectOrCreate?: CourseCreateOrConnectWithoutCategoryInput | CourseCreateOrConnectWithoutCategoryInput[]
    upsert?: CourseUpsertWithWhereUniqueWithoutCategoryInput | CourseUpsertWithWhereUniqueWithoutCategoryInput[]
    createMany?: CourseCreateManyCategoryInputEnvelope
    set?: CourseWhereUniqueInput | CourseWhereUniqueInput[]
    disconnect?: CourseWhereUniqueInput | CourseWhereUniqueInput[]
    delete?: CourseWhereUniqueInput | CourseWhereUniqueInput[]
    connect?: CourseWhereUniqueInput | CourseWhereUniqueInput[]
    update?: CourseUpdateWithWhereUniqueWithoutCategoryInput | CourseUpdateWithWhereUniqueWithoutCategoryInput[]
    updateMany?: CourseUpdateManyWithWhereWithoutCategoryInput | CourseUpdateManyWithWhereWithoutCategoryInput[]
    deleteMany?: CourseScalarWhereInput | CourseScalarWhereInput[]
  }

  export type CourseUncheckedUpdateManyWithoutCategoryNestedInput = {
    create?: XOR<CourseCreateWithoutCategoryInput, CourseUncheckedCreateWithoutCategoryInput> | CourseCreateWithoutCategoryInput[] | CourseUncheckedCreateWithoutCategoryInput[]
    connectOrCreate?: CourseCreateOrConnectWithoutCategoryInput | CourseCreateOrConnectWithoutCategoryInput[]
    upsert?: CourseUpsertWithWhereUniqueWithoutCategoryInput | CourseUpsertWithWhereUniqueWithoutCategoryInput[]
    createMany?: CourseCreateManyCategoryInputEnvelope
    set?: CourseWhereUniqueInput | CourseWhereUniqueInput[]
    disconnect?: CourseWhereUniqueInput | CourseWhereUniqueInput[]
    delete?: CourseWhereUniqueInput | CourseWhereUniqueInput[]
    connect?: CourseWhereUniqueInput | CourseWhereUniqueInput[]
    update?: CourseUpdateWithWhereUniqueWithoutCategoryInput | CourseUpdateWithWhereUniqueWithoutCategoryInput[]
    updateMany?: CourseUpdateManyWithWhereWithoutCategoryInput | CourseUpdateManyWithWhereWithoutCategoryInput[]
    deleteMany?: CourseScalarWhereInput | CourseScalarWhereInput[]
  }

  export type CourseCreatetagInput = {
    set: string[]
  }

  export type CategoryCreateNestedOneWithoutCoursesInput = {
    create?: XOR<CategoryCreateWithoutCoursesInput, CategoryUncheckedCreateWithoutCoursesInput>
    connectOrCreate?: CategoryCreateOrConnectWithoutCoursesInput
    connect?: CategoryWhereUniqueInput
  }

  export type qnModelSetCreateNestedManyWithoutCourseInput = {
    create?: XOR<qnModelSetCreateWithoutCourseInput, qnModelSetUncheckedCreateWithoutCourseInput> | qnModelSetCreateWithoutCourseInput[] | qnModelSetUncheckedCreateWithoutCourseInput[]
    connectOrCreate?: qnModelSetCreateOrConnectWithoutCourseInput | qnModelSetCreateOrConnectWithoutCourseInput[]
    createMany?: qnModelSetCreateManyCourseInputEnvelope
    connect?: qnModelSetWhereUniqueInput | qnModelSetWhereUniqueInput[]
  }

  export type userSelectedCourseCreateNestedManyWithoutCourseInput = {
    create?: XOR<userSelectedCourseCreateWithoutCourseInput, userSelectedCourseUncheckedCreateWithoutCourseInput> | userSelectedCourseCreateWithoutCourseInput[] | userSelectedCourseUncheckedCreateWithoutCourseInput[]
    connectOrCreate?: userSelectedCourseCreateOrConnectWithoutCourseInput | userSelectedCourseCreateOrConnectWithoutCourseInput[]
    createMany?: userSelectedCourseCreateManyCourseInputEnvelope
    connect?: userSelectedCourseWhereUniqueInput | userSelectedCourseWhereUniqueInput[]
  }

  export type qnModelSetUncheckedCreateNestedManyWithoutCourseInput = {
    create?: XOR<qnModelSetCreateWithoutCourseInput, qnModelSetUncheckedCreateWithoutCourseInput> | qnModelSetCreateWithoutCourseInput[] | qnModelSetUncheckedCreateWithoutCourseInput[]
    connectOrCreate?: qnModelSetCreateOrConnectWithoutCourseInput | qnModelSetCreateOrConnectWithoutCourseInput[]
    createMany?: qnModelSetCreateManyCourseInputEnvelope
    connect?: qnModelSetWhereUniqueInput | qnModelSetWhereUniqueInput[]
  }

  export type userSelectedCourseUncheckedCreateNestedManyWithoutCourseInput = {
    create?: XOR<userSelectedCourseCreateWithoutCourseInput, userSelectedCourseUncheckedCreateWithoutCourseInput> | userSelectedCourseCreateWithoutCourseInput[] | userSelectedCourseUncheckedCreateWithoutCourseInput[]
    connectOrCreate?: userSelectedCourseCreateOrConnectWithoutCourseInput | userSelectedCourseCreateOrConnectWithoutCourseInput[]
    createMany?: userSelectedCourseCreateManyCourseInputEnvelope
    connect?: userSelectedCourseWhereUniqueInput | userSelectedCourseWhereUniqueInput[]
  }

  export type CourseUpdatetagInput = {
    set?: string[]
    push?: string | string[]
  }

  export type CategoryUpdateOneRequiredWithoutCoursesNestedInput = {
    create?: XOR<CategoryCreateWithoutCoursesInput, CategoryUncheckedCreateWithoutCoursesInput>
    connectOrCreate?: CategoryCreateOrConnectWithoutCoursesInput
    upsert?: CategoryUpsertWithoutCoursesInput
    connect?: CategoryWhereUniqueInput
    update?: XOR<XOR<CategoryUpdateToOneWithWhereWithoutCoursesInput, CategoryUpdateWithoutCoursesInput>, CategoryUncheckedUpdateWithoutCoursesInput>
  }

  export type qnModelSetUpdateManyWithoutCourseNestedInput = {
    create?: XOR<qnModelSetCreateWithoutCourseInput, qnModelSetUncheckedCreateWithoutCourseInput> | qnModelSetCreateWithoutCourseInput[] | qnModelSetUncheckedCreateWithoutCourseInput[]
    connectOrCreate?: qnModelSetCreateOrConnectWithoutCourseInput | qnModelSetCreateOrConnectWithoutCourseInput[]
    upsert?: qnModelSetUpsertWithWhereUniqueWithoutCourseInput | qnModelSetUpsertWithWhereUniqueWithoutCourseInput[]
    createMany?: qnModelSetCreateManyCourseInputEnvelope
    set?: qnModelSetWhereUniqueInput | qnModelSetWhereUniqueInput[]
    disconnect?: qnModelSetWhereUniqueInput | qnModelSetWhereUniqueInput[]
    delete?: qnModelSetWhereUniqueInput | qnModelSetWhereUniqueInput[]
    connect?: qnModelSetWhereUniqueInput | qnModelSetWhereUniqueInput[]
    update?: qnModelSetUpdateWithWhereUniqueWithoutCourseInput | qnModelSetUpdateWithWhereUniqueWithoutCourseInput[]
    updateMany?: qnModelSetUpdateManyWithWhereWithoutCourseInput | qnModelSetUpdateManyWithWhereWithoutCourseInput[]
    deleteMany?: qnModelSetScalarWhereInput | qnModelSetScalarWhereInput[]
  }

  export type userSelectedCourseUpdateManyWithoutCourseNestedInput = {
    create?: XOR<userSelectedCourseCreateWithoutCourseInput, userSelectedCourseUncheckedCreateWithoutCourseInput> | userSelectedCourseCreateWithoutCourseInput[] | userSelectedCourseUncheckedCreateWithoutCourseInput[]
    connectOrCreate?: userSelectedCourseCreateOrConnectWithoutCourseInput | userSelectedCourseCreateOrConnectWithoutCourseInput[]
    upsert?: userSelectedCourseUpsertWithWhereUniqueWithoutCourseInput | userSelectedCourseUpsertWithWhereUniqueWithoutCourseInput[]
    createMany?: userSelectedCourseCreateManyCourseInputEnvelope
    set?: userSelectedCourseWhereUniqueInput | userSelectedCourseWhereUniqueInput[]
    disconnect?: userSelectedCourseWhereUniqueInput | userSelectedCourseWhereUniqueInput[]
    delete?: userSelectedCourseWhereUniqueInput | userSelectedCourseWhereUniqueInput[]
    connect?: userSelectedCourseWhereUniqueInput | userSelectedCourseWhereUniqueInput[]
    update?: userSelectedCourseUpdateWithWhereUniqueWithoutCourseInput | userSelectedCourseUpdateWithWhereUniqueWithoutCourseInput[]
    updateMany?: userSelectedCourseUpdateManyWithWhereWithoutCourseInput | userSelectedCourseUpdateManyWithWhereWithoutCourseInput[]
    deleteMany?: userSelectedCourseScalarWhereInput | userSelectedCourseScalarWhereInput[]
  }

  export type qnModelSetUncheckedUpdateManyWithoutCourseNestedInput = {
    create?: XOR<qnModelSetCreateWithoutCourseInput, qnModelSetUncheckedCreateWithoutCourseInput> | qnModelSetCreateWithoutCourseInput[] | qnModelSetUncheckedCreateWithoutCourseInput[]
    connectOrCreate?: qnModelSetCreateOrConnectWithoutCourseInput | qnModelSetCreateOrConnectWithoutCourseInput[]
    upsert?: qnModelSetUpsertWithWhereUniqueWithoutCourseInput | qnModelSetUpsertWithWhereUniqueWithoutCourseInput[]
    createMany?: qnModelSetCreateManyCourseInputEnvelope
    set?: qnModelSetWhereUniqueInput | qnModelSetWhereUniqueInput[]
    disconnect?: qnModelSetWhereUniqueInput | qnModelSetWhereUniqueInput[]
    delete?: qnModelSetWhereUniqueInput | qnModelSetWhereUniqueInput[]
    connect?: qnModelSetWhereUniqueInput | qnModelSetWhereUniqueInput[]
    update?: qnModelSetUpdateWithWhereUniqueWithoutCourseInput | qnModelSetUpdateWithWhereUniqueWithoutCourseInput[]
    updateMany?: qnModelSetUpdateManyWithWhereWithoutCourseInput | qnModelSetUpdateManyWithWhereWithoutCourseInput[]
    deleteMany?: qnModelSetScalarWhereInput | qnModelSetScalarWhereInput[]
  }

  export type userSelectedCourseUncheckedUpdateManyWithoutCourseNestedInput = {
    create?: XOR<userSelectedCourseCreateWithoutCourseInput, userSelectedCourseUncheckedCreateWithoutCourseInput> | userSelectedCourseCreateWithoutCourseInput[] | userSelectedCourseUncheckedCreateWithoutCourseInput[]
    connectOrCreate?: userSelectedCourseCreateOrConnectWithoutCourseInput | userSelectedCourseCreateOrConnectWithoutCourseInput[]
    upsert?: userSelectedCourseUpsertWithWhereUniqueWithoutCourseInput | userSelectedCourseUpsertWithWhereUniqueWithoutCourseInput[]
    createMany?: userSelectedCourseCreateManyCourseInputEnvelope
    set?: userSelectedCourseWhereUniqueInput | userSelectedCourseWhereUniqueInput[]
    disconnect?: userSelectedCourseWhereUniqueInput | userSelectedCourseWhereUniqueInput[]
    delete?: userSelectedCourseWhereUniqueInput | userSelectedCourseWhereUniqueInput[]
    connect?: userSelectedCourseWhereUniqueInput | userSelectedCourseWhereUniqueInput[]
    update?: userSelectedCourseUpdateWithWhereUniqueWithoutCourseInput | userSelectedCourseUpdateWithWhereUniqueWithoutCourseInput[]
    updateMany?: userSelectedCourseUpdateManyWithWhereWithoutCourseInput | userSelectedCourseUpdateManyWithWhereWithoutCourseInput[]
    deleteMany?: userSelectedCourseScalarWhereInput | userSelectedCourseScalarWhereInput[]
  }

  export type qnModelSetCreatetagInput = {
    set: string[]
  }

  export type CourseCreateNestedOneWithoutQnModelsInput = {
    create?: XOR<CourseCreateWithoutQnModelsInput, CourseUncheckedCreateWithoutQnModelsInput>
    connectOrCreate?: CourseCreateOrConnectWithoutQnModelsInput
    connect?: CourseWhereUniqueInput
  }

  export type userGivenExamSetCreateNestedManyWithoutQnModelSetInput = {
    create?: XOR<userGivenExamSetCreateWithoutQnModelSetInput, userGivenExamSetUncheckedCreateWithoutQnModelSetInput> | userGivenExamSetCreateWithoutQnModelSetInput[] | userGivenExamSetUncheckedCreateWithoutQnModelSetInput[]
    connectOrCreate?: userGivenExamSetCreateOrConnectWithoutQnModelSetInput | userGivenExamSetCreateOrConnectWithoutQnModelSetInput[]
    createMany?: userGivenExamSetCreateManyQnModelSetInputEnvelope
    connect?: userGivenExamSetWhereUniqueInput | userGivenExamSetWhereUniqueInput[]
  }

  export type userGivenExamSetUncheckedCreateNestedManyWithoutQnModelSetInput = {
    create?: XOR<userGivenExamSetCreateWithoutQnModelSetInput, userGivenExamSetUncheckedCreateWithoutQnModelSetInput> | userGivenExamSetCreateWithoutQnModelSetInput[] | userGivenExamSetUncheckedCreateWithoutQnModelSetInput[]
    connectOrCreate?: userGivenExamSetCreateOrConnectWithoutQnModelSetInput | userGivenExamSetCreateOrConnectWithoutQnModelSetInput[]
    createMany?: userGivenExamSetCreateManyQnModelSetInputEnvelope
    connect?: userGivenExamSetWhereUniqueInput | userGivenExamSetWhereUniqueInput[]
  }

  export type qnModelSetUpdatetagInput = {
    set?: string[]
    push?: string | string[]
  }

  export type CourseUpdateOneRequiredWithoutQnModelsNestedInput = {
    create?: XOR<CourseCreateWithoutQnModelsInput, CourseUncheckedCreateWithoutQnModelsInput>
    connectOrCreate?: CourseCreateOrConnectWithoutQnModelsInput
    upsert?: CourseUpsertWithoutQnModelsInput
    connect?: CourseWhereUniqueInput
    update?: XOR<XOR<CourseUpdateToOneWithWhereWithoutQnModelsInput, CourseUpdateWithoutQnModelsInput>, CourseUncheckedUpdateWithoutQnModelsInput>
  }

  export type userGivenExamSetUpdateManyWithoutQnModelSetNestedInput = {
    create?: XOR<userGivenExamSetCreateWithoutQnModelSetInput, userGivenExamSetUncheckedCreateWithoutQnModelSetInput> | userGivenExamSetCreateWithoutQnModelSetInput[] | userGivenExamSetUncheckedCreateWithoutQnModelSetInput[]
    connectOrCreate?: userGivenExamSetCreateOrConnectWithoutQnModelSetInput | userGivenExamSetCreateOrConnectWithoutQnModelSetInput[]
    upsert?: userGivenExamSetUpsertWithWhereUniqueWithoutQnModelSetInput | userGivenExamSetUpsertWithWhereUniqueWithoutQnModelSetInput[]
    createMany?: userGivenExamSetCreateManyQnModelSetInputEnvelope
    set?: userGivenExamSetWhereUniqueInput | userGivenExamSetWhereUniqueInput[]
    disconnect?: userGivenExamSetWhereUniqueInput | userGivenExamSetWhereUniqueInput[]
    delete?: userGivenExamSetWhereUniqueInput | userGivenExamSetWhereUniqueInput[]
    connect?: userGivenExamSetWhereUniqueInput | userGivenExamSetWhereUniqueInput[]
    update?: userGivenExamSetUpdateWithWhereUniqueWithoutQnModelSetInput | userGivenExamSetUpdateWithWhereUniqueWithoutQnModelSetInput[]
    updateMany?: userGivenExamSetUpdateManyWithWhereWithoutQnModelSetInput | userGivenExamSetUpdateManyWithWhereWithoutQnModelSetInput[]
    deleteMany?: userGivenExamSetScalarWhereInput | userGivenExamSetScalarWhereInput[]
  }

  export type userGivenExamSetUncheckedUpdateManyWithoutQnModelSetNestedInput = {
    create?: XOR<userGivenExamSetCreateWithoutQnModelSetInput, userGivenExamSetUncheckedCreateWithoutQnModelSetInput> | userGivenExamSetCreateWithoutQnModelSetInput[] | userGivenExamSetUncheckedCreateWithoutQnModelSetInput[]
    connectOrCreate?: userGivenExamSetCreateOrConnectWithoutQnModelSetInput | userGivenExamSetCreateOrConnectWithoutQnModelSetInput[]
    upsert?: userGivenExamSetUpsertWithWhereUniqueWithoutQnModelSetInput | userGivenExamSetUpsertWithWhereUniqueWithoutQnModelSetInput[]
    createMany?: userGivenExamSetCreateManyQnModelSetInputEnvelope
    set?: userGivenExamSetWhereUniqueInput | userGivenExamSetWhereUniqueInput[]
    disconnect?: userGivenExamSetWhereUniqueInput | userGivenExamSetWhereUniqueInput[]
    delete?: userGivenExamSetWhereUniqueInput | userGivenExamSetWhereUniqueInput[]
    connect?: userGivenExamSetWhereUniqueInput | userGivenExamSetWhereUniqueInput[]
    update?: userGivenExamSetUpdateWithWhereUniqueWithoutQnModelSetInput | userGivenExamSetUpdateWithWhereUniqueWithoutQnModelSetInput[]
    updateMany?: userGivenExamSetUpdateManyWithWhereWithoutQnModelSetInput | userGivenExamSetUpdateManyWithWhereWithoutQnModelSetInput[]
    deleteMany?: userGivenExamSetScalarWhereInput | userGivenExamSetScalarWhereInput[]
  }

  export type UserCreateNestedOneWithoutExamSetsInput = {
    create?: XOR<UserCreateWithoutExamSetsInput, UserUncheckedCreateWithoutExamSetsInput>
    connectOrCreate?: UserCreateOrConnectWithoutExamSetsInput
    connect?: UserWhereUniqueInput
  }

  export type qnModelSetCreateNestedOneWithoutGivenExamsInput = {
    create?: XOR<qnModelSetCreateWithoutGivenExamsInput, qnModelSetUncheckedCreateWithoutGivenExamsInput>
    connectOrCreate?: qnModelSetCreateOrConnectWithoutGivenExamsInput
    connect?: qnModelSetWhereUniqueInput
  }

  export type UserUpdateOneRequiredWithoutExamSetsNestedInput = {
    create?: XOR<UserCreateWithoutExamSetsInput, UserUncheckedCreateWithoutExamSetsInput>
    connectOrCreate?: UserCreateOrConnectWithoutExamSetsInput
    upsert?: UserUpsertWithoutExamSetsInput
    connect?: UserWhereUniqueInput
    update?: XOR<XOR<UserUpdateToOneWithWhereWithoutExamSetsInput, UserUpdateWithoutExamSetsInput>, UserUncheckedUpdateWithoutExamSetsInput>
  }

  export type qnModelSetUpdateOneRequiredWithoutGivenExamsNestedInput = {
    create?: XOR<qnModelSetCreateWithoutGivenExamsInput, qnModelSetUncheckedCreateWithoutGivenExamsInput>
    connectOrCreate?: qnModelSetCreateOrConnectWithoutGivenExamsInput
    upsert?: qnModelSetUpsertWithoutGivenExamsInput
    connect?: qnModelSetWhereUniqueInput
    update?: XOR<XOR<qnModelSetUpdateToOneWithWhereWithoutGivenExamsInput, qnModelSetUpdateWithoutGivenExamsInput>, qnModelSetUncheckedUpdateWithoutGivenExamsInput>
  }

  export type UserCreateNestedOneWithoutSelectedCoursesInput = {
    create?: XOR<UserCreateWithoutSelectedCoursesInput, UserUncheckedCreateWithoutSelectedCoursesInput>
    connectOrCreate?: UserCreateOrConnectWithoutSelectedCoursesInput
    connect?: UserWhereUniqueInput
  }

  export type CourseCreateNestedOneWithoutSelectedByInput = {
    create?: XOR<CourseCreateWithoutSelectedByInput, CourseUncheckedCreateWithoutSelectedByInput>
    connectOrCreate?: CourseCreateOrConnectWithoutSelectedByInput
    connect?: CourseWhereUniqueInput
  }

  export type UserUpdateOneRequiredWithoutSelectedCoursesNestedInput = {
    create?: XOR<UserCreateWithoutSelectedCoursesInput, UserUncheckedCreateWithoutSelectedCoursesInput>
    connectOrCreate?: UserCreateOrConnectWithoutSelectedCoursesInput
    upsert?: UserUpsertWithoutSelectedCoursesInput
    connect?: UserWhereUniqueInput
    update?: XOR<XOR<UserUpdateToOneWithWhereWithoutSelectedCoursesInput, UserUpdateWithoutSelectedCoursesInput>, UserUncheckedUpdateWithoutSelectedCoursesInput>
  }

  export type CourseUpdateOneRequiredWithoutSelectedByNestedInput = {
    create?: XOR<CourseCreateWithoutSelectedByInput, CourseUncheckedCreateWithoutSelectedByInput>
    connectOrCreate?: CourseCreateOrConnectWithoutSelectedByInput
    upsert?: CourseUpsertWithoutSelectedByInput
    connect?: CourseWhereUniqueInput
    update?: XOR<XOR<CourseUpdateToOneWithWhereWithoutSelectedByInput, CourseUpdateWithoutSelectedByInput>, CourseUncheckedUpdateWithoutSelectedByInput>
  }

  export type NestedIntFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[] | ListIntFieldRefInput<$PrismaModel>
    notIn?: number[] | ListIntFieldRefInput<$PrismaModel>
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntFilter<$PrismaModel> | number
  }

  export type NestedStringFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[] | ListStringFieldRefInput<$PrismaModel>
    notIn?: string[] | ListStringFieldRefInput<$PrismaModel>
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    not?: NestedStringFilter<$PrismaModel> | string
  }

  export type NestedEnumRoleFilter<$PrismaModel = never> = {
    equals?: $Enums.Role | EnumRoleFieldRefInput<$PrismaModel>
    in?: $Enums.Role[] | ListEnumRoleFieldRefInput<$PrismaModel>
    notIn?: $Enums.Role[] | ListEnumRoleFieldRefInput<$PrismaModel>
    not?: NestedEnumRoleFilter<$PrismaModel> | $Enums.Role
  }

  export type NestedDateTimeFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeFilter<$PrismaModel> | Date | string
  }

  export type NestedDateTimeNullableFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel> | null
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeNullableFilter<$PrismaModel> | Date | string | null
  }

  export type NestedIntWithAggregatesFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[] | ListIntFieldRefInput<$PrismaModel>
    notIn?: number[] | ListIntFieldRefInput<$PrismaModel>
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntWithAggregatesFilter<$PrismaModel> | number
    _count?: NestedIntFilter<$PrismaModel>
    _avg?: NestedFloatFilter<$PrismaModel>
    _sum?: NestedIntFilter<$PrismaModel>
    _min?: NestedIntFilter<$PrismaModel>
    _max?: NestedIntFilter<$PrismaModel>
  }

  export type NestedFloatFilter<$PrismaModel = never> = {
    equals?: number | FloatFieldRefInput<$PrismaModel>
    in?: number[] | ListFloatFieldRefInput<$PrismaModel>
    notIn?: number[] | ListFloatFieldRefInput<$PrismaModel>
    lt?: number | FloatFieldRefInput<$PrismaModel>
    lte?: number | FloatFieldRefInput<$PrismaModel>
    gt?: number | FloatFieldRefInput<$PrismaModel>
    gte?: number | FloatFieldRefInput<$PrismaModel>
    not?: NestedFloatFilter<$PrismaModel> | number
  }

  export type NestedStringWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[] | ListStringFieldRefInput<$PrismaModel>
    notIn?: string[] | ListStringFieldRefInput<$PrismaModel>
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    not?: NestedStringWithAggregatesFilter<$PrismaModel> | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedStringFilter<$PrismaModel>
    _max?: NestedStringFilter<$PrismaModel>
  }

  export type NestedEnumRoleWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.Role | EnumRoleFieldRefInput<$PrismaModel>
    in?: $Enums.Role[] | ListEnumRoleFieldRefInput<$PrismaModel>
    notIn?: $Enums.Role[] | ListEnumRoleFieldRefInput<$PrismaModel>
    not?: NestedEnumRoleWithAggregatesFilter<$PrismaModel> | $Enums.Role
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedEnumRoleFilter<$PrismaModel>
    _max?: NestedEnumRoleFilter<$PrismaModel>
  }

  export type NestedDateTimeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeWithAggregatesFilter<$PrismaModel> | Date | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedDateTimeFilter<$PrismaModel>
    _max?: NestedDateTimeFilter<$PrismaModel>
  }

  export type NestedDateTimeNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel> | null
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeNullableWithAggregatesFilter<$PrismaModel> | Date | string | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedDateTimeNullableFilter<$PrismaModel>
    _max?: NestedDateTimeNullableFilter<$PrismaModel>
  }

  export type NestedIntNullableFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel> | null
    in?: number[] | ListIntFieldRefInput<$PrismaModel> | null
    notIn?: number[] | ListIntFieldRefInput<$PrismaModel> | null
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntNullableFilter<$PrismaModel> | number | null
  }

  export type NestedEnumStatusFilter<$PrismaModel = never> = {
    equals?: $Enums.Status | EnumStatusFieldRefInput<$PrismaModel>
    in?: $Enums.Status[] | ListEnumStatusFieldRefInput<$PrismaModel>
    notIn?: $Enums.Status[] | ListEnumStatusFieldRefInput<$PrismaModel>
    not?: NestedEnumStatusFilter<$PrismaModel> | $Enums.Status
  }

  export type NestedEnumStatusWithAggregatesFilter<$PrismaModel = never> = {
    equals?: $Enums.Status | EnumStatusFieldRefInput<$PrismaModel>
    in?: $Enums.Status[] | ListEnumStatusFieldRefInput<$PrismaModel>
    notIn?: $Enums.Status[] | ListEnumStatusFieldRefInput<$PrismaModel>
    not?: NestedEnumStatusWithAggregatesFilter<$PrismaModel> | $Enums.Status
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedEnumStatusFilter<$PrismaModel>
    _max?: NestedEnumStatusFilter<$PrismaModel>
  }
  export type NestedJsonFilter<$PrismaModel = never> =
    | PatchUndefined<
        Either<Required<NestedJsonFilterBase<$PrismaModel>>, Exclude<keyof Required<NestedJsonFilterBase<$PrismaModel>>, 'path'>>,
        Required<NestedJsonFilterBase<$PrismaModel>>
      >
    | OptionalFlat<Omit<Required<NestedJsonFilterBase<$PrismaModel>>, 'path'>>

  export type NestedJsonFilterBase<$PrismaModel = never> = {
    equals?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | JsonNullValueFilter
    path?: string[]
    mode?: QueryMode | EnumQueryModeFieldRefInput<$PrismaModel>
    string_contains?: string | StringFieldRefInput<$PrismaModel>
    string_starts_with?: string | StringFieldRefInput<$PrismaModel>
    string_ends_with?: string | StringFieldRefInput<$PrismaModel>
    array_starts_with?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    array_ends_with?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    array_contains?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | null
    lt?: InputJsonValue | JsonFieldRefInput<$PrismaModel>
    lte?: InputJsonValue | JsonFieldRefInput<$PrismaModel>
    gt?: InputJsonValue | JsonFieldRefInput<$PrismaModel>
    gte?: InputJsonValue | JsonFieldRefInput<$PrismaModel>
    not?: InputJsonValue | JsonFieldRefInput<$PrismaModel> | JsonNullValueFilter
  }

  export type userGivenExamSetCreateWithoutUserInput = {
    qn_ans: JsonNullValueInput | InputJsonValue
    qn_title: string
    obtainedMarks: string
    examtimeTaken: string
    status?: $Enums.Status
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    qnModelSet: qnModelSetCreateNestedOneWithoutGivenExamsInput
  }

  export type userGivenExamSetUncheckedCreateWithoutUserInput = {
    id?: number
    qn_set_id: number
    qn_ans: JsonNullValueInput | InputJsonValue
    qn_title: string
    obtainedMarks: string
    examtimeTaken: string
    status?: $Enums.Status
    createdAt?: Date | string
    modifiedAt?: Date | string | null
  }

  export type userGivenExamSetCreateOrConnectWithoutUserInput = {
    where: userGivenExamSetWhereUniqueInput
    create: XOR<userGivenExamSetCreateWithoutUserInput, userGivenExamSetUncheckedCreateWithoutUserInput>
  }

  export type userGivenExamSetCreateManyUserInputEnvelope = {
    data: userGivenExamSetCreateManyUserInput | userGivenExamSetCreateManyUserInput[]
    skipDuplicates?: boolean
  }

  export type userSelectedCourseCreateWithoutUserInput = {
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    course: CourseCreateNestedOneWithoutSelectedByInput
  }

  export type userSelectedCourseUncheckedCreateWithoutUserInput = {
    id?: number
    course_id: number
    createdAt?: Date | string
    modifiedAt?: Date | string | null
  }

  export type userSelectedCourseCreateOrConnectWithoutUserInput = {
    where: userSelectedCourseWhereUniqueInput
    create: XOR<userSelectedCourseCreateWithoutUserInput, userSelectedCourseUncheckedCreateWithoutUserInput>
  }

  export type userSelectedCourseCreateManyUserInputEnvelope = {
    data: userSelectedCourseCreateManyUserInput | userSelectedCourseCreateManyUserInput[]
    skipDuplicates?: boolean
  }

  export type userGivenExamSetUpsertWithWhereUniqueWithoutUserInput = {
    where: userGivenExamSetWhereUniqueInput
    update: XOR<userGivenExamSetUpdateWithoutUserInput, userGivenExamSetUncheckedUpdateWithoutUserInput>
    create: XOR<userGivenExamSetCreateWithoutUserInput, userGivenExamSetUncheckedCreateWithoutUserInput>
  }

  export type userGivenExamSetUpdateWithWhereUniqueWithoutUserInput = {
    where: userGivenExamSetWhereUniqueInput
    data: XOR<userGivenExamSetUpdateWithoutUserInput, userGivenExamSetUncheckedUpdateWithoutUserInput>
  }

  export type userGivenExamSetUpdateManyWithWhereWithoutUserInput = {
    where: userGivenExamSetScalarWhereInput
    data: XOR<userGivenExamSetUpdateManyMutationInput, userGivenExamSetUncheckedUpdateManyWithoutUserInput>
  }

  export type userGivenExamSetScalarWhereInput = {
    AND?: userGivenExamSetScalarWhereInput | userGivenExamSetScalarWhereInput[]
    OR?: userGivenExamSetScalarWhereInput[]
    NOT?: userGivenExamSetScalarWhereInput | userGivenExamSetScalarWhereInput[]
    id?: IntFilter<"userGivenExamSet"> | number
    user_id?: IntFilter<"userGivenExamSet"> | number
    qn_set_id?: IntFilter<"userGivenExamSet"> | number
    qn_ans?: JsonFilter<"userGivenExamSet">
    qn_title?: StringFilter<"userGivenExamSet"> | string
    obtainedMarks?: StringFilter<"userGivenExamSet"> | string
    examtimeTaken?: StringFilter<"userGivenExamSet"> | string
    status?: EnumStatusFilter<"userGivenExamSet"> | $Enums.Status
    createdAt?: DateTimeFilter<"userGivenExamSet"> | Date | string
    modifiedAt?: DateTimeNullableFilter<"userGivenExamSet"> | Date | string | null
  }

  export type userSelectedCourseUpsertWithWhereUniqueWithoutUserInput = {
    where: userSelectedCourseWhereUniqueInput
    update: XOR<userSelectedCourseUpdateWithoutUserInput, userSelectedCourseUncheckedUpdateWithoutUserInput>
    create: XOR<userSelectedCourseCreateWithoutUserInput, userSelectedCourseUncheckedCreateWithoutUserInput>
  }

  export type userSelectedCourseUpdateWithWhereUniqueWithoutUserInput = {
    where: userSelectedCourseWhereUniqueInput
    data: XOR<userSelectedCourseUpdateWithoutUserInput, userSelectedCourseUncheckedUpdateWithoutUserInput>
  }

  export type userSelectedCourseUpdateManyWithWhereWithoutUserInput = {
    where: userSelectedCourseScalarWhereInput
    data: XOR<userSelectedCourseUpdateManyMutationInput, userSelectedCourseUncheckedUpdateManyWithoutUserInput>
  }

  export type userSelectedCourseScalarWhereInput = {
    AND?: userSelectedCourseScalarWhereInput | userSelectedCourseScalarWhereInput[]
    OR?: userSelectedCourseScalarWhereInput[]
    NOT?: userSelectedCourseScalarWhereInput | userSelectedCourseScalarWhereInput[]
    id?: IntFilter<"userSelectedCourse"> | number
    user_id?: IntFilter<"userSelectedCourse"> | number
    course_id?: IntFilter<"userSelectedCourse"> | number
    createdAt?: DateTimeFilter<"userSelectedCourse"> | Date | string
    modifiedAt?: DateTimeNullableFilter<"userSelectedCourse"> | Date | string | null
  }

  export type CourseCreateWithoutCategoryInput = {
    course_name: string
    status?: $Enums.Status
    tag?: CourseCreatetagInput | string[]
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    qnModels?: qnModelSetCreateNestedManyWithoutCourseInput
    selectedBy?: userSelectedCourseCreateNestedManyWithoutCourseInput
  }

  export type CourseUncheckedCreateWithoutCategoryInput = {
    id?: number
    course_name: string
    status?: $Enums.Status
    tag?: CourseCreatetagInput | string[]
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    qnModels?: qnModelSetUncheckedCreateNestedManyWithoutCourseInput
    selectedBy?: userSelectedCourseUncheckedCreateNestedManyWithoutCourseInput
  }

  export type CourseCreateOrConnectWithoutCategoryInput = {
    where: CourseWhereUniqueInput
    create: XOR<CourseCreateWithoutCategoryInput, CourseUncheckedCreateWithoutCategoryInput>
  }

  export type CourseCreateManyCategoryInputEnvelope = {
    data: CourseCreateManyCategoryInput | CourseCreateManyCategoryInput[]
    skipDuplicates?: boolean
  }

  export type CourseUpsertWithWhereUniqueWithoutCategoryInput = {
    where: CourseWhereUniqueInput
    update: XOR<CourseUpdateWithoutCategoryInput, CourseUncheckedUpdateWithoutCategoryInput>
    create: XOR<CourseCreateWithoutCategoryInput, CourseUncheckedCreateWithoutCategoryInput>
  }

  export type CourseUpdateWithWhereUniqueWithoutCategoryInput = {
    where: CourseWhereUniqueInput
    data: XOR<CourseUpdateWithoutCategoryInput, CourseUncheckedUpdateWithoutCategoryInput>
  }

  export type CourseUpdateManyWithWhereWithoutCategoryInput = {
    where: CourseScalarWhereInput
    data: XOR<CourseUpdateManyMutationInput, CourseUncheckedUpdateManyWithoutCategoryInput>
  }

  export type CourseScalarWhereInput = {
    AND?: CourseScalarWhereInput | CourseScalarWhereInput[]
    OR?: CourseScalarWhereInput[]
    NOT?: CourseScalarWhereInput | CourseScalarWhereInput[]
    id?: IntFilter<"Course"> | number
    course_name?: StringFilter<"Course"> | string
    status?: EnumStatusFilter<"Course"> | $Enums.Status
    tag?: StringNullableListFilter<"Course">
    category_id?: IntFilter<"Course"> | number
    createdAt?: DateTimeFilter<"Course"> | Date | string
    modifiedAt?: DateTimeNullableFilter<"Course"> | Date | string | null
  }

  export type CategoryCreateWithoutCoursesInput = {
    category_name: string
    status?: $Enums.Status
    tag?: CategoryCreatetagInput | string[]
    createdAt?: Date | string
    modifiedAt?: Date | string | null
  }

  export type CategoryUncheckedCreateWithoutCoursesInput = {
    id?: number
    category_name: string
    status?: $Enums.Status
    tag?: CategoryCreatetagInput | string[]
    createdAt?: Date | string
    modifiedAt?: Date | string | null
  }

  export type CategoryCreateOrConnectWithoutCoursesInput = {
    where: CategoryWhereUniqueInput
    create: XOR<CategoryCreateWithoutCoursesInput, CategoryUncheckedCreateWithoutCoursesInput>
  }

  export type qnModelSetCreateWithoutCourseInput = {
    qn_title: string
    modelset_info: JsonNullValueInput | InputJsonValue
    qn_set: JsonNullValueInput | InputJsonValue
    exam_time: string
    status?: $Enums.Status
    tag?: qnModelSetCreatetagInput | string[]
    createBy: string
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    givenExams?: userGivenExamSetCreateNestedManyWithoutQnModelSetInput
  }

  export type qnModelSetUncheckedCreateWithoutCourseInput = {
    id?: number
    qn_title: string
    modelset_info: JsonNullValueInput | InputJsonValue
    qn_set: JsonNullValueInput | InputJsonValue
    exam_time: string
    status?: $Enums.Status
    tag?: qnModelSetCreatetagInput | string[]
    createBy: string
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    givenExams?: userGivenExamSetUncheckedCreateNestedManyWithoutQnModelSetInput
  }

  export type qnModelSetCreateOrConnectWithoutCourseInput = {
    where: qnModelSetWhereUniqueInput
    create: XOR<qnModelSetCreateWithoutCourseInput, qnModelSetUncheckedCreateWithoutCourseInput>
  }

  export type qnModelSetCreateManyCourseInputEnvelope = {
    data: qnModelSetCreateManyCourseInput | qnModelSetCreateManyCourseInput[]
    skipDuplicates?: boolean
  }

  export type userSelectedCourseCreateWithoutCourseInput = {
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    user: UserCreateNestedOneWithoutSelectedCoursesInput
  }

  export type userSelectedCourseUncheckedCreateWithoutCourseInput = {
    id?: number
    user_id: number
    createdAt?: Date | string
    modifiedAt?: Date | string | null
  }

  export type userSelectedCourseCreateOrConnectWithoutCourseInput = {
    where: userSelectedCourseWhereUniqueInput
    create: XOR<userSelectedCourseCreateWithoutCourseInput, userSelectedCourseUncheckedCreateWithoutCourseInput>
  }

  export type userSelectedCourseCreateManyCourseInputEnvelope = {
    data: userSelectedCourseCreateManyCourseInput | userSelectedCourseCreateManyCourseInput[]
    skipDuplicates?: boolean
  }

  export type CategoryUpsertWithoutCoursesInput = {
    update: XOR<CategoryUpdateWithoutCoursesInput, CategoryUncheckedUpdateWithoutCoursesInput>
    create: XOR<CategoryCreateWithoutCoursesInput, CategoryUncheckedCreateWithoutCoursesInput>
    where?: CategoryWhereInput
  }

  export type CategoryUpdateToOneWithWhereWithoutCoursesInput = {
    where?: CategoryWhereInput
    data: XOR<CategoryUpdateWithoutCoursesInput, CategoryUncheckedUpdateWithoutCoursesInput>
  }

  export type CategoryUpdateWithoutCoursesInput = {
    category_name?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: CategoryUpdatetagInput | string[]
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type CategoryUncheckedUpdateWithoutCoursesInput = {
    id?: IntFieldUpdateOperationsInput | number
    category_name?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: CategoryUpdatetagInput | string[]
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type qnModelSetUpsertWithWhereUniqueWithoutCourseInput = {
    where: qnModelSetWhereUniqueInput
    update: XOR<qnModelSetUpdateWithoutCourseInput, qnModelSetUncheckedUpdateWithoutCourseInput>
    create: XOR<qnModelSetCreateWithoutCourseInput, qnModelSetUncheckedCreateWithoutCourseInput>
  }

  export type qnModelSetUpdateWithWhereUniqueWithoutCourseInput = {
    where: qnModelSetWhereUniqueInput
    data: XOR<qnModelSetUpdateWithoutCourseInput, qnModelSetUncheckedUpdateWithoutCourseInput>
  }

  export type qnModelSetUpdateManyWithWhereWithoutCourseInput = {
    where: qnModelSetScalarWhereInput
    data: XOR<qnModelSetUpdateManyMutationInput, qnModelSetUncheckedUpdateManyWithoutCourseInput>
  }

  export type qnModelSetScalarWhereInput = {
    AND?: qnModelSetScalarWhereInput | qnModelSetScalarWhereInput[]
    OR?: qnModelSetScalarWhereInput[]
    NOT?: qnModelSetScalarWhereInput | qnModelSetScalarWhereInput[]
    id?: IntFilter<"qnModelSet"> | number
    qn_title?: StringFilter<"qnModelSet"> | string
    modelset_info?: JsonFilter<"qnModelSet">
    qn_set?: JsonFilter<"qnModelSet">
    exam_time?: StringFilter<"qnModelSet"> | string
    status?: EnumStatusFilter<"qnModelSet"> | $Enums.Status
    tag?: StringNullableListFilter<"qnModelSet">
    createBy?: StringFilter<"qnModelSet"> | string
    course_id?: IntFilter<"qnModelSet"> | number
    createdAt?: DateTimeFilter<"qnModelSet"> | Date | string
    modifiedAt?: DateTimeNullableFilter<"qnModelSet"> | Date | string | null
  }

  export type userSelectedCourseUpsertWithWhereUniqueWithoutCourseInput = {
    where: userSelectedCourseWhereUniqueInput
    update: XOR<userSelectedCourseUpdateWithoutCourseInput, userSelectedCourseUncheckedUpdateWithoutCourseInput>
    create: XOR<userSelectedCourseCreateWithoutCourseInput, userSelectedCourseUncheckedCreateWithoutCourseInput>
  }

  export type userSelectedCourseUpdateWithWhereUniqueWithoutCourseInput = {
    where: userSelectedCourseWhereUniqueInput
    data: XOR<userSelectedCourseUpdateWithoutCourseInput, userSelectedCourseUncheckedUpdateWithoutCourseInput>
  }

  export type userSelectedCourseUpdateManyWithWhereWithoutCourseInput = {
    where: userSelectedCourseScalarWhereInput
    data: XOR<userSelectedCourseUpdateManyMutationInput, userSelectedCourseUncheckedUpdateManyWithoutCourseInput>
  }

  export type CourseCreateWithoutQnModelsInput = {
    course_name: string
    status?: $Enums.Status
    tag?: CourseCreatetagInput | string[]
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    category: CategoryCreateNestedOneWithoutCoursesInput
    selectedBy?: userSelectedCourseCreateNestedManyWithoutCourseInput
  }

  export type CourseUncheckedCreateWithoutQnModelsInput = {
    id?: number
    course_name: string
    status?: $Enums.Status
    tag?: CourseCreatetagInput | string[]
    category_id: number
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    selectedBy?: userSelectedCourseUncheckedCreateNestedManyWithoutCourseInput
  }

  export type CourseCreateOrConnectWithoutQnModelsInput = {
    where: CourseWhereUniqueInput
    create: XOR<CourseCreateWithoutQnModelsInput, CourseUncheckedCreateWithoutQnModelsInput>
  }

  export type userGivenExamSetCreateWithoutQnModelSetInput = {
    qn_ans: JsonNullValueInput | InputJsonValue
    qn_title: string
    obtainedMarks: string
    examtimeTaken: string
    status?: $Enums.Status
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    user: UserCreateNestedOneWithoutExamSetsInput
  }

  export type userGivenExamSetUncheckedCreateWithoutQnModelSetInput = {
    id?: number
    user_id: number
    qn_ans: JsonNullValueInput | InputJsonValue
    qn_title: string
    obtainedMarks: string
    examtimeTaken: string
    status?: $Enums.Status
    createdAt?: Date | string
    modifiedAt?: Date | string | null
  }

  export type userGivenExamSetCreateOrConnectWithoutQnModelSetInput = {
    where: userGivenExamSetWhereUniqueInput
    create: XOR<userGivenExamSetCreateWithoutQnModelSetInput, userGivenExamSetUncheckedCreateWithoutQnModelSetInput>
  }

  export type userGivenExamSetCreateManyQnModelSetInputEnvelope = {
    data: userGivenExamSetCreateManyQnModelSetInput | userGivenExamSetCreateManyQnModelSetInput[]
    skipDuplicates?: boolean
  }

  export type CourseUpsertWithoutQnModelsInput = {
    update: XOR<CourseUpdateWithoutQnModelsInput, CourseUncheckedUpdateWithoutQnModelsInput>
    create: XOR<CourseCreateWithoutQnModelsInput, CourseUncheckedCreateWithoutQnModelsInput>
    where?: CourseWhereInput
  }

  export type CourseUpdateToOneWithWhereWithoutQnModelsInput = {
    where?: CourseWhereInput
    data: XOR<CourseUpdateWithoutQnModelsInput, CourseUncheckedUpdateWithoutQnModelsInput>
  }

  export type CourseUpdateWithoutQnModelsInput = {
    course_name?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: CourseUpdatetagInput | string[]
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    category?: CategoryUpdateOneRequiredWithoutCoursesNestedInput
    selectedBy?: userSelectedCourseUpdateManyWithoutCourseNestedInput
  }

  export type CourseUncheckedUpdateWithoutQnModelsInput = {
    id?: IntFieldUpdateOperationsInput | number
    course_name?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: CourseUpdatetagInput | string[]
    category_id?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    selectedBy?: userSelectedCourseUncheckedUpdateManyWithoutCourseNestedInput
  }

  export type userGivenExamSetUpsertWithWhereUniqueWithoutQnModelSetInput = {
    where: userGivenExamSetWhereUniqueInput
    update: XOR<userGivenExamSetUpdateWithoutQnModelSetInput, userGivenExamSetUncheckedUpdateWithoutQnModelSetInput>
    create: XOR<userGivenExamSetCreateWithoutQnModelSetInput, userGivenExamSetUncheckedCreateWithoutQnModelSetInput>
  }

  export type userGivenExamSetUpdateWithWhereUniqueWithoutQnModelSetInput = {
    where: userGivenExamSetWhereUniqueInput
    data: XOR<userGivenExamSetUpdateWithoutQnModelSetInput, userGivenExamSetUncheckedUpdateWithoutQnModelSetInput>
  }

  export type userGivenExamSetUpdateManyWithWhereWithoutQnModelSetInput = {
    where: userGivenExamSetScalarWhereInput
    data: XOR<userGivenExamSetUpdateManyMutationInput, userGivenExamSetUncheckedUpdateManyWithoutQnModelSetInput>
  }

  export type UserCreateWithoutExamSetsInput = {
    name: string
    email: string
    status?: $Enums.Role
    password: string
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    selectedCourses?: userSelectedCourseCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateWithoutExamSetsInput = {
    id?: number
    name: string
    email: string
    status?: $Enums.Role
    password: string
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    selectedCourses?: userSelectedCourseUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserCreateOrConnectWithoutExamSetsInput = {
    where: UserWhereUniqueInput
    create: XOR<UserCreateWithoutExamSetsInput, UserUncheckedCreateWithoutExamSetsInput>
  }

  export type qnModelSetCreateWithoutGivenExamsInput = {
    qn_title: string
    modelset_info: JsonNullValueInput | InputJsonValue
    qn_set: JsonNullValueInput | InputJsonValue
    exam_time: string
    status?: $Enums.Status
    tag?: qnModelSetCreatetagInput | string[]
    createBy: string
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    course: CourseCreateNestedOneWithoutQnModelsInput
  }

  export type qnModelSetUncheckedCreateWithoutGivenExamsInput = {
    id?: number
    qn_title: string
    modelset_info: JsonNullValueInput | InputJsonValue
    qn_set: JsonNullValueInput | InputJsonValue
    exam_time: string
    status?: $Enums.Status
    tag?: qnModelSetCreatetagInput | string[]
    createBy: string
    course_id: number
    createdAt?: Date | string
    modifiedAt?: Date | string | null
  }

  export type qnModelSetCreateOrConnectWithoutGivenExamsInput = {
    where: qnModelSetWhereUniqueInput
    create: XOR<qnModelSetCreateWithoutGivenExamsInput, qnModelSetUncheckedCreateWithoutGivenExamsInput>
  }

  export type UserUpsertWithoutExamSetsInput = {
    update: XOR<UserUpdateWithoutExamSetsInput, UserUncheckedUpdateWithoutExamSetsInput>
    create: XOR<UserCreateWithoutExamSetsInput, UserUncheckedCreateWithoutExamSetsInput>
    where?: UserWhereInput
  }

  export type UserUpdateToOneWithWhereWithoutExamSetsInput = {
    where?: UserWhereInput
    data: XOR<UserUpdateWithoutExamSetsInput, UserUncheckedUpdateWithoutExamSetsInput>
  }

  export type UserUpdateWithoutExamSetsInput = {
    name?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    status?: EnumRoleFieldUpdateOperationsInput | $Enums.Role
    password?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    selectedCourses?: userSelectedCourseUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateWithoutExamSetsInput = {
    id?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    status?: EnumRoleFieldUpdateOperationsInput | $Enums.Role
    password?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    selectedCourses?: userSelectedCourseUncheckedUpdateManyWithoutUserNestedInput
  }

  export type qnModelSetUpsertWithoutGivenExamsInput = {
    update: XOR<qnModelSetUpdateWithoutGivenExamsInput, qnModelSetUncheckedUpdateWithoutGivenExamsInput>
    create: XOR<qnModelSetCreateWithoutGivenExamsInput, qnModelSetUncheckedCreateWithoutGivenExamsInput>
    where?: qnModelSetWhereInput
  }

  export type qnModelSetUpdateToOneWithWhereWithoutGivenExamsInput = {
    where?: qnModelSetWhereInput
    data: XOR<qnModelSetUpdateWithoutGivenExamsInput, qnModelSetUncheckedUpdateWithoutGivenExamsInput>
  }

  export type qnModelSetUpdateWithoutGivenExamsInput = {
    qn_title?: StringFieldUpdateOperationsInput | string
    modelset_info?: JsonNullValueInput | InputJsonValue
    qn_set?: JsonNullValueInput | InputJsonValue
    exam_time?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: qnModelSetUpdatetagInput | string[]
    createBy?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    course?: CourseUpdateOneRequiredWithoutQnModelsNestedInput
  }

  export type qnModelSetUncheckedUpdateWithoutGivenExamsInput = {
    id?: IntFieldUpdateOperationsInput | number
    qn_title?: StringFieldUpdateOperationsInput | string
    modelset_info?: JsonNullValueInput | InputJsonValue
    qn_set?: JsonNullValueInput | InputJsonValue
    exam_time?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: qnModelSetUpdatetagInput | string[]
    createBy?: StringFieldUpdateOperationsInput | string
    course_id?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type UserCreateWithoutSelectedCoursesInput = {
    name: string
    email: string
    status?: $Enums.Role
    password: string
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    examSets?: userGivenExamSetCreateNestedManyWithoutUserInput
  }

  export type UserUncheckedCreateWithoutSelectedCoursesInput = {
    id?: number
    name: string
    email: string
    status?: $Enums.Role
    password: string
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    examSets?: userGivenExamSetUncheckedCreateNestedManyWithoutUserInput
  }

  export type UserCreateOrConnectWithoutSelectedCoursesInput = {
    where: UserWhereUniqueInput
    create: XOR<UserCreateWithoutSelectedCoursesInput, UserUncheckedCreateWithoutSelectedCoursesInput>
  }

  export type CourseCreateWithoutSelectedByInput = {
    course_name: string
    status?: $Enums.Status
    tag?: CourseCreatetagInput | string[]
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    category: CategoryCreateNestedOneWithoutCoursesInput
    qnModels?: qnModelSetCreateNestedManyWithoutCourseInput
  }

  export type CourseUncheckedCreateWithoutSelectedByInput = {
    id?: number
    course_name: string
    status?: $Enums.Status
    tag?: CourseCreatetagInput | string[]
    category_id: number
    createdAt?: Date | string
    modifiedAt?: Date | string | null
    qnModels?: qnModelSetUncheckedCreateNestedManyWithoutCourseInput
  }

  export type CourseCreateOrConnectWithoutSelectedByInput = {
    where: CourseWhereUniqueInput
    create: XOR<CourseCreateWithoutSelectedByInput, CourseUncheckedCreateWithoutSelectedByInput>
  }

  export type UserUpsertWithoutSelectedCoursesInput = {
    update: XOR<UserUpdateWithoutSelectedCoursesInput, UserUncheckedUpdateWithoutSelectedCoursesInput>
    create: XOR<UserCreateWithoutSelectedCoursesInput, UserUncheckedCreateWithoutSelectedCoursesInput>
    where?: UserWhereInput
  }

  export type UserUpdateToOneWithWhereWithoutSelectedCoursesInput = {
    where?: UserWhereInput
    data: XOR<UserUpdateWithoutSelectedCoursesInput, UserUncheckedUpdateWithoutSelectedCoursesInput>
  }

  export type UserUpdateWithoutSelectedCoursesInput = {
    name?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    status?: EnumRoleFieldUpdateOperationsInput | $Enums.Role
    password?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    examSets?: userGivenExamSetUpdateManyWithoutUserNestedInput
  }

  export type UserUncheckedUpdateWithoutSelectedCoursesInput = {
    id?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    email?: StringFieldUpdateOperationsInput | string
    status?: EnumRoleFieldUpdateOperationsInput | $Enums.Role
    password?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    examSets?: userGivenExamSetUncheckedUpdateManyWithoutUserNestedInput
  }

  export type CourseUpsertWithoutSelectedByInput = {
    update: XOR<CourseUpdateWithoutSelectedByInput, CourseUncheckedUpdateWithoutSelectedByInput>
    create: XOR<CourseCreateWithoutSelectedByInput, CourseUncheckedCreateWithoutSelectedByInput>
    where?: CourseWhereInput
  }

  export type CourseUpdateToOneWithWhereWithoutSelectedByInput = {
    where?: CourseWhereInput
    data: XOR<CourseUpdateWithoutSelectedByInput, CourseUncheckedUpdateWithoutSelectedByInput>
  }

  export type CourseUpdateWithoutSelectedByInput = {
    course_name?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: CourseUpdatetagInput | string[]
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    category?: CategoryUpdateOneRequiredWithoutCoursesNestedInput
    qnModels?: qnModelSetUpdateManyWithoutCourseNestedInput
  }

  export type CourseUncheckedUpdateWithoutSelectedByInput = {
    id?: IntFieldUpdateOperationsInput | number
    course_name?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: CourseUpdatetagInput | string[]
    category_id?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    qnModels?: qnModelSetUncheckedUpdateManyWithoutCourseNestedInput
  }

  export type userGivenExamSetCreateManyUserInput = {
    id?: number
    qn_set_id: number
    qn_ans: JsonNullValueInput | InputJsonValue
    qn_title: string
    obtainedMarks: string
    examtimeTaken: string
    status?: $Enums.Status
    createdAt?: Date | string
    modifiedAt?: Date | string | null
  }

  export type userSelectedCourseCreateManyUserInput = {
    id?: number
    course_id: number
    createdAt?: Date | string
    modifiedAt?: Date | string | null
  }

  export type userGivenExamSetUpdateWithoutUserInput = {
    qn_ans?: JsonNullValueInput | InputJsonValue
    qn_title?: StringFieldUpdateOperationsInput | string
    obtainedMarks?: StringFieldUpdateOperationsInput | string
    examtimeTaken?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    qnModelSet?: qnModelSetUpdateOneRequiredWithoutGivenExamsNestedInput
  }

  export type userGivenExamSetUncheckedUpdateWithoutUserInput = {
    id?: IntFieldUpdateOperationsInput | number
    qn_set_id?: IntFieldUpdateOperationsInput | number
    qn_ans?: JsonNullValueInput | InputJsonValue
    qn_title?: StringFieldUpdateOperationsInput | string
    obtainedMarks?: StringFieldUpdateOperationsInput | string
    examtimeTaken?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type userGivenExamSetUncheckedUpdateManyWithoutUserInput = {
    id?: IntFieldUpdateOperationsInput | number
    qn_set_id?: IntFieldUpdateOperationsInput | number
    qn_ans?: JsonNullValueInput | InputJsonValue
    qn_title?: StringFieldUpdateOperationsInput | string
    obtainedMarks?: StringFieldUpdateOperationsInput | string
    examtimeTaken?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type userSelectedCourseUpdateWithoutUserInput = {
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    course?: CourseUpdateOneRequiredWithoutSelectedByNestedInput
  }

  export type userSelectedCourseUncheckedUpdateWithoutUserInput = {
    id?: IntFieldUpdateOperationsInput | number
    course_id?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type userSelectedCourseUncheckedUpdateManyWithoutUserInput = {
    id?: IntFieldUpdateOperationsInput | number
    course_id?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type CourseCreateManyCategoryInput = {
    id?: number
    course_name: string
    status?: $Enums.Status
    tag?: CourseCreatetagInput | string[]
    createdAt?: Date | string
    modifiedAt?: Date | string | null
  }

  export type CourseUpdateWithoutCategoryInput = {
    course_name?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: CourseUpdatetagInput | string[]
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    qnModels?: qnModelSetUpdateManyWithoutCourseNestedInput
    selectedBy?: userSelectedCourseUpdateManyWithoutCourseNestedInput
  }

  export type CourseUncheckedUpdateWithoutCategoryInput = {
    id?: IntFieldUpdateOperationsInput | number
    course_name?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: CourseUpdatetagInput | string[]
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    qnModels?: qnModelSetUncheckedUpdateManyWithoutCourseNestedInput
    selectedBy?: userSelectedCourseUncheckedUpdateManyWithoutCourseNestedInput
  }

  export type CourseUncheckedUpdateManyWithoutCategoryInput = {
    id?: IntFieldUpdateOperationsInput | number
    course_name?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: CourseUpdatetagInput | string[]
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type qnModelSetCreateManyCourseInput = {
    id?: number
    qn_title: string
    modelset_info: JsonNullValueInput | InputJsonValue
    qn_set: JsonNullValueInput | InputJsonValue
    exam_time: string
    status?: $Enums.Status
    tag?: qnModelSetCreatetagInput | string[]
    createBy: string
    createdAt?: Date | string
    modifiedAt?: Date | string | null
  }

  export type userSelectedCourseCreateManyCourseInput = {
    id?: number
    user_id: number
    createdAt?: Date | string
    modifiedAt?: Date | string | null
  }

  export type qnModelSetUpdateWithoutCourseInput = {
    qn_title?: StringFieldUpdateOperationsInput | string
    modelset_info?: JsonNullValueInput | InputJsonValue
    qn_set?: JsonNullValueInput | InputJsonValue
    exam_time?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: qnModelSetUpdatetagInput | string[]
    createBy?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    givenExams?: userGivenExamSetUpdateManyWithoutQnModelSetNestedInput
  }

  export type qnModelSetUncheckedUpdateWithoutCourseInput = {
    id?: IntFieldUpdateOperationsInput | number
    qn_title?: StringFieldUpdateOperationsInput | string
    modelset_info?: JsonNullValueInput | InputJsonValue
    qn_set?: JsonNullValueInput | InputJsonValue
    exam_time?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: qnModelSetUpdatetagInput | string[]
    createBy?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    givenExams?: userGivenExamSetUncheckedUpdateManyWithoutQnModelSetNestedInput
  }

  export type qnModelSetUncheckedUpdateManyWithoutCourseInput = {
    id?: IntFieldUpdateOperationsInput | number
    qn_title?: StringFieldUpdateOperationsInput | string
    modelset_info?: JsonNullValueInput | InputJsonValue
    qn_set?: JsonNullValueInput | InputJsonValue
    exam_time?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    tag?: qnModelSetUpdatetagInput | string[]
    createBy?: StringFieldUpdateOperationsInput | string
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type userSelectedCourseUpdateWithoutCourseInput = {
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    user?: UserUpdateOneRequiredWithoutSelectedCoursesNestedInput
  }

  export type userSelectedCourseUncheckedUpdateWithoutCourseInput = {
    id?: IntFieldUpdateOperationsInput | number
    user_id?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type userSelectedCourseUncheckedUpdateManyWithoutCourseInput = {
    id?: IntFieldUpdateOperationsInput | number
    user_id?: IntFieldUpdateOperationsInput | number
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type userGivenExamSetCreateManyQnModelSetInput = {
    id?: number
    user_id: number
    qn_ans: JsonNullValueInput | InputJsonValue
    qn_title: string
    obtainedMarks: string
    examtimeTaken: string
    status?: $Enums.Status
    createdAt?: Date | string
    modifiedAt?: Date | string | null
  }

  export type userGivenExamSetUpdateWithoutQnModelSetInput = {
    qn_ans?: JsonNullValueInput | InputJsonValue
    qn_title?: StringFieldUpdateOperationsInput | string
    obtainedMarks?: StringFieldUpdateOperationsInput | string
    examtimeTaken?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    user?: UserUpdateOneRequiredWithoutExamSetsNestedInput
  }

  export type userGivenExamSetUncheckedUpdateWithoutQnModelSetInput = {
    id?: IntFieldUpdateOperationsInput | number
    user_id?: IntFieldUpdateOperationsInput | number
    qn_ans?: JsonNullValueInput | InputJsonValue
    qn_title?: StringFieldUpdateOperationsInput | string
    obtainedMarks?: StringFieldUpdateOperationsInput | string
    examtimeTaken?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type userGivenExamSetUncheckedUpdateManyWithoutQnModelSetInput = {
    id?: IntFieldUpdateOperationsInput | number
    user_id?: IntFieldUpdateOperationsInput | number
    qn_ans?: JsonNullValueInput | InputJsonValue
    qn_title?: StringFieldUpdateOperationsInput | string
    obtainedMarks?: StringFieldUpdateOperationsInput | string
    examtimeTaken?: StringFieldUpdateOperationsInput | string
    status?: EnumStatusFieldUpdateOperationsInput | $Enums.Status
    createdAt?: DateTimeFieldUpdateOperationsInput | Date | string
    modifiedAt?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }



  /**
   * Batch Payload for updateMany & deleteMany & createMany
   */

  export type BatchPayload = {
    count: number
  }

  /**
   * DMMF
   */
  export const dmmf: runtime.BaseDMMF
}