
import express, { Request, Response, NextFunction } from 'express';
import dotenv from 'dotenv';
import routes from './routers';
import { PrismaClient } from '@prisma/client';
import apiLimiter from './../src/middleware/ratelimit.middleware';



// import './config/db';
// import { errorHandler } from './middleware/error.middleware';
// const pool = require("./config/db");

dotenv.config();

const app = express();

const prisma = new PrismaClient();

app.use(express.json());

app.use('/api', apiLimiter, routes);

app.use('/', (req, response) => { response.send("Hello Kuriloo api once upone time ") })

// app.use(errorHandler);
// 404 is url not found
app.use((req: Request, res: Response, next: NextFunction) => {
    res.status(404).json({
        success: false,
        message: ' url:404 Not Found',
    });
});

// app.use((err: any, req: Request, res: Response, next: NextFunction) => {
//     console.error(err.stack);
//     res.status(500).json({
//         success: false,
//         message: 'Something went wrong!',
//     });
// });


export default app;

