import { Request, Response } from 'express';
import * as authService from './auth.service';

export const registerUser = async (req: Request, res: Response) => {
    try {
        const { name, email, password } = req.body;
        const user = await authService.register(name, email, password);
        res.status(201).json({ message: 'User created', user });
    } catch (e: any) {
        res.status(400).json({ error: e.message });
    }
};

export const loginUser = async (req: Request, res: Response) => {
    try {
        const { email, password } = req.body;
        const result = await authService.login(email, password);
        res.json(result);
    } catch (e: any) {
        res.status(400).json({ error: e.message });
    }
};
