
/**
 * @swagger
 * /api/auth/register:
 *   post:
 *     description: Register a new user
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             type: object
 *             properties:
 *               name:
 *                 type: string
 *               email:
 *                 type: string
 *               password:
 *                 type: string
 *     responses:
 *       201:
 *         description: User registered successfully
 *       400:
 *         description: Invalid input
 */


import { Router } from 'express';
import { registerUser, loginUser } from './auth.controller';

const router = Router();

router.post('/register', registerUser);
router.post('/login', loginUser);

export default router;

