import { Request, Response } from 'express';
import { createUser, getUsers } from '../services/user.service';

export const getAllUsers = async (_req: Request, res: Response) => {
    const users = await getUsers();
    res.json(users);
};
export const createNewUser = async (req: Request, res: Response) => {
    try {
        const user = await createUser(req.body);
        res.status(201).json(user);
        console.log(req.body)
    } catch (e) {
        res.status(400).json({ error: 'User creation failed' });
    }
};

